/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode;

import net.java.dev.joode.ClonedReferences;
import net.java.dev.joode.SimState;
import net.java.dev.joode.util.MathUtils;
import net.java.dev.joode.util.Matrix3;
import net.java.dev.joode.util.Pool;
import net.java.dev.joode.util.Real;
import net.java.dev.joode.util.Vector3;
import org.openmali.vecmath2.Matrix3f;

public class Mass
implements SimState {
    private static final long serialVersionUID = 5599217929907345607L;
    public static final boolean DEBUG = false;
    private boolean fullySymmetrical = false;
    private float mass;
    private float invMass;
    private final Vector3 centerOfMass = new Vector3();
    private final Matrix3 momentOfInertia = new Matrix3();
    private static Matrix3f inv = new Matrix3f();
    public final Matrix3 invI = new Matrix3();
    public static final Pool<Mass> pool = new Pool<Mass>(){

        @Override
        protected Mass constuct() {
            return new Mass(null);
        }

        @Override
        protected void reset(Mass mass) {
            mass.fullySymmetrical = false;
        }
    };
    private MassError massError = MassError.NOERR;

    private Mass() {
    }

    public final void setFullySymmetrical(boolean fullsym) {
        this.fullySymmetrical = fullsym;
    }

    public final boolean isFullySymmetrical() {
        return this.fullySymmetrical;
    }

    public final void setMass(float mass) {
        this.mass = mass;
        this.invMass = 1.0f / this.mass;
    }

    public final float getMass() {
        return this.mass;
    }

    public final float getInverseMass() {
        return this.invMass;
    }

    public final Matrix3 getMomentOfInertia() {
        return this.momentOfInertia;
    }

    public boolean checkMass() {
        if (this.mass <= 0.0f) {
            this.massError = MassError.MASS_GT_ZERO;
            return false;
        }
        if (!MathUtils.dIsPositiveDefinite(this.momentOfInertia, 3)) {
            this.massError = MassError.INTERT_POS_DEFINITE;
            return false;
        }
        Matrix3 I2 = Matrix3.pool.aquire();
        Matrix3 chat = Matrix3.pool.aquire();
        MathUtils.dCROSSMAT_PLUS_MINUS(chat, this.centerOfMass, 4);
        chat.mul(chat, I2);
        int i = 0;
        while (i < 3) {
            I2.m[i] = this.momentOfInertia.m[i] + this.mass * I2.m[i];
            ++i;
        }
        i = 4;
        while (i < 7) {
            I2.m[i] = this.momentOfInertia.m[i] + this.mass * I2.m[i];
            ++i;
        }
        i = 8;
        while (i < 11) {
            I2.m[i] = this.momentOfInertia.m[i] + this.mass * I2.m[i];
            ++i;
        }
        if (!MathUtils.dIsPositiveDefinite(I2, 3)) {
            this.massError = MassError.CENTER_MASS_INCONSISTANT;
            Matrix3.pool.release(I2);
            Matrix3.pool.release(chat);
            return false;
        }
        Matrix3.pool.release(I2);
        Matrix3.pool.release(chat);
        return true;
    }

    public static Mass create(float theMass, float cgx, float cgy, float cgz, float I11, float I22, float I33, float I12, float I13, float I23) {
        Mass mass = new Mass();
        mass.setMass(theMass);
        mass.centerOfMass.set(cgx, cgy, cgz);
        mass.momentOfInertia.set(0, 0, I11);
        mass.momentOfInertia.set(0, 1, I12);
        mass.momentOfInertia.set(0, 2, I13);
        mass.momentOfInertia.set(1, 0, I12);
        mass.momentOfInertia.set(1, 1, I22);
        mass.momentOfInertia.set(1, 2, I23);
        mass.momentOfInertia.set(2, 0, I13);
        mass.momentOfInertia.set(2, 1, I23);
        mass.momentOfInertia.set(2, 2, I33);
        mass.calcInverseMomentOfInertia();
        return mass;
    }

    public static Mass createSphere(float density, float radius) {
        return Mass.createSphereTotal((float)(4.1887903296220665 * (double)radius * (double)radius * (double)radius * (double)density), radius);
    }

    public static Mass createSphereTotal(float total_mass, float radius) {
        Mass mass = new Mass();
        mass.setMass(total_mass);
        float II = 0.4f * total_mass * radius * radius;
        mass.momentOfInertia.set(0, 0, II);
        mass.momentOfInertia.set(1, 1, II);
        mass.momentOfInertia.set(2, 2, II);
        mass.calcInverseMomentOfInertia();
        mass.fullySymmetrical = true;
        return mass;
    }

    public static Mass createSphereHollowTotal(float total_mass, float radius) {
        Mass mass = new Mass();
        mass.setMass(total_mass);
        float II = 0.6666667f * total_mass * radius * radius;
        mass.momentOfInertia.set(0, 0, II);
        mass.momentOfInertia.set(1, 1, II);
        mass.momentOfInertia.set(2, 2, II);
        mass.calcInverseMomentOfInertia();
        mass.fullySymmetrical = true;
        return mass;
    }

    public static Mass createCapsule(float density, int direction, float radius, float length) {
        assert (direction >= 0 && direction <= 3) : "bad direction number";
        Mass mass = new Mass();
        float M1 = (float)Math.PI * radius * radius * length * density;
        float M2 = 4.1887903f * radius * radius * radius * density;
        mass.setMass(M1 + M2);
        float Ia = M1 * 0.25f * radius * radius + 0.083333336f * length * length + M2 * (0.4f * radius * radius + 0.375f * radius * length + 0.25f * length * length);
        float Ib = (M1 * 0.5f + M2 * 0.4f) * radius * radius;
        mass.momentOfInertia.set(0, 0, Ia);
        mass.momentOfInertia.set(1, 1, Ia);
        mass.momentOfInertia.set(2, 2, Ia);
        mass.momentOfInertia.set(direction, direction, Ib);
        mass.calcInverseMomentOfInertia();
        mass.fullySymmetrical = false;
        return mass;
    }

    public static Mass createCapsuleTotal(float total_mass, int direction, float radius, float length) {
        Mass mass = Mass.createCapsule(1.0f, direction, radius, length);
        mass.adjust(total_mass);
        return mass;
    }

    public static Mass createCylinder(float density, int direction, float radius, float length) {
        return Mass.createCylinderTotal((float)Math.PI * radius * radius * length * density, direction, radius, length);
    }

    public static Mass createCylinderTotal(float total_mass, int direction, float radius, float length) {
        assert (direction >= 0 && direction <= 3) : "bad direction number";
        Mass mass = new Mass();
        float r2 = radius * radius;
        mass.setMass(total_mass);
        float I = total_mass * (0.25f * r2 + 0.083333336f * length * length);
        mass.momentOfInertia.set(0, 0, I);
        mass.momentOfInertia.set(1, 1, I);
        mass.momentOfInertia.set(2, 2, I);
        mass.momentOfInertia.set(direction, direction, total_mass * 0.5f * r2);
        mass.calcInverseMomentOfInertia();
        mass.fullySymmetrical = false;
        return mass;
    }

    public static Mass createCylinderHollowTotal(float total_mass, int direction, float radius, float length) {
        Mass mass = new Mass();
        float r2 = radius * radius;
        mass.setMass(total_mass);
        float I = total_mass * (0.5f * r2 + 0.083333336f * length * length);
        mass.momentOfInertia.set(0, 0, I);
        mass.momentOfInertia.set(1, 1, I);
        mass.momentOfInertia.set(2, 2, I);
        mass.momentOfInertia.set(direction - 1, direction - 1, total_mass * r2);
        mass.calcInverseMomentOfInertia();
        mass.fullySymmetrical = false;
        return mass;
    }

    public static Mass createBox(float density, float lx, float ly, float lz) {
        return Mass.createBoxTotal(lx * ly * lz * density, lx, ly, lz);
    }

    public static Mass createBoxTotal(float total_mass, float lx, float ly, float lz) {
        Mass mass = new Mass();
        mass.setMass(total_mass);
        mass.momentOfInertia.set(0, 0, total_mass / 12.0f * (ly * ly + lz * lz));
        mass.momentOfInertia.set(1, 1, total_mass / 12.0f * (lx * lx + lz * lz));
        mass.momentOfInertia.set(2, 2, total_mass / 12.0f * (lx * lx + ly * ly));
        mass.fullySymmetrical = false;
        mass.calcInverseMomentOfInertia();
        return mass;
    }

    public static Mass createBoxTotal(float total_mass, Vector3 l) {
        return Mass.createBoxTotal(total_mass, l.m[0], l.m[1], l.m[2]);
    }

    public void adjust(float newMass) {
        float scale = newMass / this.getMass();
        this.setMass(newMass);
        this.momentOfInertia.scale(scale);
        this.calcInverseMomentOfInertia();
    }

    public void translate(float x, float y, float z) {
        Matrix3 t1 = new Matrix3();
        Matrix3 t2 = new Matrix3();
        Matrix3 chat = new Matrix3();
        MathUtils.dCROSSMAT_PLUS_MINUS(chat, this.centerOfMass, 4);
        Vector3 a = new Vector3(x + this.centerOfMass.m[0], y + this.centerOfMass.m[1], z + this.centerOfMass.m[2]);
        Matrix3 ahat = new Matrix3();
        MathUtils.dCROSSMAT_PLUS_MINUS(ahat, a, 4);
        ahat.mul(ahat, t1);
        chat.mul(chat, t2);
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                float value = this.momentOfInertia.get(i, j);
                this.momentOfInertia.set(i, j, value + this.mass * (t2.get(i, j) - t1.get(i, j)));
                ++j;
            }
            ++i;
        }
        this.momentOfInertia.set(0, 1, this.momentOfInertia.get(1, 0));
        this.momentOfInertia.set(0, 2, this.momentOfInertia.get(2, 0));
        this.momentOfInertia.set(1, 2, this.momentOfInertia.get(2, 1));
        this.calcInverseMomentOfInertia();
        this.centerOfMass.add(x, y, z);
        this.fullySymmetrical = false;
    }

    public Mass rotate(Matrix3 R, Mass passback) {
        passback.mass = this.mass;
        passback.invMass = this.invMass;
        if (this.fullySymmetrical) {
            passback.invI.set(this.invI);
            passback.momentOfInertia.set(this.momentOfInertia);
            passback.centerOfMass.set(this.centerOfMass);
            return passback;
        }
        R.transpose();
        Matrix3 I_rt = Matrix3.pool.aquire();
        Matrix3 I_inv_rt = Matrix3.pool.aquire();
        this.momentOfInertia.mulTranspose(R, I_rt);
        R.mul(I_rt, passback.momentOfInertia);
        passback.momentOfInertia.set(0, 0, R.get(0, 0) * I_rt.get(0, 0) + R.get(0, 1) * I_rt.get(1, 0) + R.get(0, 2) * I_rt.get(2, 0));
        passback.momentOfInertia.set(1, 0, R.get(0, 0) * I_rt.get(0, 1) + R.get(0, 1) * I_rt.get(1, 1) + R.get(0, 2) * I_rt.get(2, 1));
        passback.momentOfInertia.set(2, 0, R.get(0, 0) * I_rt.get(0, 2) + R.get(0, 1) * I_rt.get(1, 2) + R.get(0, 2) * I_rt.get(2, 2));
        passback.momentOfInertia.set(1, 1, R.get(1, 0) * I_rt.get(0, 1) + R.get(1, 1) * I_rt.get(1, 1) + R.get(1, 2) * I_rt.get(2, 1));
        passback.momentOfInertia.set(2, 1, R.get(1, 0) * I_rt.get(0, 2) + R.get(1, 1) * I_rt.get(1, 2) + R.get(1, 2) * I_rt.get(2, 2));
        passback.momentOfInertia.set(2, 2, R.get(2, 0) * I_rt.get(0, 2) + R.get(2, 1) * I_rt.get(1, 2) + R.get(2, 2) * I_rt.get(2, 2));
        passback.momentOfInertia.set(0, 1, passback.momentOfInertia.get(1, 0));
        passback.momentOfInertia.set(0, 2, passback.momentOfInertia.get(2, 0));
        passback.momentOfInertia.set(1, 2, passback.momentOfInertia.get(2, 1));
        this.invI.mulTranspose(R, I_inv_rt);
        passback.invI.set(0, 0, R.get(0, 0) * I_inv_rt.get(0, 0) + R.get(0, 1) * I_inv_rt.get(1, 0) + R.get(0, 2) * I_inv_rt.get(2, 0));
        passback.invI.set(1, 0, R.get(0, 0) * I_inv_rt.get(0, 1) + R.get(0, 1) * I_inv_rt.get(1, 1) + R.get(0, 2) * I_inv_rt.get(2, 1));
        passback.invI.set(2, 0, R.get(0, 0) * I_inv_rt.get(0, 2) + R.get(0, 1) * I_inv_rt.get(1, 2) + R.get(0, 2) * I_inv_rt.get(2, 2));
        passback.invI.set(1, 1, R.get(1, 0) * I_inv_rt.get(0, 1) + R.get(1, 1) * I_inv_rt.get(1, 1) + R.get(1, 2) * I_inv_rt.get(2, 1));
        passback.invI.set(2, 1, R.get(1, 0) * I_inv_rt.get(0, 2) + R.get(1, 1) * I_inv_rt.get(1, 2) + R.get(1, 2) * I_inv_rt.get(2, 2));
        passback.invI.set(2, 2, R.get(2, 0) * I_inv_rt.get(0, 2) + R.get(2, 1) * I_inv_rt.get(1, 2) + R.get(2, 2) * I_inv_rt.get(2, 2));
        passback.invI.set(0, 1, passback.invI.get(1, 0));
        passback.invI.set(0, 2, passback.invI.get(2, 0));
        passback.invI.set(1, 2, passback.invI.get(2, 1));
        Vector3 t2 = Vector3.pool.aquire();
        R.mulInc(this.centerOfMass, t2);
        MathUtils.dMULTIPLY0_331((Real)t2, R, (Real)this.centerOfMass);
        passback.centerOfMass.set(t2);
        Matrix3.pool.release(I_rt);
        Matrix3.pool.release(I_inv_rt);
        Vector3.pool.release(t2);
        R.transpose();
        return passback;
    }

    public void add(Mass b) {
        assert (b != null);
        this.fullySymmetrical = false;
        this.centerOfMass.scale(this.mass);
        this.centerOfMass.add(b.mass * b.centerOfMass.m[0], b.mass * b.centerOfMass.m[1], b.mass * b.centerOfMass.m[2]);
        this.centerOfMass.scale(1.0f / (this.mass + b.mass));
        this.setMass(this.getMass() + b.getMass());
        this.momentOfInertia.add(b.momentOfInertia);
        this.calcInverseMomentOfInertia();
    }

    private void calcInverseMomentOfInertia() {
        inv.setRow(0, this.momentOfInertia.m[0], this.momentOfInertia.m[1], this.momentOfInertia.m[2]);
        inv.setRow(1, this.momentOfInertia.m[4], this.momentOfInertia.m[5], this.momentOfInertia.m[6]);
        inv.setRow(2, this.momentOfInertia.m[8], this.momentOfInertia.m[9], this.momentOfInertia.m[10]);
        inv.invert();
        this.invI.set(0, 0, inv.m00());
        this.invI.set(0, 1, inv.m01());
        this.invI.set(0, 2, inv.m02());
        this.invI.set(1, 0, inv.m10());
        this.invI.set(1, 1, inv.m11());
        this.invI.set(1, 2, inv.m12());
        this.invI.set(2, 0, inv.m20());
        this.invI.set(2, 1, inv.m21());
        this.invI.set(2, 2, inv.m22());
    }

    public Mass cloneState(ClonedReferences util) {
        Mass clone = new Mass();
        util.addClone(this, clone);
        clone.mass = this.mass;
        clone.invMass = this.invMass;
        clone.massError = this.massError;
        clone.centerOfMass.set(this.centerOfMass);
        clone.invI.set(this.invI);
        clone.momentOfInertia.set(this.momentOfInertia);
        clone.fullySymmetrical = this.fullySymmetrical;
        return clone;
    }

    /* synthetic */ Mass(Mass mass) {
        this();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MassError {
        NOERR("No error"),
        MASS_GT_ZERO("mass must be > 0"),
        INTERT_POS_DEFINITE("inertia must be positive definite"),
        CENTER_MASS_INCONSISTANT("center of mass inconsistent with mass parameters");

        private final String message;

        private MassError(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

