/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.collision.collider;

import net.java.dev.joode.collision.ContactGeom;
import net.java.dev.joode.collision.collider.Collider;
import net.java.dev.joode.collision.collider.Colliders;
import net.java.dev.joode.collision.collider.SphereSphereCollider;
import net.java.dev.joode.geom.Capsule;
import net.java.dev.joode.geom.Geom;
import net.java.dev.joode.util.Matrix3;
import net.java.dev.joode.util.Vector3;

public class CapsuleCapsuleCollider
extends Collider {
    public static final CapsuleCapsuleCollider INSTANCE = new CapsuleCapsuleCollider();
    public static final float TOLERANCE = 1.0E-5f;

    public int collide(Geom o1, Geom o2, ContactGeom[] contact, int contactIndex, int skip) {
        Capsule caps1 = (Capsule)o1;
        Capsule caps2 = (Capsule)o2;
        Vector3 caps1Pos = caps1.getPosition();
        Matrix3 caps1Rot = caps1.getRotation();
        Vector3 caps2Pos = caps2.getPosition();
        Matrix3 caps2Rot = caps2.getRotation();
        contact[contactIndex].setGeom1(o1);
        contact[contactIndex].setGeom2(o2);
        float lz1 = caps1.getLength() * 0.5f;
        float lz2 = caps2.getLength() * 0.5f;
        Vector3 axis1 = new Vector3(caps1Rot.get(2, 0), caps1Rot.get(2, 1), caps1Rot.get(2, 2));
        Vector3 axis2 = new Vector3(caps2Rot.get(2, 0), caps2Rot.get(2, 1), caps2Rot.get(2, 2));
        Vector3 sphere1 = new Vector3();
        Vector3 sphere2 = new Vector3();
        float a1a2 = axis1.dot(axis2);
        float det = 1.0f - a1a2 * a1a2;
        if (det < 1.0E-5f) {
            float hi;
            if (a1a2 < 0.0f) {
                axis2.scale(-1.0f);
            }
            Vector3 q = new Vector3(caps1Pos.getX() - caps2Pos.getX(), caps1Pos.getY() - caps2Pos.getY(), caps1Pos.getZ() - caps2Pos.getZ());
            float k = axis1.dot(q);
            float a1lo = -lz1;
            float a1hi = lz1;
            float a2lo = -lz2 - k;
            float a2hi = lz2 - k;
            float lo = a1lo > a2lo ? a1lo : a2lo;
            float f = hi = a1hi < a2hi ? a1hi : a2hi;
            if (lo <= hi) {
                int num_contacts = contact.length - contactIndex;
                if (num_contacts >= 2 && lo < hi) {
                    sphere1.set(caps1Pos.getX() + lo * axis1.getX(), caps1Pos.getY() + lo * axis1.getY(), caps1Pos.getZ() + lo * axis1.getZ());
                    sphere2.set(caps2Pos.getX() + (lo + k) * axis2.getX(), caps2Pos.getY() + (lo + k) * axis2.getY(), caps2Pos.getZ() + (lo + k) * axis2.getZ());
                    int n1 = SphereSphereCollider.collideSpheres(sphere1, caps1.getRadius(), sphere2, caps2.getRadius(), contact, contactIndex, o1.hashCode(), o2.hashCode());
                    if (n1 > 0) {
                        sphere1.set(caps1Pos.getX() + hi * axis1.getX(), caps1Pos.getY() + hi * axis1.getY(), caps1Pos.getZ() + hi * axis1.getZ());
                        sphere2.set(caps2Pos.getX() + (hi + k) * axis2.getX(), caps2Pos.getY() + (hi + k) * axis2.getY(), caps2Pos.getZ() + (hi + k) * axis2.getZ());
                        int n2 = SphereSphereCollider.collideSpheres(sphere1, caps1.getRadius(), sphere2, caps2.getRadius(), contact, contactIndex + 1, o1.hashCode(), o2.hashCode());
                        if (n2 > 0) {
                            contact[contactIndex + 1].setGeom1(o1);
                            contact[contactIndex + 1].setGeom2(o2);
                            return 2;
                        }
                    }
                }
                float alpha1 = (lo + hi) * 0.5f;
                float alpha2 = alpha1 + k;
                sphere1.set(caps1Pos.getX() + alpha1 * axis1.getX(), caps1Pos.getY() + alpha1 * axis1.getY(), caps1Pos.getZ() + alpha1 * axis1.getZ());
                sphere2.set(caps2Pos.getX() + alpha2 * axis2.getX(), caps2Pos.getY() + alpha2 * axis2.getY(), caps2Pos.getZ() + alpha2 * axis2.getZ());
                return SphereSphereCollider.collideSpheres(sphere1, caps1.getRadius(), sphere2, caps2.getRadius(), contact, contactIndex, o1.hashCode(), o2.hashCode());
            }
        }
        Vector3 a1 = new Vector3(caps1Pos.getX() + axis1.getX() * lz1, caps1Pos.getY() + axis1.getY() * lz1, caps1Pos.getZ() + axis1.getZ() * lz1);
        Vector3 a2 = new Vector3(caps1Pos.getX() - axis1.getX() * lz1, caps1Pos.getY() - axis1.getY() * lz1, caps1Pos.getZ() - axis1.getZ() * lz1);
        Vector3 b1 = new Vector3(caps2Pos.getX() + axis2.getX() * lz2, caps2Pos.getY() + axis2.getY() * lz2, caps2Pos.getZ() + axis2.getZ() * lz2);
        Vector3 b2 = new Vector3(caps2Pos.getX() - axis2.getX() * lz2, caps2Pos.getY() - axis2.getY() * lz2, caps2Pos.getZ() - axis2.getZ() * lz2);
        Colliders.closestLineSegmentPoints(a1, a2, b1, b2, sphere1, sphere2);
        return SphereSphereCollider.collideSpheres(sphere1, caps1.getRadius(), sphere2, caps2.getRadius(), contact, contactIndex, o1.hashCode(), o2.hashCode());
    }
}

