/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.collision.collider;

import net.java.dev.joode.collision.ContactGeom;
import net.java.dev.joode.collision.collider.Collider;
import net.java.dev.joode.geom.Capsule;
import net.java.dev.joode.geom.Geom;
import net.java.dev.joode.geom.Plane;
import net.java.dev.joode.util.Matrix3;
import net.java.dev.joode.util.Vector3;

public class CapsulePlaneCollider
extends Collider {
    public static final CapsulePlaneCollider INSTANCE = new CapsulePlaneCollider();

    public int collide(Geom o1, Geom o2, ContactGeom[] contact, int contactIndex, int skip) {
        Capsule capsule = (Capsule)o1;
        Plane plane = (Plane)o2;
        Vector3 capsPos = capsule.getPosition();
        Matrix3 capsRot = capsule.getRotation();
        float sign = plane.p.dot(capsRot.getColumn(2)) > 0.0f ? -1 : 1;
        Vector3 p = new Vector3();
        p.setX(capsPos.getX() + capsRot.m[2] * capsule.getLength() * 0.5f * sign);
        p.setY(capsPos.getY() + capsRot.m[6] * capsule.getLength() * 0.5f * sign);
        p.setZ(capsPos.getZ() + capsRot.m[10] * capsule.getLength() * 0.5f * sign);
        float k = p.dot(plane.p);
        float depth = plane.p.m[3] - k + capsule.getRadius();
        if (depth < 0.0f) {
            return 0;
        }
        contact[contactIndex].setNormal(plane.p);
        contact[contactIndex].getPosition().set(p.m[0] - plane.p.m[0] * capsule.getRadius(), p.m[1] - plane.p.m[1] * capsule.getRadius(), p.m[2] - plane.p.m[2] * capsule.getRadius());
        contact[contactIndex].setDepth(depth);
        int ncontacts = 1;
        if (contact.length - contactIndex >= 2) {
            p.setX(capsPos.getX() - capsRot.m[2] * capsule.getLength() * 0.5f * sign);
            p.setY(capsPos.getY() - capsRot.m[6] * capsule.getLength() * 0.5f * sign);
            p.setZ(capsPos.getZ() - capsRot.m[10] * capsule.getLength() * 0.5f * sign);
            k = p.dot(plane.p);
            depth = plane.p.m[3] - k + capsule.getRadius();
            if (depth >= 0.0f) {
                contact[contactIndex + 1].setNormal(plane.p);
                contact[contactIndex + 1].getPosition().set(p.m[0] - plane.p.m[0] * capsule.getRadius(), p.m[1] - plane.p.m[1] * capsule.getRadius(), p.m[2] - plane.p.m[2] * capsule.getRadius());
                contact[contactIndex + 1].setDepth(depth);
                ncontacts = 2;
            }
        }
        int i = 0;
        while (i < ncontacts) {
            contact[contactIndex + i].setGeom1(o1);
            contact[contactIndex + i].setGeom2(o2);
            ++i;
        }
        return ncontacts;
    }
}

