/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.collision.collider;

import net.java.dev.joode.collision.ContactGeom;
import net.java.dev.joode.collision.collider.Collider;
import net.java.dev.joode.geom.Cylinder;
import net.java.dev.joode.geom.Geom;
import net.java.dev.joode.geom.Plane;
import net.java.dev.joode.util.Matrix3;
import net.java.dev.joode.util.Vector3;

public class CylinderPlaneCollider
extends Collider {
    public static final CylinderPlaneCollider INSTANCE = new CylinderPlaneCollider();
    public static final float TOLERANCE = 0.001f;

    public int collide(Geom o1, Geom o2, ContactGeom[] contact, int contactIndex, int skip) {
        Vector3 pos1;
        float dist1;
        Cylinder cyl = (Cylinder)o1;
        Plane plane = (Plane)o2;
        Vector3 cylPos = cyl.getPosition();
        Matrix3 cylRot = cyl.getRotation();
        Vector3 axis = new Vector3(cylRot.m[2], cylRot.m[6], cylRot.m[10]);
        Vector3 normal = plane.getNormal();
        float a = Math.abs(axis.dot(normal));
        if (a < 0.001f) {
            float dist = plane.getDistance(cylPos);
            if (Math.abs(dist) > cyl.getRadius()) {
                return 0;
            }
            float hl = cyl.getLength() * 0.5f;
            Vector3 pos0 = new Vector3(cylPos.getX() + axis.getX() * hl - normal.getX() * cyl.getRadius(), cylPos.getY() + axis.getY() * hl - normal.getY() * cyl.getRadius(), cylPos.getZ() + axis.getZ() * hl - normal.getZ() * cyl.getRadius());
            contact[contactIndex].setGeom1(o1);
            contact[contactIndex].setGeom2(o2);
            contact[contactIndex].setNormal(normal);
            contact[contactIndex].setPosition(pos0);
            contact[contactIndex].setDepth(cyl.getRadius() - dist);
            if (contact.length - contactIndex < 1) {
                return 1;
            }
            Vector3 pos12 = new Vector3(cylPos.getX() - axis.getX() * hl - normal.getX() * cyl.getRadius(), cylPos.getY() - axis.getY() * hl - normal.getY() * cyl.getRadius(), cylPos.getZ() - axis.getZ() * hl - normal.getZ() * cyl.getRadius());
            contact[contactIndex + 1].setGeom1(o1);
            contact[contactIndex + 1].setGeom2(o2);
            contact[contactIndex + 1].setNormal(normal);
            contact[contactIndex + 1].setPosition(pos12);
            contact[contactIndex + 1].setDepth(cyl.getRadius() - dist);
            return 2;
        }
        if (1.0f - a < 0.001f) {
            Vector3 pos13;
            float dist12;
            float hl = cyl.getLength() * 0.5f;
            Vector3 pos0 = new Vector3(cylPos.getX() + axis.getX() * hl, cylPos.getY() + axis.getY() * hl, cylPos.getZ() + axis.getZ() * hl);
            float dist0 = plane.getDistance(pos0);
            if (dist0 < (dist12 = plane.getDistance(pos13 = new Vector3(cylPos.getX() - axis.getX() * hl, cylPos.getY() - axis.getY() * hl, cylPos.getZ() - axis.getZ() * hl)))) {
                if (dist0 < 0.0f && dist0 + hl > 0.0f) {
                    contact[contactIndex].setGeom1(o1);
                    contact[contactIndex].setGeom2(o2);
                    contact[contactIndex].setNormal(normal);
                    contact[contactIndex].setPosition(pos0);
                    contact[contactIndex].setDepth(-dist0);
                    return 1;
                }
            } else if (dist12 < 0.0f && dist12 + hl > 0.0f) {
                contact[contactIndex].setGeom1(o1);
                contact[contactIndex].setGeom2(o2);
                contact[contactIndex].setNormal(normal);
                contact[contactIndex].setPosition(pos13);
                contact[contactIndex].setDepth(-dist12);
                return 1;
            }
            return 0;
        }
        float hl = cyl.getLength() * 0.5f;
        float c = 1.0f - a * a;
        Vector3 pos0 = new Vector3(cylPos.getX() + axis.getX() * hl - cyl.getRadius() * normal.getX() * c, cylPos.getY() + axis.getY() * hl - cyl.getRadius() * normal.getY() * c, cylPos.getZ() + axis.getZ() * hl - cyl.getRadius() * normal.getZ() * c);
        float dist0 = plane.getDistance(pos0);
        if (dist0 < (dist1 = plane.getDistance(pos1 = new Vector3(cylPos.getX() - axis.getX() * hl - cyl.getRadius() * normal.getX() * c, cylPos.getY() - axis.getY() * hl - cyl.getRadius() * normal.getY() * c, cylPos.getZ() - axis.getZ() * hl - cyl.getRadius() * normal.getZ() * c)))) {
            if (dist0 < 0.0f && dist0 + hl > 0.0f) {
                contact[contactIndex].setGeom1(o1);
                contact[contactIndex].setGeom2(o2);
                contact[contactIndex].setNormal(normal);
                contact[contactIndex].setPosition(pos0);
                contact[contactIndex].setDepth(-dist0);
                return 1;
            }
        } else if (dist1 < 0.0f && dist1 + hl > 0.0f) {
            contact[contactIndex].setGeom1(o1);
            contact[contactIndex].setGeom2(o2);
            contact[contactIndex].setNormal(normal);
            contact[contactIndex].setPosition(pos1);
            contact[contactIndex].setDepth(-dist1);
            return 1;
        }
        return 0;
    }
}

