/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.collision.collider;

import net.java.dev.joode.collision.ContactGeom;
import net.java.dev.joode.collision.collider.Collider;
import net.java.dev.joode.geom.Circle;
import net.java.dev.joode.geom.Geom;
import net.java.dev.joode.geom.Rectangle;
import net.java.dev.joode.util.Line2D;
import net.java.dev.joode.util.Math2D;
import net.java.dev.joode.util.Vector2;

public strictfp class RectangleCircleCollider
extends Collider {
    public static final float[][] pts = new float[4][2];
    public static final Vector2 circPos = new Vector2();
    public static final Vector2 contactPoint = new Vector2();
    public static final Vector2 normal = new Vector2();
    public static final Collider INSTANCE = new RectangleCircleCollider();

    private RectangleCircleCollider() {
    }

    public int collideRectangleCircle(ContactGeom[] contacts, Rectangle rect, Circle circ, int contactIndex) {
        rect.getVetex(0, pts[0]);
        rect.getVetex(1, pts[1]);
        rect.getVetex(2, pts[2]);
        rect.getVetex(3, pts[3]);
        Line2D[] lines = new Line2D[]{new Line2D(pts[0], pts[1]), new Line2D(pts[1], pts[2]), new Line2D(pts[2], pts[3]), new Line2D(pts[3], pts[0])};
        float r2 = circ.getRadius() * circ.getRadius();
        int closest = -1;
        float closestDistance = Float.MAX_VALUE;
        circPos.set(circ.getPosition());
        int i = 0;
        while (i < 4) {
            float dis = lines[i].distanceSquared(circPos);
            if (dis < r2 && closestDistance > dis) {
                closestDistance = dis;
                closest = i;
            }
            ++i;
        }
        if (closest > -1) {
            float dis = (float)Math.sqrt(closestDistance);
            contacts[contactIndex].setDepth(dis - circ.getRadius());
            lines[closest].getClosestPoint(circPos, contactPoint);
            Math2D.sub(circPos, contactPoint, normal);
            normal.normalise();
            normal.scale(-1.0f);
            contacts[contactIndex].setNormal(RectangleCircleCollider.normal.x, RectangleCircleCollider.normal.y, 0.0f);
            contacts[contactIndex].setPosition(RectangleCircleCollider.contactPoint.x, RectangleCircleCollider.contactPoint.y, 0.0f);
            return 1;
        }
        return 0;
    }

    public int collide(Geom o1, Geom o2, ContactGeom[] contact, int contactIndex, int skip) {
        Rectangle rect = (Rectangle)o1;
        Circle circle = (Circle)o2;
        contact[contactIndex].setGeom1(rect);
        contact[contactIndex].setGeom2(circle);
        return this.collideRectangleCircle(contact, rect, circle, contactIndex);
    }
}

