/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.collision.collider;

import net.java.dev.joode.collision.ContactGeom;
import net.java.dev.joode.collision.collider.Collider;
import net.java.dev.joode.geom.Geom;
import net.java.dev.joode.geom.Plane;
import net.java.dev.joode.geom.Sphere;

public class SpherePlaneCollider
extends Collider {
    public static final SpherePlaneCollider INSTANCE = new SpherePlaneCollider();

    public int collide(Geom o1, Geom o2, ContactGeom[] contact, int contactIndex, int skip) {
        Sphere sphere = (Sphere)o1;
        Plane plane = (Plane)o2;
        contact[contactIndex].setGeom1(o1);
        contact[contactIndex].setGeom2(o2);
        float k = o1.getPosition().dot(plane.p);
        float depth = plane.p.m[3] - k + sphere.getRadius();
        if (depth >= 0.0f) {
            contact[contactIndex].setNormal(plane.p);
            contact[contactIndex].getPosition().m[0] = o1.getPosition().m[0] - plane.p.m[0] * sphere.getRadius();
            contact[contactIndex].getPosition().m[1] = o1.getPosition().m[1] - plane.p.m[1] * sphere.getRadius();
            contact[contactIndex].getPosition().m[2] = o1.getPosition().m[2] - plane.p.m[2] * sphere.getRadius();
            contact[contactIndex].setDepth(depth);
            contact[contactIndex].jitter();
            return 1;
        }
        return 0;
    }
}

