/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.collision.collider;

import net.java.dev.joode.collision.ContactGeom;
import net.java.dev.joode.collision.collider.Collider;
import net.java.dev.joode.collision.collider.TriMeshTriMeshCollider;
import net.java.dev.joode.geom.Box;
import net.java.dev.joode.geom.Geom;
import net.java.dev.joode.geom.TriMesh;
import net.java.dev.joode.util.Matrix3;
import net.java.dev.joode.util.Vector3;

public class TriMeshBoxCollider
extends Collider {
    public static final TriMeshBoxCollider INSTANCE = new TriMeshBoxCollider();
    private final TriMesh boxmesh = TriMeshBoxCollider.buildBox();

    private static TriMesh buildBox() {
        Vector3[] vertices = new Vector3[]{new Vector3(-1.0f, -1.0f, -1.0f), new Vector3(-1.0f, -1.0f, 1.0f), new Vector3(-1.0f, 1.0f, -1.0f), new Vector3(-1.0f, 1.0f, 1.0f), new Vector3(1.0f, -1.0f, -1.0f), new Vector3(1.0f, -1.0f, 1.0f), new Vector3(1.0f, 1.0f, -1.0f), new Vector3(1.0f, 1.0f, 1.0f)};
        int[] nArray = new int[36];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 2;
        nArray[4] = 1;
        nArray[5] = 3;
        nArray[6] = 5;
        nArray[7] = 6;
        nArray[8] = 7;
        nArray[9] = 6;
        nArray[10] = 5;
        nArray[11] = 4;
        nArray[13] = 2;
        nArray[14] = 4;
        nArray[15] = 4;
        nArray[16] = 2;
        nArray[17] = 6;
        nArray[18] = 3;
        nArray[19] = 1;
        nArray[20] = 5;
        nArray[21] = 3;
        nArray[22] = 5;
        nArray[23] = 7;
        nArray[25] = 4;
        nArray[26] = 1;
        nArray[27] = 1;
        nArray[28] = 4;
        nArray[29] = 5;
        nArray[30] = 2;
        nArray[31] = 3;
        nArray[32] = 6;
        nArray[33] = 3;
        nArray[34] = 7;
        nArray[35] = 6;
        int[] indices = nArray;
        return new TriMesh(null, true, vertices, indices);
    }

    public int collide(Geom o1, Geom o2, ContactGeom[] contacts, int contactIndex, int skip) {
        TriMesh t = (TriMesh)o1;
        Box b = (Box)o2;
        Matrix3 scale = new Matrix3();
        Vector3 side = b.getSide();
        scale.set(0, 0, side.getX() / 2.0f);
        scale.set(1, 1, side.getY() / 2.0f);
        scale.set(2, 2, side.getZ() / 2.0f);
        scale.mul(b.getRotation());
        this.boxmesh.setPosition(b.getPosition());
        this.boxmesh.setRotation(scale);
        this.boxmesh.computeAABB();
        int n = TriMeshTriMeshCollider.INSTANCE.collide(t, this.boxmesh, contacts, contactIndex, skip);
        int i = 0;
        while (i < n) {
            if (contacts[contactIndex + i].getGeom1() == this.boxmesh) {
                contacts[contactIndex + n].setGeom1(b);
            } else {
                contacts[contactIndex + i].setGeom2(b);
            }
            ++i;
        }
        return n;
    }
}

