/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.collision.collider;

import net.java.dev.joode.collision.ContactGeom;
import net.java.dev.joode.collision.collider.Collider;
import net.java.dev.joode.geom.Geom;
import net.java.dev.joode.geom.Sphere;
import net.java.dev.joode.geom.TriMesh;
import net.java.dev.joode.util.AABB3f;
import net.java.dev.joode.util.Vector3;
import net.java.dev.joode.util.Vector4;

public class TriMeshSphereCollider
extends Collider {
    public static final TriMeshSphereCollider INSTANCE = new TriMeshSphereCollider();
    private final TriMesh.TriangleData tdata = new TriMesh.TriangleData();
    private TriMesh tmesh;
    private final AABB3f saabb = new AABB3f();

    public int collide(Geom o1, Geom o2, ContactGeom[] contacts, int contactIndex, int skip) {
        this.tmesh = (TriMesh)o1;
        Sphere s = (Sphere)o2;
        int n = 0;
        this.saabb.set(s.getAABB());
        for (int i : this.tmesh.getAABBSet().findIntersections(this.saabb)) {
            this.tmesh.getTriangleData(i, this.tdata);
            n += this.collide(this.tdata, s, contacts, contactIndex + n);
            if (contactIndex + n == contacts.length) break;
        }
        return n;
    }

    public int collide(TriMesh.TriangleData tri, Sphere s, ContactGeom[] contacts, int contactIndex) {
        ContactGeom contact = contacts[contactIndex];
        contact.setGeom1(this.tmesh);
        contact.setGeom2(s);
        float radius = s.getRadius();
        Vector4 normal = tri.planes.facePlane;
        float dis = TriMesh.distanceFromPlane(s.getPosition(), normal);
        if (dis < -radius || dis > radius) {
            return 0;
        }
        contact.setDepth(dis);
        float dismax = radius * radius - dis * dis;
        int most_edge = 4;
        float max_dis = 0.0f;
        dis = -TriMesh.distanceFromPlane(s.getPosition(), tri.planes.edgePlane1);
        if (dis > 0.0f && dis * dis > dismax) {
            return 0;
        }
        if (dis > 0.0f) {
            max_dis = dis;
            most_edge = 0;
        }
        if ((dis = -TriMesh.distanceFromPlane(s.getPosition(), tri.planes.edgePlane2)) > 0.0f && dis * dis > dismax) {
            return 0;
        }
        if (dis > max_dis) {
            max_dis = dis;
            most_edge = 1;
        }
        if ((dis = -TriMesh.distanceFromPlane(s.getPosition(), tri.planes.edgePlane3)) > 0.0f && dis * dis > dismax) {
            return 0;
        }
        if (dis > max_dis) {
            max_dis = dis;
            most_edge = 2;
        }
        max_dis *= -1.0f;
        if (most_edge == 4) {
            contact.setNormal(normal);
            contact.getNormal().scale(-1.0f);
            contact.setPosition(normal);
            if (contact.getDepth() >= 0.0f) {
                contact.getPosition().scale(radius);
            } else {
                contact.getPosition().scale(-radius);
            }
            contact.setDepth(radius - contact.getDepth());
            contact.getPosition().add(s.getPosition());
            return 1;
        }
        Vector3 e1 = Vector3.aquire();
        Vector3 e2 = Vector3.aquire();
        e1.set(tri.vertices[most_edge]);
        e2.set(tri.vertices[(most_edge + 1) % 3]);
        e2.sub(e1);
        contact.setPosition(s.getPosition());
        contact.getPosition().sub(e1);
        float scale = e2.dot(contact.getPosition()) / e2.dot(e2);
        if (scale < 0.0f) {
            contact.setPosition(tri.vertices[most_edge]);
        } else if (scale > 1.0f) {
            contact.setPosition(tri.vertices[(most_edge + 1) % 3]);
        } else {
            contact.setPosition(e2);
            contact.getPosition().scale(scale);
            contact.getPosition().add(e1);
        }
        e1.set(s.getPosition());
        e1.sub(contact.getPosition());
        dis = e1.length();
        if (dis > radius) {
            return 0;
        }
        contact.setDepth(radius - dis);
        if (dis < 0.001f) {
            if (most_edge == 0) {
                contact.setNormal(tri.planes.edgePlane1);
            }
            if (most_edge == 1) {
                contact.setNormal(tri.planes.edgePlane2);
            }
            if (most_edge == 2) {
                contact.setNormal(tri.planes.edgePlane3);
            }
            contact.setPosition(contact.getNormal());
            contact.getPosition().scale(-radius);
            contact.getPosition().add(s.getPosition());
        } else {
            contact.setNormal(e1);
            contact.getNormal().scale(-1.0f / dis);
            contact.setPosition(contact.getNormal());
            contact.getPosition().scale(-radius);
            contact.getPosition().add(s.getPosition());
        }
        e1.release();
        e2.release();
        return 1;
    }
}

