/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.collision.collider;

import java.util.Arrays;
import java.util.Collection;
import net.java.dev.joode.collision.Contact;
import net.java.dev.joode.collision.ContactGeom;
import net.java.dev.joode.collision.collider.Collider;
import net.java.dev.joode.geom.Geom;
import net.java.dev.joode.geom.TriMesh;
import net.java.dev.joode.util.AABBSet;
import net.java.dev.joode.util.Vector3;
import net.java.dev.joode.util.Vector4;

public class TriMeshTriMeshCollider
extends Collider {
    public static final TriMeshTriMeshCollider INSTANCE = new TriMeshTriMeshCollider();
    private static final int MAX_CLIPPED_VERTICES = 8;
    private static final float EPSILON = 1.0E-7f;
    private TriMesh.TriangleData tri1 = new TriMesh.TriangleData();
    private TriMesh.TriangleData tri2 = new TriMesh.TriangleData();
    private Vector3[] clippedVertices1 = TriMeshTriMeshCollider.allocPoints();
    private Vector3[] clippedVertices2 = TriMeshTriMeshCollider.allocPoints();
    private Vector3[] deepestVertices1 = TriMeshTriMeshCollider.allocPoints();
    private Vector3[] deepestVertices2 = TriMeshTriMeshCollider.allocPoints();
    private Vector3[] tempVertices = TriMeshTriMeshCollider.allocPoints();
    private final float[] maxdepths2 = new float[3];
    private final float[] maxdepths1 = new float[3];
    private final Vector3[] intersections2 = new Vector3[2];
    private final Vector3[] intersections1 = new Vector3[2];
    private final int[] depthchoice2 = new int[3];
    private final int[] depthchoice1 = new int[3];
    private int[] candidateDeepestPoints = new int[8];
    private static final float CONTACT_DIFF_EPSILON = 1.0E-5f;

    private static Vector3[] allocPoints() {
        Vector3[] points = new Vector3[8];
        int i = 0;
        while (i < 8) {
            points[i] = new Vector3();
            ++i;
        }
        return points;
    }

    private TriMeshTriMeshCollider() {
        this.intersections2[0] = new Vector3();
        this.intersections2[1] = new Vector3();
        this.intersections1[0] = new Vector3();
        this.intersections1[1] = new Vector3();
    }

    public int collide(Geom o1, Geom o2, ContactGeom[] contacts, int contactIndex, int skip) {
        TriMesh mesh1 = (TriMesh)o1;
        TriMesh mesh2 = (TriMesh)o2;
        Collection<AABBSet.ElementPair> collisionPairs = mesh1.getAABBSet().findIntersections(mesh2.getAABBSet());
        if (collisionPairs.size() == 0) {
            return 0;
        }
        int n = 0;
        for (AABBSet.ElementPair collision : collisionPairs) {
            mesh1.getTriangleData(collision.getIndex1(), this.tri1);
            mesh2.getTriangleData(collision.getIndex2(), this.tri2);
            n += this.addContacts(mesh1, mesh2, this.tri1, this.tri2, contacts, contactIndex + n);
            if (contactIndex + n == contacts.length) break;
        }
        n = this.mergeDuplicateContacts(contacts, contactIndex, n);
        return n;
    }

    private int addContacts(TriMesh mesh1, TriMesh mesh2, TriMesh.TriangleData tri1, TriMesh.TriangleData tri2, ContactGeom[] contacts, int contactIndex) {
        if (!TriMesh.crossesPlane(tri1.vertices, tri2.planes.facePlane, this.intersections2) || !TriMesh.crossesPlane(tri2.vertices, tri1.planes.facePlane, this.intersections1)) {
            return 0;
        }
        this.maxdepths2[0] = this.depthmax(TriMesh.distanceFromPlane(this.intersections2[0], tri2.planes.edgePlane1), TriMesh.distanceFromPlane(this.intersections2[1], tri2.planes.edgePlane1), this.depthchoice1, 0);
        if (this.maxdepths2[0] < 0.0f) {
            return 0;
        }
        this.maxdepths2[1] = this.depthmax(TriMesh.distanceFromPlane(this.intersections2[0], tri2.planes.edgePlane2), TriMesh.distanceFromPlane(this.intersections2[1], tri2.planes.edgePlane2), this.depthchoice1, 1);
        if (this.maxdepths2[1] < 0.0f) {
            return 0;
        }
        this.maxdepths2[2] = this.depthmax(TriMesh.distanceFromPlane(this.intersections2[0], tri2.planes.edgePlane3), TriMesh.distanceFromPlane(this.intersections2[1], tri2.planes.edgePlane3), this.depthchoice1, 2);
        if (this.maxdepths2[2] < 0.0f) {
            return 0;
        }
        this.maxdepths1[0] = this.depthmax(TriMesh.distanceFromPlane(this.intersections1[0], tri1.planes.edgePlane1), TriMesh.distanceFromPlane(this.intersections1[1], tri1.planes.edgePlane1), this.depthchoice2, 0);
        if (this.maxdepths1[0] < 0.0f) {
            return 0;
        }
        this.maxdepths1[1] = this.depthmax(TriMesh.distanceFromPlane(this.intersections1[0], tri1.planes.edgePlane2), TriMesh.distanceFromPlane(this.intersections1[1], tri1.planes.edgePlane2), this.depthchoice2, 1);
        if (this.maxdepths1[1] < 0.0f) {
            return 0;
        }
        this.maxdepths1[2] = this.depthmax(TriMesh.distanceFromPlane(this.intersections1[0], tri1.planes.edgePlane3), TriMesh.distanceFromPlane(this.intersections1[1], tri1.planes.edgePlane3), this.depthchoice2, 2);
        if (this.maxdepths1[2] < 0.0f) {
            return 0;
        }
        int clippedVertexCount2 = this.clipTriangleToEdgePlanes(tri2.vertices, tri1.planes, this.clippedVertices2);
        if (clippedVertexCount2 == 0) {
            return 0;
        }
        MutableFloat maxDepth2 = new MutableFloat();
        int deepestPointCount2 = this.selectDeepestPoints(tri1.planes.facePlane, this.clippedVertices2, clippedVertexCount2, this.deepestVertices2, maxDepth2);
        if (deepestPointCount2 == 0) {
            return 0;
        }
        int clippedVertexCount1 = this.clipTriangleToEdgePlanes(tri1.vertices, tri2.planes, this.clippedVertices1);
        if (clippedVertexCount1 == 0) {
            return 0;
        }
        MutableFloat maxDepth1 = new MutableFloat();
        int deepestPointCount1 = this.selectDeepestPoints(tri2.planes.facePlane, this.clippedVertices1, clippedVertexCount1, this.deepestVertices1, maxDepth1);
        if (deepestPointCount1 == 0) {
            return 0;
        }
        int intersectiontype = 0;
        float minintersection = maxDepth2.value;
        if (maxDepth1.value < minintersection) {
            intersectiontype = 1;
            minintersection = maxDepth1.value;
        }
        int i = 0;
        while (i < 3) {
            if (this.maxdepths1[i] < minintersection) {
                intersectiontype = 2 + i;
                minintersection = this.maxdepths1[i];
            }
            ++i;
        }
        i = 0;
        while (i < 3) {
            if (this.maxdepths2[i] < minintersection) {
                intersectiontype = 5 + i;
                minintersection = this.maxdepths2[i];
            }
            ++i;
        }
        int n = 0;
        if (intersectiontype == 0) {
            int m = Math.min(contacts.length - contactIndex - 1, deepestPointCount2);
            int i2 = 0;
            while (i2 < m) {
                ContactGeom contact = contacts[contactIndex];
                if (contact == null) {
                    contact = contacts[contactIndex] = new Contact();
                }
                contact.setGeom1(mesh1);
                contact.setGeom2(mesh2);
                contact.setDepth(maxDepth2.value);
                contact.setNormal(-tri1.planes.facePlane.m[0], -tri1.planes.facePlane.m[1], -tri1.planes.facePlane.m[2]);
                contact.setPosition(this.deepestVertices2[i2]);
                ++i2;
                ++contactIndex;
            }
            n = m;
        } else if (intersectiontype == 1) {
            int m = Math.min(contacts.length - contactIndex - 1, deepestPointCount1);
            int i3 = 0;
            while (i3 < m) {
                ContactGeom contact = contacts[contactIndex];
                if (contact == null) {
                    contact = contacts[contactIndex] = new Contact();
                }
                contact.setGeom1(mesh1);
                contact.setGeom2(mesh2);
                contact.setDepth(maxDepth1.value);
                contact.setNormal(tri2.planes.facePlane.m[0], tri2.planes.facePlane.m[1], tri2.planes.facePlane.m[2]);
                contact.setPosition(this.deepestVertices1[i3]);
                ++i3;
                ++contactIndex;
            }
            n = m;
        } else {
            n = 0;
        }
        return n;
    }

    private int clipTriangleToEdgePlanes(Vector3[] vertices, TriMesh.TrianglePlanes planes, Vector3[] clipped) {
        int n = TriMeshTriMeshCollider.planeClipPolygon(vertices, 3, planes.edgePlane1, clipped);
        if (n == 0) {
            return 0;
        }
        if ((n = TriMeshTriMeshCollider.planeClipPolygon(clipped, n, planes.edgePlane2, this.tempVertices)) == 0) {
            return 0;
        }
        return TriMeshTriMeshCollider.planeClipPolygon(this.tempVertices, n, planes.edgePlane3, clipped);
    }

    private static int planeClipPolygon(Vector3[] vertices, int vertexCount, Vector4 plane, Vector3[] clipped) {
        int clippedCount = 0;
        int prevClassif = 32000;
        int i = 0;
        while (i <= vertexCount) {
            int classif;
            int vi = i % vertexCount;
            float d = TriMesh.distanceFromPlane(vertices[vi], plane);
            int n = classif = d >= -1.0E-7f ? 0 : 1;
            if (classif == 0) {
                if (prevClassif == 1 && clippedCount < clipped.length) {
                    TriMesh.lineIntersectsPlane(vertices[i - 1], vertices[vi], plane, clipped[clippedCount++]);
                }
                if (clippedCount < clipped.length && i < vertices.length) {
                    clipped[clippedCount++].set(vertices[vi]);
                }
            } else if (prevClassif == 0 && clippedCount < clipped.length) {
                TriMesh.lineIntersectsPlane(vertices[i - 1], vertices[vi], plane, clipped[clippedCount++]);
            }
            prevClassif = classif;
            ++i;
        }
        return clippedCount;
    }

    private int selectDeepestPoints(Vector4 plane, Vector3[] points, int pointCount, Vector3[] deepestPoints, MutableFloat maxDepth) {
        maxDepth.value = -1000.0f;
        int n = 0;
        int i = 0;
        while (i < pointCount) {
            float depth = -TriMesh.distanceFromPlane(points[i], plane);
            if (depth > maxDepth.value) {
                maxDepth.value = depth;
                this.candidateDeepestPoints[0] = i;
                n = 1;
            } else if (depth >= maxDepth.value - 1.0E-7f) {
                this.candidateDeepestPoints[n] = i;
                ++n;
            }
            ++i;
        }
        if (maxDepth.value < 0.0f) {
            return 0;
        }
        i = 0;
        while (i < n) {
            deepestPoints[i].set(points[this.candidateDeepestPoints[i]]);
            ++i;
        }
        return n;
    }

    private int mergeDuplicateContacts(ContactGeom[] contacts, int contactIndex, int n) {
        Object[] keys = new ContactKey[n];
        int i = 0;
        while (i < n) {
            keys[i] = new ContactKey(contacts[contactIndex + i]);
            ++i;
        }
        Arrays.sort(keys);
        int keepIndex = contactIndex;
        int discardIndex = contactIndex + n - 1;
        int lastKey = 0;
        int firstInBatch = 0;
        float previousDepth = 0.0f;
        int i2 = 0;
        while (i2 < n) {
            int key = ((ContactKey)keys[i2]).key;
            ContactGeom contact = ((ContactKey)keys[i2]).contact;
            if (i2 == 0 || key != lastKey || Math.abs(previousDepth - contact.getDepth()) >= 1.0E-5f) {
                if (i2 > firstInBatch) {
                    this.interpolateNormals((ContactKey[])keys, firstInBatch, i2 - 1, contacts[keepIndex - 1].getNormal());
                }
                contacts[keepIndex++] = contact;
                firstInBatch = i2;
                previousDepth = contact.getDepth();
            } else {
                contacts[discardIndex--] = contact;
            }
            lastKey = key;
            ++i2;
        }
        assert (keepIndex == discardIndex + 1);
        return keepIndex - contactIndex;
    }

    private void interpolateNormals(ContactKey[] source, int first, int last, Vector3 result) {
        Vector3 sum = new Vector3();
        int i = first;
        while (i <= last) {
            float depth = source[i].contact.getDepth();
            Vector3 v = source[i].contact.getNormal();
            sum.add(depth * v.getX(), depth * v.getY(), depth * v.getZ());
            ++i;
        }
        float l2 = sum.dot(sum);
        if (l2 < 1.0E-5f) {
            return;
        }
        sum.normalize();
        result.set(sum);
    }

    private float depthmax(float f1, float f2, int[] choices, int i) {
        if (f1 < f2) {
            choices[i] = 1;
            return f2;
        }
        choices[i] = 0;
        return f1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ContactKey
    implements Comparable<ContactKey> {
        public ContactGeom contact;
        public int key;

        public ContactKey(ContactGeom contact) {
            this.contact = contact;
            this.key = (int)(contact.getPosition().m[0] * 1000.0f + 1.0f) + ((int)(contact.getPosition().m[1] * 1333.0f) << 4) + ((int)(contact.getPosition().m[2] * 2133.0f + 3.0f) << 8);
        }

        @Override
        public int compareTo(ContactKey o) {
            return this.key < o.key ? -1 : (this.key > o.key ? 1 : 0);
        }
    }

    private static class MutableFloat {
        public float value;

        private MutableFloat() {
        }
    }
}

