/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.geom;

import net.java.dev.joode.ClonedReferences;
import net.java.dev.joode.geom.Geom;
import net.java.dev.joode.space.Space;
import net.java.dev.joode.util.MathUtils;
import net.java.dev.joode.util.Matrix3;
import net.java.dev.joode.util.Real;
import net.java.dev.joode.util.Vector3;

public class GeomTransform
extends Geom {
    private static final long serialVersionUID = 2268189038023691139L;
    private Geom obj;
    private boolean cleanup;
    private boolean infoMode;
    private final Vector3 final_pos;
    private final Matrix3 final_rot;

    public GeomTransform(Space space, Geom obj) {
        super(space, 6, true);
        this.obj = obj;
        this.cleanup = false;
        this.infoMode = false;
        this.final_pos = new Vector3();
        this.final_pos.setZero();
        this.final_rot = new Matrix3();
        this.final_rot.setIdentity();
        if (space != null) {
            space.add(this);
        }
    }

    private GeomTransform(Geom obj) {
        super(6, true);
        this.obj = obj;
        this.cleanup = false;
        this.infoMode = false;
        this.final_pos = new Vector3();
        this.final_pos.setZero();
        this.final_rot = new Matrix3();
        this.final_rot.setIdentity();
    }

    public final Geom getGeom() {
        return this.obj;
    }

    public final Vector3 getFinalPosition() {
        return this.final_pos;
    }

    public final Matrix3 getFinalRotation() {
        return this.final_rot;
    }

    public final boolean isCleanup() {
        return this.cleanup;
    }

    public final void setCleanup(boolean cleanup) {
        this.cleanup = cleanup;
    }

    public final boolean isInfoMode() {
        return this.infoMode;
    }

    public final void setInfoMode(boolean infomode) {
        this.infoMode = infomode;
    }

    public void computeAABB() {
        if (this.obj == null) {
            this.getAABB().setZero();
            return;
        }
        Vector3 posbak = this.obj.getPosition();
        Matrix3 Rbak = this.obj.getRotation();
        this.computeFinalTx();
        this.obj.directSetPosition(this.final_pos);
        this.obj.directSetRotation(this.final_rot);
        this.obj.computeAABB();
        this.getAABB().set(this.obj.getAABB());
        this.obj.directSetPosition(posbak);
        this.obj.directSetRotation(Rbak);
    }

    public void computeFinalTx() {
        MathUtils.dMULTIPLY0_331((Real)this.final_pos, this.getRotation(), (Real)this.obj.getPosition());
        this.final_pos.add(this.getPosition());
        this.getRotation().mul(this.obj.getRotation(), this.final_rot);
    }

    public void destroy() {
        if (this.cleanup) {
            this.obj.destroy();
        }
        super.destroy();
    }

    public GeomTransform cloneState(ClonedReferences util) {
        GeomTransform clone = new GeomTransform((Geom)util.getClone(this.obj));
        this.clonePartialGeom(clone, util);
        clone.cleanup = this.cleanup;
        clone.infoMode = this.infoMode;
        clone.final_pos.set(this.final_pos);
        clone.final_rot.set(this.final_rot);
        return clone;
    }
}

