/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.geom;

import net.java.dev.joode.ClonedReferences;
import net.java.dev.joode.geom.Geom;
import net.java.dev.joode.space.Space;
import net.java.dev.joode.util.Math2D;
import net.java.dev.joode.util.Matrix3;
import net.java.dev.joode.util.Vector2;
import net.java.dev.joode.util.Vector3;
import org.openmali.FastMath;

public class Rectangle
extends Geom {
    private static final long serialVersionUID = -4429373986426443950L;
    private float halfWidth;
    private float halfHeight;
    private float halfDiagonal;
    public static float[] u1 = new float[2];
    public static float[] u2 = new float[2];

    public Rectangle(Space space, float width, float height) {
        super(space, 10, true);
        assert (width > 0.0f) : "width of a rectangle must be greater than zero";
        assert (height > 0.0f) : "height of a rectangle must be greater than zero";
        this.halfWidth = width / 2.0f;
        this.halfHeight = height / 2.0f;
        this.halfDiagonal = FastMath.sqrt((float)(width * width + height * height)) / 2.0f;
        if (space != null) {
            space.add(this);
        }
    }

    private Rectangle() {
        super(10, true);
    }

    public final float getHalfWidth() {
        return this.halfWidth;
    }

    public final float getHalfHeight() {
        return this.halfHeight;
    }

    public final float getHalfDiagonal() {
        return this.halfDiagonal;
    }

    public void computeAABB() {
        Vector3 pos = this.getPosition();
        this.getAABB().set(pos.getX() - this.halfDiagonal, pos.getX() + this.halfDiagonal, pos.getY() - this.halfDiagonal, pos.getY() + this.halfDiagonal, Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY);
    }

    public final void getVetex(int vertex, float[] coordPassback) {
        this.setAxis();
        coordPassback[0] = this.getPosition().getX();
        coordPassback[1] = this.getPosition().getY();
        if (vertex == 0) {
            Math2D.mul(u1, -this.halfWidth);
            Math2D.mul(u2, this.halfHeight);
        } else if (vertex == 1) {
            Math2D.mul(u1, this.halfWidth);
            Math2D.mul(u2, this.halfHeight);
        } else if (vertex == 2) {
            Math2D.mul(u1, this.halfWidth);
            Math2D.mul(u2, -this.halfHeight);
        } else if (vertex == 3) {
            Math2D.mul(u1, -this.halfWidth);
            Math2D.mul(u2, -this.halfHeight);
        } else {
            throw new IllegalArgumentException("vertex index must be between 0-3");
        }
        Math2D.add(u1, coordPassback, coordPassback);
        Math2D.add(u2, coordPassback, coordPassback);
    }

    public final void getVetex(int vertex, Vector2 coordPassback) {
        this.setAxis();
        coordPassback.setX(this.getPosition().getX());
        coordPassback.setY(this.getPosition().getY());
        if (vertex == 0) {
            Math2D.mul(u1, -this.halfWidth);
            Math2D.mul(u2, this.halfHeight);
        } else if (vertex == 1) {
            Math2D.mul(u1, this.halfWidth);
            Math2D.mul(u2, this.halfHeight);
        } else if (vertex == 2) {
            Math2D.mul(u1, this.halfWidth);
            Math2D.mul(u2, -this.halfHeight);
        } else if (vertex == 3) {
            Math2D.mul(u1, -this.halfWidth);
            Math2D.mul(u2, -this.halfHeight);
        } else {
            throw new IllegalArgumentException("vertex index must be between 0-3");
        }
        coordPassback.x += u1[0];
        coordPassback.y += u1[1];
        coordPassback.x += u2[0];
        coordPassback.y += u2[1];
    }

    private final void setAxis() {
        Matrix3 rot = this.getRotation();
        Rectangle.u1[0] = rot.get(0, 0);
        Rectangle.u1[1] = rot.get(0, 1);
        Rectangle.u2[0] = rot.get(1, 0);
        Rectangle.u2[1] = rot.get(1, 1);
    }

    public final float getWidth() {
        return this.halfWidth * 2.0f;
    }

    public final void setWidth(float width) {
        this.halfWidth = width / 2.0f;
        this.halfDiagonal = FastMath.sqrt((float)(this.halfWidth * this.halfWidth + this.halfHeight * this.halfHeight));
    }

    public final float getHeight() {
        return this.halfHeight * 2.0f;
    }

    public final void setHeight(float height) {
        this.halfHeight = height / 2.0f;
        this.halfDiagonal = FastMath.sqrt((float)(this.halfWidth * this.halfWidth + this.halfHeight * this.halfHeight));
    }

    public float pointDepth(float x, float y, float z) {
        this.setAxis();
        float u1Component = (x -= this.getPosition().getX()) * u1[0] + (y -= this.getPosition().getY()) * u1[1];
        float u2Component = x * u2[0] + y * u2[1];
        float distanceSquared = 0.0f;
        float penetrationDepth = Float.NEGATIVE_INFINITY;
        float u1Dist = u1Component + this.halfWidth;
        if (u1Dist < 0.0f) {
            distanceSquared += u1Dist * u1Dist;
        } else {
            float u1DistN = u1Component - this.halfWidth;
            if (u1DistN > 0.0f) {
                distanceSquared += u1DistN * u1DistN;
            } else {
                penetrationDepth = Math.max(-u1Dist, penetrationDepth);
                penetrationDepth = Math.max(u1DistN, penetrationDepth);
            }
        }
        float u2Dist = u2Component + this.halfHeight;
        if (u2Dist < 0.0f) {
            distanceSquared += u2Dist * u2Dist;
        } else {
            float u2DistN = u2Component - this.halfHeight;
            if (u2DistN > 0.0f) {
                distanceSquared += u2DistN * u2DistN;
            } else {
                penetrationDepth = Math.max(-u2Dist, penetrationDepth);
                penetrationDepth = Math.max(u2DistN, penetrationDepth);
            }
        }
        if (distanceSquared > 0.0f) {
            return -((float)Math.sqrt(distanceSquared));
        }
        return -penetrationDepth;
    }

    public Rectangle cloneState(ClonedReferences util) {
        Rectangle clone = new Rectangle();
        this.clonePartialGeom(clone, util);
        clone.halfWidth = this.halfWidth;
        clone.halfHeight = this.halfHeight;
        return clone;
    }
}

