/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.geom;

import net.java.dev.joode.ClonedReferences;
import net.java.dev.joode.geom.Geom;
import net.java.dev.joode.space.Space;
import net.java.dev.joode.util.Vector3;
import org.openmali.FastMath;

public class Sphere
extends Geom {
    private static final long serialVersionUID = -466977006060193666L;
    private float radius;

    public Sphere(Space space, float radius) {
        super(space, 0, true);
        assert (radius > 0.0f) : "radius must be greater than 0";
        this.radius = radius;
        if (space != null) {
            space.add(this);
        }
    }

    private Sphere() {
        super(0, true);
    }

    public final float getRadius() {
        return this.radius;
    }

    public final void setRadius(float radius) {
        this.radius = radius;
        Space.onGeomMoved(this);
    }

    public void computeAABB() {
        this.getAABB().set(this.getPosition().getX() - this.radius, this.getPosition().getX() + this.radius, this.getPosition().getY() - this.radius, this.getPosition().getY() + this.radius, this.getPosition().getZ() - this.radius, this.getPosition().getZ() + this.radius);
    }

    public final float pointDepth(float x, float y, float z) {
        Vector3 pos = this.getPosition();
        float px = x - pos.getX();
        float py = y - pos.getY();
        float pz = z - pos.getZ();
        return this.radius - FastMath.sqrt((float)(px * px + py * py + pz * pz));
    }

    public Sphere cloneState(ClonedReferences util) {
        Sphere clone = new Sphere();
        this.clonePartialGeom(clone, util);
        clone.radius = this.radius;
        return clone;
    }
}

