/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.joint;

import net.java.dev.joode.Body;
import net.java.dev.joode.ClonedReferences;
import net.java.dev.joode.World;
import net.java.dev.joode.WorldObject;
import net.java.dev.joode.joint.JointFeedback;
import net.java.dev.joode.util.IntPointer;
import net.java.dev.joode.util.Real;
import net.java.dev.joode.util.RealPointer;
import org.jagatoo.datatypes.DoublyChainable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Joint
extends WorldObject
implements DoublyChainable<Joint> {
    public static final int MAX_BODIES = 2;
    public static final int FLAG_JOINT_INGROUP = 1;
    public static final int FLAG_JOINT_REVERSE = 2;
    public static final int FLAG_JOINT_TWOBODIES = 4;
    private int flags;
    private Joint previous = null;
    private Joint next = null;
    private final Body[] bodies = new Body[2];
    private JointFeedback feedback;
    private Real lambda = new Real(6);
    private int worldJointId;

    public Joint(World world) {
        super(world);
        this.flags = 0;
        if (this.getWorld() != null) {
            this.getWorld().addJoint(this);
        }
    }

    protected Joint() {
    }

    public final void setFlag(int flag, boolean b) {
        this.flags = b ? (this.flags |= flag) : (this.flags &= ~flag);
    }

    public final boolean getFlag(int flag) {
        return (this.flags & flag) == flag;
    }

    public final int getFlags() {
        return this.flags;
    }

    public void setPrevious(Joint o) {
        this.previous = o;
    }

    public Joint getPrevious() {
        return this.previous;
    }

    public void setNext(Joint o) {
        this.next = o;
    }

    public Joint getNext() {
        return this.next;
    }

    public final void setBody(int i, Body body) {
        this.bodies[i] = body;
    }

    public final Body getBody(int i) {
        return this.bodies[i];
    }

    public final void setFeedback(JointFeedback feedback) {
        this.feedback = feedback;
    }

    public final JointFeedback getFeedback() {
        return this.feedback;
    }

    public final void setLambda(Real lambda) {
        this.lambda = lambda;
    }

    public final Real getLambda() {
        return this.lambda;
    }

    public final void setWorldJointId(int id) {
        this.worldJointId = id;
    }

    public final int getWorldJointId() {
        return this.worldJointId;
    }

    public void reset() {
        this.removeJointReferencesFromAttachedBodies();
        this.flags = 0;
    }

    @Override
    public void destroy() {
        this.reset();
        this.getWorld().removeJoint(this);
    }

    public void setJointId(int id) {
        this.worldJointId = id;
    }

    public abstract void getInfo1(Info1 var1);

    public abstract void getInfo2(Info2 var1);

    public void removeJointReferencesFromAttachedBodies() {
        int i = 0;
        while (i < 2) {
            if (this.bodies[i] != null) {
                this.bodies[i].removeJoint(this);
                this.bodies[i] = null;
            }
            ++i;
        }
    }

    public void attach(Body body1, Body body2) {
        if (this.bodies[0] != null || this.bodies[1] != null) {
            this.removeJointReferencesFromAttachedBodies();
        }
        if (body1 == null) {
            body1 = body2;
            body2 = null;
            this.flags |= 2;
        } else {
            this.flags &= 0xFFFFFFFD;
        }
        this.bodies[0] = body1;
        this.bodies[1] = body2;
        if (body1 != null) {
            body1.addJoint(this);
        }
        if (body2 != null) {
            body2.addJoint(this);
        }
    }

    public Joint partialCloneJoint(Joint partialClone, ClonedReferences util) {
        this.partialCloneWorldObject(partialClone, util);
        partialClone.lambda.set(this.lambda);
        partialClone.flags = this.flags;
        partialClone.bodies[0] = (Body)util.getClone(this.bodies[0]);
        partialClone.bodies[1] = (Body)util.getClone(this.bodies[1]);
        partialClone.feedback = (JointFeedback)util.getClone(this.feedback);
        partialClone.worldJointId = this.worldJointId;
        return partialClone;
    }

    public static class Info1 {
        public int m;
        public int nub;
    }

    public static class Info2 {
        public int stepType = 0;
        public float t;
        public float fps;
        public float erp;
        public RealPointer J1l;
        public RealPointer J1a;
        public RealPointer J2l;
        public RealPointer J2a;
        public int rowskip;
        public RealPointer c;
        public RealPointer cfm;
        public RealPointer lo;
        public RealPointer hi;
        public IntPointer findex;
    }
}

