/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.joint;

import net.java.dev.joode.ClonedReferences;
import net.java.dev.joode.SimState;
import net.java.dev.joode.World;
import net.java.dev.joode.joint.Joint;
import net.java.dev.joode.joint.JointLimitMotor;
import net.java.dev.joode.util.JOODELog;
import net.java.dev.joode.util.Matrix3;
import net.java.dev.joode.util.Quaternion;
import net.java.dev.joode.util.Vector3;

public class JointConfigurable
extends Joint {
    private static final long serialVersionUID = 2125705130258447449L;
    private static final Matrix3 J1 = new Matrix3();
    private static final Matrix3 J2 = new Matrix3();
    private static final Matrix3 O1 = new Matrix3();
    private static final Matrix3 O2 = new Matrix3();
    private static final Matrix3 T = new Matrix3();
    private static final Matrix3 tmpM = new Matrix3();
    private static final Vector3 tmpV = new Vector3();
    private static final Vector3 tmpVa = new Vector3();
    private static final Vector3 a1 = new Vector3();
    private static final Vector3 a2 = new Vector3();
    private static final Vector3 g1 = new Vector3();
    private static final Vector3 g2 = new Vector3();
    private static final Vector3 c = new Vector3();
    private static final Quaternion tmpA = new Quaternion();
    private static final Quaternion tmpB = new Quaternion();
    private static final Quaternion tmpC = new Quaternion();
    private final Vector3 c0 = new Vector3();
    private final Vector3 ch = new Vector3();
    private final Vector3 jerkA3 = new Vector3();
    private final Vector3 jerkA4 = new Vector3();
    private final Vector3 anchor1 = new Vector3();
    private final Vector3 anchor2 = new Vector3();
    private final Matrix3 t2 = new Matrix3();
    private final Quaternion rotT2 = new Quaternion();
    private final Vector3 linearERP = new Vector3();
    private final Vector3 linearCFM = new Vector3();
    private final Vector3 angularERP = new Vector3();
    private final Vector3 angularCFM = new Vector3();
    private JointLimitMotor[] linearLimitMotors = new JointLimitMotor[3];
    private JointLimitMotor[] angularLimitMotors = new JointLimitMotor[3];
    private final int[] linearConstraints = new int[3];
    private final int[] angularConstraints = new int[3];
    public static final int NO_CONSTRAINT = 0;
    public static final int UNBOUNDED_CONSTRAINT = 1;
    public static final int MOTOR_CONSTRAINT = 2;

    public JointConfigurable(World world) {
        super(world);
        int i = 0;
        while (i < 3) {
            this.linearERP.m[i] = world.getGlobalERP();
            this.linearCFM.m[i] = world.getGlobalCFM();
            this.angularERP.m[i] = world.getGlobalERP();
            this.angularCFM.m[i] = world.getGlobalCFM();
            this.linearLimitMotors[i] = new JointLimitMotor(world);
            this.angularLimitMotors[i] = new JointLimitMotor(world);
            ++i;
        }
    }

    public final void setAnchor1(float x, float y, float z) {
        this.anchor1.set(x, y, z);
    }

    public final void setAnchor1(Vector3 anchor) {
        this.anchor1.set(anchor);
    }

    public final Vector3 getAnchor1() {
        return this.anchor1;
    }

    public final void setAnchor2(float x, float y, float z) {
        this.anchor2.set(x, y, z);
    }

    public final void setAnchor2(Vector3 anchor) {
        this.anchor2.set(anchor);
    }

    public final Vector3 getAnchor2() {
        return this.anchor2;
    }

    public final void setAdditionalRotationL2(Matrix3 t2) {
        this.t2.set(t2);
    }

    public final Matrix3 getAdditionalRotationL2() {
        return this.t2;
    }

    public final void setAdditionalRotationR2(Quaternion rotT2) {
        this.rotT2.set(rotT2);
    }

    public final Quaternion getAdditionalRotationR2() {
        return this.rotT2;
    }

    public final void setLinearERP(Vector3 linearERP) {
        this.linearERP.set(linearERP);
    }

    public final Vector3 getLinearERP() {
        return this.linearERP;
    }

    public final void setLinearCFM(Vector3 linearCFM) {
        this.linearCFM.set(linearCFM);
    }

    public final Vector3 getLinearCFM() {
        return this.linearCFM;
    }

    public final void setAngularERP(Vector3 angularERP) {
        this.angularERP.set(angularERP);
    }

    public final Vector3 getAngularERP() {
        return this.angularERP;
    }

    public final void setAngularCFM(Vector3 angularCFM) {
        this.angularCFM.set(angularCFM);
    }

    public final Vector3 getAngularCFM() {
        return this.angularCFM;
    }

    public final int getNumLinearLimitMotors() {
        return this.linearLimitMotors.length;
    }

    public final void setLinearLimitMotor(int i, JointLimitMotor limot) {
        this.linearLimitMotors[i] = limot;
    }

    public final JointLimitMotor getLinearLimitMotor(int i) {
        return this.linearLimitMotors[i];
    }

    public final int getNumAngularLimitMotors() {
        return this.angularLimitMotors.length;
    }

    public final void setAngularLimitMotor(int i, JointLimitMotor limot) {
        this.angularLimitMotors[i] = limot;
    }

    public final JointLimitMotor getAngularLimitMotor(int i) {
        return this.angularLimitMotors[i];
    }

    public final int getNumLinearConstraints() {
        return this.linearConstraints.length;
    }

    public final void setLinearConstraints(int i, int value) {
        this.linearConstraints[i] = value;
    }

    public final int getLinearConstraints(int i) {
        return this.linearConstraints[i];
    }

    public final int getNumAngularConstraints() {
        return this.angularConstraints.length;
    }

    public final void setAngularConstraints(int i, int value) {
        this.angularConstraints[i] = value;
    }

    public final int getAngularConstraints(int i) {
        return this.angularConstraints[i];
    }

    public void getInfo1(Joint.Info1 info1) {
        Vector3 linearDistance = Vector3.pool.aquire();
        Vector3 angularDistance = Vector3.pool.aquire();
        this.getLinearDistance(linearDistance);
        if (this.angularConstraints[0] != 0 || this.angularConstraints[1] != 0 || this.angularConstraints[2] != 0) {
            this.getAngularDistance(angularDistance);
        }
        int i = 0;
        while (i < 3) {
            switch (this.linearConstraints[i]) {
                case 1: {
                    ++info1.m;
                    ++info1.nub;
                    break;
                }
                case 2: {
                    if ((this.linearLimitMotors[i].getLowStop() > Float.NEGATIVE_INFINITY || this.linearLimitMotors[i].getHighStop() < Float.POSITIVE_INFINITY) && this.linearLimitMotors[i].getLowStop() <= this.linearLimitMotors[i].getHighStop()) {
                        if (linearDistance.m[i] <= this.linearLimitMotors[i].getLowStop()) {
                            this.linearLimitMotors[i].setLimit(1);
                            this.linearLimitMotors[i].setLimitError(linearDistance.m[i] - this.linearLimitMotors[i].getLowStop());
                            ++info1.m;
                            break;
                        }
                        if (linearDistance.m[i] >= this.linearLimitMotors[i].getHighStop()) {
                            this.linearLimitMotors[i].setLimit(2);
                            this.linearLimitMotors[i].setLimitError(linearDistance.m[i] - this.linearLimitMotors[i].getHighStop());
                            ++info1.m;
                            break;
                        }
                        this.linearLimitMotors[i].setLimit(0);
                        if (!(this.linearLimitMotors[i].getMaxForce() > 0.0f)) break;
                        ++info1.m;
                        break;
                    }
                    if (!(this.linearLimitMotors[i].getMaxForce() > 0.0f)) break;
                    this.linearLimitMotors[i].setLimit(0);
                    ++info1.m;
                    break;
                }
                default: {
                    assert (this.linearConstraints[i] == 0);
                    break;
                }
            }
            switch (this.angularConstraints[i]) {
                case 1: {
                    ++info1.m;
                    ++info1.nub;
                    break;
                }
                case 2: {
                    if ((this.angularLimitMotors[i].getLowStop() > Float.NEGATIVE_INFINITY || this.angularLimitMotors[i].getHighStop() < Float.POSITIVE_INFINITY) && this.angularLimitMotors[i].getLowStop() <= this.angularLimitMotors[i].getHighStop()) {
                        if (angularDistance.m[i] <= this.angularLimitMotors[i].getLowStop()) {
                            this.angularLimitMotors[i].setLimit(1);
                            this.angularLimitMotors[i].setLimitError(angularDistance.m[i] - this.angularLimitMotors[i].getLowStop());
                            ++info1.m;
                            break;
                        }
                        if (angularDistance.m[i] >= this.angularLimitMotors[i].getHighStop()) {
                            this.angularLimitMotors[i].setLimit(2);
                            this.angularLimitMotors[i].setLimitError(angularDistance.m[i] - this.angularLimitMotors[i].getHighStop());
                            ++info1.m;
                            break;
                        }
                        this.angularLimitMotors[i].setLimit(0);
                        if (!(this.angularLimitMotors[i].getMaxForce() > 0.0f)) break;
                        ++info1.m;
                        break;
                    }
                    if (!(this.angularLimitMotors[i].getMaxForce() > 0.0f)) break;
                    this.angularLimitMotors[i].setLimit(0);
                    ++info1.m;
                    break;
                }
                default: {
                    assert (this.angularConstraints[i] == 0);
                    break;
                }
            }
            ++i;
        }
        Vector3.pool.release(angularDistance);
        Vector3.pool.release(linearDistance);
    }

    public Vector3 getLinearDistance(Vector3 passback) {
        this.getAnchor1InGlobalCoords(g1);
        this.getAnchor2InGlobalCoords(g2);
        c.sub(g2);
        c.set(g1);
        this.convertGlobalFrameToFrame2(c, passback);
        return passback;
    }

    public Vector3 getAngularDistance(Vector3 passback) {
        Quaternion frame2Q;
        Matrix3 frame2M = Matrix3.pool.aquire();
        if (this.getBody(1) != null) {
            frame2Q = this.getBody(1).getQuaternion().mul(this.rotT2, Quaternion.pool.aquire());
        } else {
            frame2Q = Quaternion.pool.aquire();
            frame2Q.set(this.rotT2);
        }
        frame2Q.toMatrix(frame2M);
        Vector3 axis1 = Vector3.pool.aquire();
        Vector3 axis2 = Vector3.pool.aquire();
        Vector3 axis3 = Vector3.pool.aquire();
        frame2M.getColumn(0, axis1);
        frame2M.getColumn(1, axis2);
        frame2M.getColumn(2, axis3);
        Quaternion.getAngles(this.getBody(0).getQuaternion(), frame2Q, axis1, axis2, axis3, passback);
        Matrix3.pool.release(frame2M);
        Quaternion.pool.release(frame2Q);
        Vector3.pool.release(axis1);
        Vector3.pool.release(axis2);
        Vector3.pool.release(axis3);
        return passback;
    }

    public void getInfo2(Joint.Info2 jinfo) {
        this.getAnchor1InGlobalFrame(a1);
        this.getAnchor2InGlobalFrame(a2);
        this.getAnchor1InGlobalCoords(g1);
        this.getAnchor2InGlobalCoords(g2);
        c.set(g2);
        c.sub(g1);
        if (jinfo.stepType != 0) {
            int i;
            if (jinfo.t == 0.0f) {
                this.c0.set(c);
                this.convertGlobalFrameToFrame2(this.c0, tmpV);
                int j = 0;
                while (j < 3) {
                    JointConfigurable.tmpVa.m[j] = JointConfigurable.tmpV.m[j] * (1.0f - this.linearERP.m[j]);
                    ++j;
                }
                this.convertFrame2CoordsToGlobalFrame(tmpVa, this.ch);
                i = 0;
                while (i < 3) {
                    if (this.getBody(1) != null) {
                        this.jerkA3.m[i] = 3.0f * (this.c0.m[i] - this.ch.m[i]) * jinfo.fps * jinfo.fps - 3.0f * (this.getBody((int)0).getLinearVel().m[i] - this.getBody((int)1).getLinearVel().m[i]) * jinfo.fps;
                        this.jerkA4.m[i] = -2.0f * (this.c0.m[i] - this.ch.m[i]) * jinfo.fps * jinfo.fps * jinfo.fps + 2.0f * (this.getBody((int)0).getLinearVel().m[i] - this.getBody((int)1).getLinearVel().m[i]) * jinfo.fps * jinfo.fps;
                    } else {
                        this.jerkA3.m[i] = 3.0f * (this.c0.m[i] - this.ch.m[i]) * jinfo.fps * jinfo.fps - 3.0f * this.getBody((int)0).getLinearVel().m[i] * jinfo.fps;
                        this.jerkA4.m[i] = -2.0f * (this.c0.m[i] - this.ch.m[i]) * jinfo.fps * jinfo.fps * jinfo.fps + 2.0f * this.getBody((int)0).getLinearVel().m[i] * jinfo.fps * jinfo.fps;
                    }
                    ++i;
                }
            }
            i = 0;
            while (i < 3) {
                JointConfigurable.c.m[i] = this.getBody(1) != null ? (2.0f * this.jerkA3.m[i] + 6.0f * this.jerkA4.m[i] * jinfo.t / jinfo.fps) / jinfo.fps + (this.getBody((int)0).getLinearVel().m[i] - this.getBody((int)1).getLinearVel().m[i]) : (2.0f * this.jerkA3.m[i] + 6.0f * this.jerkA4.m[i] * jinfo.t / jinfo.fps) / jinfo.fps + this.getBody((int)0).getLinearVel().m[i];
                ++i;
            }
        }
        J1.setIdentity();
        a1.bar(O1);
        O1.scale(-1.0f);
        if (this.getBody(1) != null) {
            J2.setIdentity();
            J2.scale(-1.0f);
            a2.bar(O2);
        }
        this.getGlobalFrameToFrame2(T);
        T.mul(J1, tmpM);
        J1.set(tmpM);
        T.mul(O1, tmpM);
        O1.set(tmpM);
        T.mul(J2, tmpM);
        J2.set(tmpM);
        T.mul(O2, tmpM);
        O2.set(tmpM);
        tmpV.setZero();
        T.mulInc(c, tmpV);
        c.set(tmpV);
        int jrowskip = jinfo.rowskip;
        int mrowskip = J1.getColumns();
        int currentRow = 0;
        int i = 0;
        while (i < 3) {
            if (this.linearConstraints[i] == 1) {
                int c = 0;
                while (c < 3) {
                    jinfo.J1l.setValue(c + currentRow * jrowskip, JointConfigurable.J1.m[c + i * mrowskip]);
                    jinfo.J1a.setValue(c + currentRow * jrowskip, JointConfigurable.O1.m[c + i * mrowskip]);
                    if (this.getBody(1) != null) {
                        jinfo.J2l.setValue(c + currentRow * jrowskip, JointConfigurable.J2.m[c + i * mrowskip]);
                        jinfo.J2a.setValue(c + currentRow * jrowskip, JointConfigurable.O2.m[c + i * mrowskip]);
                    }
                    ++c;
                }
                if (jinfo.stepType != 0) {
                    jinfo.c.setValue(currentRow, JointConfigurable.c.m[i]);
                } else {
                    jinfo.c.setValue(currentRow, jinfo.fps * this.linearERP.m[i] * JointConfigurable.c.m[i]);
                }
                jinfo.cfm.setValue(currentRow, this.linearCFM.m[i]);
                ++currentRow;
            } else if (this.linearConstraints[i] == 2) {
                Vector3 axis = Vector3.pool.aquire();
                T.getColumn(i, axis);
                if (this.linearLimitMotors[i].addLimot(this, jinfo, currentRow, axis, false)) {
                    ++currentRow;
                }
                Vector3.pool.release(axis);
            }
            ++i;
        }
        if (this.angularConstraints[0] != 0 || this.angularConstraints[1] != 0 || this.angularConstraints[2] != 0) {
            Quaternion frame2Q;
            J1.setZero();
            J2.setZero();
            O1.setIdentity();
            O2.set(O1);
            O2.scale(-1.0f);
            Matrix3 frame2M = T;
            if (this.getBody(1) != null) {
                tmpC.setZero();
                frame2Q = this.getBody(1).getQuaternion().mul(this.rotT2, tmpC);
            } else {
                frame2Q = tmpC;
                frame2Q.set(this.rotT2);
            }
            frame2Q.toMatrix(frame2M);
            Vector3 axis1 = Vector3.pool.aquire();
            Vector3 axis2 = Vector3.pool.aquire();
            Vector3 axis3 = Vector3.pool.aquire();
            frame2M.getColumn(0, axis1);
            frame2M.getColumn(1, axis2);
            frame2M.getColumn(2, axis3);
            Quaternion.weightedSLERP(this.getBody(0).getQuaternion(), frame2Q, axis1, axis2, axis3, this.angularERP, null, tmpA);
            Vector3.pool.release(axis1);
            Vector3.pool.release(axis2);
            Vector3.pool.release(axis3);
            tmpB.set(this.getBody(0).getQuaternion());
            tmpB.invert();
            Quaternion change = tmpC;
            tmpA.mul(tmpB, change);
            this.getBody(0).getAngularVelocityToTurn(change, jinfo.fps, c);
            frame2M.transpose();
            frame2M.mul(O1, tmpM);
            O1.set(tmpM);
            frame2M.mul(O2, tmpM);
            O2.set(tmpM);
            tmpV.setZero();
            int i2 = 0;
            while (i2 < 3) {
                if (this.angularConstraints[i2] == 1) {
                    int c = 0;
                    while (c < 3) {
                        jinfo.J1a.setValue(c + currentRow * jrowskip, JointConfigurable.O1.m[c + i2 * mrowskip]);
                        if (this.getBody(1) != null) {
                            jinfo.J2a.setValue(c + currentRow * jrowskip, JointConfigurable.O2.m[c + i2 * mrowskip]);
                        }
                        ++c;
                    }
                    jinfo.c.setValue(currentRow, JointConfigurable.c.m[i2]);
                    jinfo.cfm.setValue(currentRow, this.angularCFM.m[i2]);
                    ++currentRow;
                } else if (this.angularConstraints[i2] == 2) {
                    Vector3 axis = Vector3.pool.aquire();
                    frame2M.getColumn(i2, axis);
                    JOODELog.debug("axis = ", axis);
                    if (this.angularLimitMotors[i2].addLimot(this, jinfo, currentRow, axis, true)) {
                        ++currentRow;
                    }
                    Vector3.pool.release(axis);
                }
                ++i2;
            }
        }
    }

    public SimState cloneState(ClonedReferences util) {
        return null;
    }

    public Vector3 convertGlobalCoordsToFrame1Coords(Vector3 relative, Vector3 passback) {
        passback.setZero();
        tmpV.set(relative);
        tmpV.sub(this.getBody(0).getPosition());
        this.getBody(0).getRotation().transposeMul(tmpV, passback);
        return passback;
    }

    public Vector3 convertGlobalCoordsToFrame2Coords(Vector3 relative, Vector3 passback) {
        passback.setZero();
        if (this.getBody(1) != null) {
            tmpVa.setZero();
            tmpV.set(relative);
            tmpV.sub(this.getBody(1).getPosition());
            this.getBody(1).getRotation().transposeMul(tmpV, tmpVa);
            this.t2.transposeMul(tmpVa, passback);
        } else {
            this.t2.transposeMul(relative, passback);
        }
        return passback;
    }

    public Vector3 convertGlobalFrameToFrame2(Vector3 relative, Vector3 passback) {
        passback.setZero();
        if (this.getBody(1) != null) {
            tmpVa.setZero();
            this.getBody(1).getRotation().transposeMul(relative, tmpVa);
            this.t2.transposeMul(tmpVa, passback);
        } else {
            this.t2.transposeMul(relative, passback);
        }
        return passback;
    }

    public Vector3 convertFrame1CoordsToGlobalFrame(Vector3 relative, Vector3 passback) {
        passback.setZero();
        this.getBody(0).getRotation().mulInc(relative, passback);
        return passback;
    }

    public Vector3 convertFrame2CoordsToGlobalFrame(Vector3 relative, Vector3 passback) {
        passback.setZero();
        tmpV.setZero();
        this.t2.mulInc(relative, tmpV);
        if (this.getBody(1) != null) {
            this.getBody(1).getRotation().mulInc(tmpV, passback);
        } else {
            passback.set(tmpV);
        }
        return passback;
    }

    public Vector3 convertFrame1CoordsToGlobalCoords(Vector3 relative, Vector3 passback) {
        this.convertFrame1CoordsToGlobalFrame(relative, passback);
        passback.add(this.getBody(0).getPosition());
        return passback;
    }

    public Vector3 convertFrame2CoordsToGlobalCoords(Vector3 relative, Vector3 passback) {
        this.convertFrame2CoordsToGlobalFrame(relative, passback);
        if (this.getBody(1) != null) {
            passback.add(this.getBody(1).getPosition());
        }
        return passback;
    }

    public Vector3 getAnchor1InGlobalFrame(Vector3 passback) {
        return this.convertFrame1CoordsToGlobalFrame(this.anchor1, passback);
    }

    public Vector3 getAnchor2InGlobalFrame(Vector3 passback) {
        return this.convertFrame2CoordsToGlobalFrame(this.anchor2, passback);
    }

    public Vector3 getAnchor1InGlobalCoords(Vector3 passback) {
        return this.convertFrame1CoordsToGlobalCoords(this.anchor1, passback);
    }

    public Vector3 getAnchor2InGlobalCoords(Vector3 passback) {
        return this.convertFrame2CoordsToGlobalCoords(this.anchor2, passback);
    }

    public void getGlobalFrameToFrame2(Matrix3 passback) {
        if (this.getBody(1) != null) {
            this.t2.mul(this.getBody(1).getRotation(), passback);
        } else {
            passback.set(this.t2);
        }
        passback.transpose();
    }
}

