/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.joint;

import net.java.dev.joode.Body;
import net.java.dev.joode.ClonedReferences;
import net.java.dev.joode.World;
import net.java.dev.joode.joint.Joint;
import net.java.dev.joode.joint.JointLimitMotor;
import net.java.dev.joode.joint.JointUtils;
import net.java.dev.joode.util.MathUtils;
import net.java.dev.joode.util.Matrix3;
import net.java.dev.joode.util.Quaternion;
import net.java.dev.joode.util.Real;
import net.java.dev.joode.util.Vector3;

public class JointHinge
extends Joint {
    private static final long serialVersionUID = 7895820439802237448L;
    private final Vector3 anchor1 = new Vector3();
    private final Vector3 anchor2 = new Vector3();
    private final Vector3 axis1 = new Vector3();
    private final Vector3 axis2 = new Vector3();
    private final Quaternion qrel = new Quaternion();
    private JointLimitMotor limot;

    public JointHinge(World world, JointLimitMotor limot) {
        super(world);
        this.axis1.setX(1.0f);
        this.axis2.setX(1.0f);
        this.limot = limot;
    }

    public JointHinge(World world) {
        super(world);
        this.axis1.setX(1.0f);
        this.axis2.setX(1.0f);
        this.limot = new JointLimitMotor(world);
    }

    private JointHinge() {
    }

    public final void setAnchor1(Vector3 anchor) {
        this.anchor1.set(anchor);
    }

    public final Vector3 getAnchor1() {
        return this.anchor1;
    }

    public final void setAnchor2(Vector3 anchor) {
        this.anchor2.set(anchor);
    }

    public final Vector3 getAnchor2() {
        return this.anchor2;
    }

    public final void setAnchor(Vector3 axis) {
        this.setAnchor(axis.getX(), axis.getY(), axis.getZ());
    }

    public final void setAxis1(Vector3 axis) {
        this.axis1.set(axis);
    }

    public final Vector3 getAxis1() {
        return this.axis1;
    }

    public final void setAxis2(Vector3 axis) {
        this.axis2.set(axis);
    }

    public final Vector3 getAxis2() {
        return this.axis2;
    }

    public final void setInitialRotation(Quaternion rot) {
        this.qrel.set(rot);
    }

    public final void setInitialRotation(Matrix3 rot) {
        this.qrel.set(rot);
    }

    public final Quaternion getInitialRotation() {
        return this.qrel;
    }

    public final void setLimitMotor(JointLimitMotor limot) {
        this.limot = limot;
    }

    public final JointLimitMotor getLimitMotor() {
        return this.limot;
    }

    public void getInfo1(Joint.Info1 info) {
        float angle;
        info.nub = 5;
        info.m = this.limot != null && this.limot.getMaxForce() > 0.0f ? 6 : 5;
        if (this.limot != null && ((double)this.limot.getLowStop() >= -Math.PI || (double)this.limot.getHighStop() <= Math.PI) && this.limot.getLowStop() <= this.limot.getHighStop() && this.limot.testRotationalLimit(angle = JointHinge.getHingeAngle(this.getBody(0), this.getBody(1), this.axis1, this.qrel))) {
            info.m = 6;
        }
    }

    public void getInfo2(Joint.Info2 info) {
        JointUtils.setBall(this, info, this.anchor1, this.anchor2);
        Vector3 ax1 = new Vector3();
        Vector3 p = new Vector3();
        Vector3 q = new Vector3();
        MathUtils.dMULTIPLY0_331((Real)ax1, this.getBody(0).getRotation(), (Real)this.axis1);
        ax1.constructPlaneSpace(p, q);
        int s3 = 3 * info.rowskip;
        int s4 = 4 * info.rowskip;
        info.J1a.setValue(s3 + 0, p.m[0]);
        info.J1a.setValue(s3 + 1, p.m[1]);
        info.J1a.setValue(s3 + 2, p.m[2]);
        info.J1a.setValue(s4 + 0, q.m[0]);
        info.J1a.setValue(s4 + 1, q.m[1]);
        info.J1a.setValue(s4 + 2, q.m[2]);
        if (this.getBody(1) != null) {
            info.J2a.setValue(s3 + 0, -p.m[0]);
            info.J2a.setValue(s3 + 1, -p.m[1]);
            info.J2a.setValue(s3 + 2, -p.m[2]);
            info.J2a.setValue(s4 + 0, -q.m[0]);
            info.J2a.setValue(s4 + 1, -q.m[1]);
            info.J2a.setValue(s4 + 2, -q.m[2]);
        }
        Vector3 ax2 = new Vector3();
        if (this.getBody(1) != null) {
            MathUtils.dMULTIPLY0_331((Real)ax2, this.getBody(1).getRotation(), (Real)this.axis2);
        } else {
            ax2.m[0] = this.axis2.m[0];
            ax2.m[1] = this.axis2.m[1];
            ax2.m[2] = this.axis2.m[2];
        }
        Vector3 b = ax1.cross(ax2);
        float k = info.fps * info.erp;
        info.c.setValue(3, k * b.dot(p));
        info.c.setValue(4, k * b.dot(q));
        this.limot.addLimot(this, info, 5, ax1, true);
    }

    public final void setAnchor(float x, float y, float z) {
        JointUtils.setAnchors(this, x, y, z, this.anchor1, this.anchor2);
        this.hingeComputeInitialRelativeRotation();
    }

    public final void getAbsAnchor(Vector3 anchor) {
        JointUtils.getAnchor(this, anchor, this.anchor1);
    }

    public final void setAxis(float x, float y, float z) {
        JointUtils.setAxes(this, x, y, z, this.axis1, this.axis2);
        this.hingeComputeInitialRelativeRotation();
    }

    public final void setAxis(Vector3 axis) {
        this.setAxis(axis.getX(), axis.getY(), axis.getZ());
    }

    private void hingeComputeInitialRelativeRotation() {
        if (this.getBody(0) != null) {
            if (this.getBody(1) != null) {
                Quaternion q = new Quaternion(this.getBody(0).getQuaternion());
                q.invert();
                q.mul(this.getBody(1).getQuaternion(), this.qrel);
            } else {
                this.qrel.set(this.getBody(0).getQuaternion());
                this.qrel.invert();
            }
        }
    }

    public float getHingeAngle() {
        return JointHinge.getHingeAngle(this.getBody(0), this.getBody(1), this.axis1, this.qrel);
    }

    public static float getHingeAngle(Body body1, Body body2, Vector3 axis, Quaternion q_initial) {
        Quaternion qrel = new Quaternion();
        if (body2 != null) {
            Quaternion qa = new Quaternion(body1.getQuaternion());
            qa.invert();
            Quaternion qb = new Quaternion();
            qa.mul(body2.getQuaternion(), qb);
            qa.set(q_initial);
            qa.invert();
            qb.mul(qa, qrel);
        } else {
            q_initial.mul(body1.getQuaternion(), qrel);
            qrel.invert();
        }
        return JointHinge.getHingeAngleFromRelativeQuat(qrel, axis);
    }

    public static float getHingeAngleFromRelativeQuat(Quaternion qrel, Vector3 axis) {
        float theta;
        float cost2 = qrel.m[0];
        float sint2 = (float)Math.sqrt(qrel.m[1] * qrel.m[1] + qrel.m[2] * qrel.m[2] + qrel.m[3] * qrel.m[3]);
        float qrel_axis = qrel.m[1] * axis.m[0] + qrel.m[2] * axis.m[1] + qrel.m[3] * axis.m[2];
        float f = theta = qrel_axis >= 0.0f ? (float)(2.0 * Math.atan2(sint2, cost2)) : (float)(2.0 * Math.atan2(sint2, -cost2));
        if ((double)theta > Math.PI) {
            theta = (float)((double)theta - Math.PI * 2);
        }
        theta = -theta;
        return theta;
    }

    public JointHinge cloneState(ClonedReferences util) {
        JointHinge clone = new JointHinge();
        this.partialCloneJoint(clone, util);
        clone.axis1.set(this.axis1);
        clone.axis2.set(this.axis2);
        clone.anchor1.set(this.anchor1);
        clone.anchor2.set(this.anchor2);
        clone.qrel.set(this.qrel);
        clone.limot = (JointLimitMotor)util.getClone(this.limot);
        return clone;
    }

    public Vector3 getAnchor1Absolute(Vector3 passback) {
        MathUtils.dMULTIPLY0_331((Real)passback, this.getBody(0).getRotation(), (Real)this.anchor1);
        passback.add(this.getBody(0).getPosition());
        return passback;
    }

    public Vector3 getAnchor2Absolute(Vector3 passback) {
        if (this.getBody(1) != null) {
            MathUtils.dMULTIPLY0_331((Real)passback, this.getBody(1).getRotation(), (Real)this.anchor2);
            passback.add(this.getBody(1).getPosition());
        } else {
            passback.set(this.anchor2);
        }
        return passback;
    }
}

