/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.joint;

import net.java.dev.joode.ClonedReferences;
import net.java.dev.joode.World;
import net.java.dev.joode.joint.Joint;
import net.java.dev.joode.joint.JointLimitMotor;
import net.java.dev.joode.joint.JointUtils;
import net.java.dev.joode.util.MathUtils;
import net.java.dev.joode.util.Real;
import net.java.dev.joode.util.Vector3;

public class JointHinge2
extends Joint {
    private static final long serialVersionUID = -8555543271768644159L;
    private final Vector3 anchor1 = new Vector3();
    private final Vector3 anchor2 = new Vector3();
    private final Vector3 axis1 = new Vector3();
    private final Vector3 axis2 = new Vector3();
    private float c0;
    private float s0;
    private final Vector3 v1 = new Vector3();
    private final Vector3 v2 = new Vector3();
    private JointLimitMotor limot1;
    private JointLimitMotor limot2;
    private float susp_erp;
    private float susp_cfm;

    public JointHinge2(World world, float defaultCFM, float defaultERP, JointLimitMotor limot1, JointLimitMotor limot2) {
        super(world);
        this.axis1.setX(1.0f);
        this.axis2.setX(1.0f);
        this.c0 = 0.0f;
        this.s0 = 0.0f;
        this.v1.setX(1.0f);
        this.v2.setY(1.0f);
        this.limot1 = limot1;
        this.limot2 = limot2;
        this.susp_cfm = defaultCFM;
        this.susp_erp = defaultERP;
        this.setFlag(4, true);
    }

    public JointHinge2(World world) {
        super(world);
        this.axis1.setX(1.0f);
        this.axis2.setX(1.0f);
        this.c0 = 0.0f;
        this.s0 = 0.0f;
        this.v1.setX(1.0f);
        this.v2.setY(1.0f);
        this.limot1 = new JointLimitMotor(world);
        this.limot2 = new JointLimitMotor(world);
        this.susp_cfm = world.getGlobalCFM();
        this.susp_erp = world.getGlobalERP();
        this.setFlag(4, true);
    }

    private JointHinge2() {
    }

    public final void setAnchor1(float x, float y, float z) {
        this.anchor1.set(x, y, z);
    }

    public final void setAnchor1(Vector3 anchor) {
        this.anchor1.set(anchor);
    }

    public final Vector3 getAnchor1() {
        return this.anchor1;
    }

    public final void setAnchor2(float x, float y, float z) {
        this.anchor2.set(x, y, z);
    }

    public final void setAnchor2(Vector3 anchor) {
        this.anchor2.set(anchor);
    }

    public final Vector3 getAnchor2() {
        return this.anchor2;
    }

    public final void setAxis1(Vector3 axis) {
        this.axis1.set(axis);
    }

    public final Vector3 getAxis1() {
        return this.axis1;
    }

    public final void setAxis2(Vector3 axis) {
        this.axis2.set(axis);
    }

    public final Vector3 getAxis2() {
        return this.axis2;
    }

    public final void setLimitMotor1(JointLimitMotor limot) {
        this.limot1 = limot;
    }

    public final JointLimitMotor getLimitMotor1() {
        return this.limot1;
    }

    public final void setLimitMotor2(JointLimitMotor limot) {
        this.limot2 = limot;
    }

    public final JointLimitMotor getLimitMotor2() {
        return this.limot2;
    }

    public final void setSuspensionCFM(float value) {
        this.susp_cfm = value;
    }

    public final float getSuspensionCFM() {
        return this.susp_cfm;
    }

    public final void setSuspensionERP(float value) {
        this.susp_erp = value;
    }

    public final float getSuspensionERP() {
        return this.susp_erp;
    }

    public void getInfo1(Joint.Info1 info1) {
        float angle;
        info1.m = 4;
        info1.nub = 4;
        boolean atlimit = false;
        if ((this.limot1.getLowStop() >= (float)(-Math.PI) || this.limot1.getHighStop() <= (float)Math.PI) && this.limot1.getLowStop() <= this.limot1.getHighStop() && this.limot1.testRotationalLimit(angle = this.measureHinge2Angle())) {
            atlimit = true;
        }
        if (atlimit || this.limot1.getMaxForce() > 0.0f) {
            ++info1.m;
        }
        this.limot2.setLimit(0);
        if (this.limot2.getMaxForce() > 0.0f) {
            ++info1.m;
        }
    }

    public void getInfo2(Joint.Info2 jinfo) {
        Vector3 ax1 = new Vector3();
        Vector3 ax2 = new Vector3();
        Vector3 q = new Vector3();
        float[] sc = this.getAxisInfo(q, ax1, ax2);
        q.normalize();
        JointUtils.setBall2(this, jinfo, this.anchor1, this.anchor2, ax1, this.susp_erp);
        int s3 = 3 * jinfo.rowskip;
        jinfo.J1a.setValue(s3 + 0, q.m[0]);
        jinfo.J1a.setValue(s3 + 1, q.m[1]);
        jinfo.J1a.setValue(s3 + 2, q.m[2]);
        if (this.getBody(1) != null) {
            jinfo.J2a.setValue(s3 + 0, -q.m[0]);
            jinfo.J2a.setValue(s3 + 1, -q.m[1]);
            jinfo.J2a.setValue(s3 + 2, -q.m[2]);
        }
        float k = jinfo.fps * jinfo.erp;
        jinfo.c.setValue(3, k * (this.c0 * sc[0] - this.s0 * sc[1]));
        int row = this.limot1.addLimot(this, jinfo, 4, ax1, true) ? 5 : 4;
        this.limot2.addLimot(this, jinfo, row, ax2, true);
        jinfo.cfm.setValue(0, this.susp_cfm);
    }

    public void setAnchor(float x, float y, float z) {
        JointUtils.setAnchors(this, x, y, z, this.anchor1, this.anchor2);
        this.makeHinge2V1andV2();
    }

    public void setAxis1(float x, float y, float z) {
        if (this.getBody(0) != null) {
            Vector3 q = new Vector3(x, y, z);
            q.normalize();
            MathUtils.dMULTIPLY1_331(this.axis1, this.getBody(0).getRotation(), q);
            this.axis1.m[3] = 0.0f;
            Vector3 ax = new Vector3();
            float[] sc = this.getAxisInfo(ax, null, null);
            this.s0 = sc[0];
            this.c0 = sc[1];
        }
        this.makeHinge2V1andV2();
    }

    public void setAxis2(float x, float y, float z) {
        if (this.getBody(1) != null) {
            Vector3 q = new Vector3(x, y, z);
            q.normalize();
            MathUtils.dMULTIPLY1_331(this.axis2, this.getBody(1).getRotation(), q);
            this.axis1.m[3] = 0.0f;
            Vector3 ax = new Vector3();
            float[] sc = this.getAxisInfo(ax, null, null);
            this.s0 = sc[0];
            this.c0 = sc[1];
        }
        this.makeHinge2V1andV2();
    }

    public void addTorques(float torque1, float torque2) {
        if (this.getBody(0) != null && this.getBody(1) != null) {
            MathUtils.dMULTIPLY0_331((Real)this.axis1, this.getBody(0).getRotation(), (Real)this.axis1);
            MathUtils.dMULTIPLY0_331((Real)this.axis2, this.getBody(1).getRotation(), (Real)this.axis2);
            this.axis1.m[0] = this.axis1.m[0] * torque1 + this.axis2.m[0] * torque2;
            this.axis1.m[1] = this.axis1.m[1] * torque1 + this.axis2.m[1] * torque2;
            this.axis1.m[2] = this.axis1.m[2] * torque1 + this.axis2.m[2] * torque2;
            this.getBody(0).addTorque(this.axis1.m[0], this.axis1.m[1], this.axis1.m[2]);
            this.getBody(1).addTorque(-this.axis1.m[0], -this.axis1.m[1], -this.axis1.m[2]);
        }
    }

    private float measureHinge2Angle() {
        Vector3 a1 = new Vector3();
        Vector3 a2 = new Vector3();
        MathUtils.dMULTIPLY0_331((Real)a1, this.getBody(1).getRotation(), (Real)this.axis2);
        MathUtils.dMULTIPLY1_331(a2, this.getBody(0).getRotation(), a1);
        float x = this.v1.dot(a1);
        float y = this.v2.dot(a2);
        return (float)(-Math.atan2(y, x));
    }

    private float[] getAxisInfo(Vector3 axis, Vector3 ax1, Vector3 ax2) {
        if (ax1 == null) {
            ax1 = new Vector3();
        }
        if (ax2 == null) {
            ax2 = new Vector3();
        }
        MathUtils.dMULTIPLY0_331((Real)ax1, this.getBody(0).getRotation(), (Real)this.axis1);
        MathUtils.dMULTIPLY0_331((Real)ax2, this.getBody(1).getRotation(), (Real)this.axis2);
        axis = ax1.cross(ax2);
        float[] sincos = new float[]{axis.length(), ax1.dot(ax2)};
        return sincos;
    }

    private void makeHinge2V1andV2() {
        if (this.getBody(0) != null) {
            Vector3 ax1 = new Vector3();
            MathUtils.dMULTIPLY0_331((Real)ax1, this.getBody(0).getRotation(), (Real)this.axis1);
            Vector3 ax2 = new Vector3();
            MathUtils.dMULTIPLY0_331((Real)ax2, this.getBody(1).getRotation(), (Real)this.axis2);
            if (ax1.m[0] == 0.0f && ax1.m[1] == 0.0f && ax1.m[2] == 0.0f || ax2.m[0] == 0.0f && ax2.m[1] == 0.0f && ax2.m[2] == 0.0f || ax1.m[0] == ax2.m[0] && ax1.m[1] == ax2.m[1] && ax1.m[2] == ax2.m[2]) {
                return;
            }
            float k = ax1.dot(ax2);
            int i = 0;
            while (i < 3) {
                int n = i;
                ax2.m[n] = ax2.m[n] - k * ax1.m[i];
                ++i;
            }
            ax2.normalize();
            Vector3 v = ax1.cross(ax2);
            MathUtils.dMULTIPLY1_331(this.v1, this.getBody(0).getRotation(), ax2);
            MathUtils.dMULTIPLY1_331(this.v2, this.getBody(0).getRotation(), v);
        }
    }

    public JointHinge2 cloneState(ClonedReferences util) {
        JointHinge2 clone = new JointHinge2();
        this.partialCloneJoint(clone, util);
        clone.axis1.set(this.axis1);
        clone.axis2.set(this.axis2);
        clone.anchor1.set(this.anchor1);
        clone.anchor2.set(this.anchor2);
        clone.limot1 = (JointLimitMotor)util.getClone(this.limot1);
        clone.limot2 = (JointLimitMotor)util.getClone(this.limot2);
        clone.c0 = this.c0;
        clone.s0 = this.s0;
        clone.susp_erp = this.susp_erp;
        clone.susp_cfm = this.susp_cfm;
        clone.v1.set(this.v1);
        clone.v2.set(this.v2);
        return clone;
    }
}

