/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.joint;

import net.java.dev.joode.Body;
import net.java.dev.joode.joint.Joint;
import net.java.dev.joode.util.MathUtils;
import net.java.dev.joode.util.Quaternion;
import net.java.dev.joode.util.Real;
import net.java.dev.joode.util.RealPointer;
import net.java.dev.joode.util.Vector3;

public final class JointUtils {
    public static final void setBall(Joint joint, Joint.Info2 info, Vector3 anchor1, Vector3 anchor2) {
        Vector3 a1 = new Vector3();
        Vector3 a2 = new Vector3();
        int s = info.rowskip;
        info.J1l.setValue(0, 1.0f);
        info.J1l.setValue(s + 1, 1.0f);
        info.J1l.setValue(2 * s + 2, 1.0f);
        MathUtils.dMULTIPLY0_331((Real)a1, joint.getBody(0).getRotation(), (Real)anchor1);
        MathUtils.dCROSSMAT_MINUS_PLUS(info.J1a, new RealPointer(a1), s);
        if (joint.getBody(1) != null) {
            info.J2l.setValue(0, -1.0f);
            info.J2l.setValue(s + 1, -1.0f);
            info.J2l.setValue(2 * s + 2, -1.0f);
            MathUtils.dMULTIPLY0_331((Real)a2, joint.getBody(1).getRotation(), (Real)anchor2);
            MathUtils.dCROSSMAT_PLUS_MINUS(info.J2a, new RealPointer(a2), s);
        }
        float k = info.fps * info.erp;
        if (joint.getBody(1) != null) {
            int j = 0;
            while (j < 3) {
                info.c.setValue(j, k * (a2.get(j) + joint.getBody(1).getPosition().get(j) - a1.get(j) - joint.getBody(0).getPosition().get(j)));
                ++j;
            }
        } else {
            int j = 0;
            while (j < 3) {
                info.c.setValue(j, k * (anchor2.get(j) - a1.get(j) - joint.getBody(0).getPosition().get(j)));
                ++j;
            }
        }
    }

    public static void setBall2(Joint joint, Joint.Info2 info, Vector3 anchor1, Vector3 anchor2, Vector3 axis, float erp1) {
        int s = info.rowskip;
        Vector3 q1 = new Vector3();
        Vector3 q2 = new Vector3();
        axis.constructPlaneSpace(q1, q2);
        int i = 0;
        while (i < 3) {
            info.J1l.setValue(i, axis.m[i]);
            ++i;
        }
        i = 0;
        while (i < 3) {
            info.J1l.setValue(s + i, q1.m[i]);
            ++i;
        }
        i = 0;
        while (i < 3) {
            info.J1l.setValue(2 * s + i, q2.m[i]);
            ++i;
        }
        Vector3 a1 = new Vector3();
        Vector3 a2 = null;
        MathUtils.dMULTIPLY0_331((Real)a1, joint.getBody(0).getRotation(), (Real)anchor1);
        a1.cross(axis, info.J1a);
        a1.cross(q1, info.J1a.add(s));
        a1.cross(q2, info.J1a.add(2 * s));
        if (joint.getBody(1) != null) {
            a2 = new Vector3();
            i = 0;
            while (i < 3) {
                info.J2l.setValue(i, -axis.m[i]);
                ++i;
            }
            i = 0;
            while (i < 3) {
                info.J2l.setValue(s + i, -q1.m[i]);
                ++i;
            }
            i = 0;
            while (i < 3) {
                info.J2l.setValue(2 * s + i, -q2.m[i]);
                ++i;
            }
            MathUtils.dMULTIPLY0_331((Real)a2, joint.getBody(1).getRotation(), (Real)anchor2);
            MathUtils.dCROSS_EQUAL_MINUS(info.J2a, a2, axis);
            MathUtils.dCROSS_EQUAL_MINUS(info.J2a.add(s), a2, q1);
            MathUtils.dCROSS_EQUAL_MINUS(info.J2a.add(2 * s), a2, q2);
        }
        float k1 = info.fps * erp1;
        float k = info.fps * info.erp;
        i = 0;
        while (i < 3) {
            int n = i;
            a1.m[n] = a1.m[n] + joint.getBody((int)0).getPosition().m[i];
            ++i;
        }
        if (joint.getBody(1) != null) {
            i = 0;
            while (i < 3) {
                int n = i;
                a2.m[n] = a2.m[n] + joint.getBody((int)1).getPosition().m[i];
                ++i;
            }
            info.c.setValue(0, k1 * (axis.dot(a2) - axis.dot(a1)));
            info.c.setValue(1, k * (q1.dot(a2) - q1.dot(a1)));
            info.c.setValue(2, k * (q2.dot(a2) - q2.dot(a1)));
        } else {
            info.c.setValue(0, k1 * (axis.dot(anchor2) - axis.dot(a1)));
            info.c.setValue(1, k * (q1.dot(anchor2) - q1.dot(a1)));
            info.c.setValue(2, k * (q2.dot(anchor2) - q2.dot(a1)));
        }
    }

    public static final void setFixedOrientation(Joint joint, Joint.Info2 info, Quaternion qrel, int start_row) {
        int s = info.rowskip;
        int start_index = start_row * s;
        info.J1a.setValue(start_index, 1.0f);
        info.J1a.setValue(start_index + s + 1, 1.0f);
        info.J1a.setValue(start_index + s * 2 + 2, 1.0f);
        if (joint.getBody(1) != null) {
            info.J2a.setValue(start_index, -1.0f);
            info.J2a.setValue(start_index + s + 1, -1.0f);
            info.J2a.setValue(start_index + s * 2 + 2, -1.0f);
        }
        Quaternion qerr = new Quaternion();
        Quaternion e = new Quaternion();
        if (joint.getBody(1) != null) {
            Quaternion qq = new Quaternion();
            joint.getBody(0).getQuaternion().mul(joint.getBody(1).getQuaternion(), qq);
            qerr.mul(qq, qrel);
        } else {
            qerr.mul(joint.getBody(0).getQuaternion(), qrel);
        }
        if (qerr.m[0] < 0.0f) {
            qerr.m[1] = -qerr.m[1];
            qerr.m[2] = -qerr.m[2];
            qerr.m[3] = -qerr.m[3];
        }
        MathUtils.dMULTIPLY0_331(new RealPointer(e), new RealPointer(joint.getBody(0).getRotation()), new RealPointer(qerr).add(1));
        float k = info.fps * info.erp;
        info.c.setValue(start_row, 2.0f * k * e.m[0]);
        info.c.setValue(start_row + 1, 2.0f * k * e.m[1]);
        info.c.setValue(start_row + 2, 2.0f * k * e.m[2]);
    }

    public static final void setAnchors(Joint j, float x, float y, float z, Vector3 anchor1, Vector3 anchor2) {
        Body body0 = j.getBody(0);
        Body body1 = j.getBody(1);
        if (body0 != null) {
            Real q = new Real(4);
            q.m[0] = x - body0.getPosition().getX();
            q.m[1] = y - body0.getPosition().getY();
            q.m[2] = z - body0.getPosition().getZ();
            q.m[3] = 0.0f;
            MathUtils.dMULTIPLY1_331(anchor1, body0.getRotation(), q);
            if (body1 != null) {
                q.m[0] = x - body1.getPosition().getX();
                q.m[1] = y - body1.getPosition().getY();
                q.m[2] = z - body1.getPosition().getZ();
                q.m[3] = 0.0f;
                MathUtils.dMULTIPLY1_331(anchor2, body1.getRotation(), q);
            } else {
                anchor2.set(x, y, z);
            }
        }
        anchor1.m[3] = 0.0f;
        anchor2.m[3] = 0.0f;
    }

    static void setAxes(Joint j, float x, float y, float z, Vector3 axis1, Vector3 axis2) {
        if (j.getBody(0) != null) {
            Vector3 q = new Vector3();
            q.m[0] = x;
            q.m[1] = y;
            q.m[2] = z;
            q.m[3] = 0.0f;
            q.normalize();
            if (axis1 != null) {
                MathUtils.dMULTIPLY1_331(axis1, j.getBody(0).getRotation(), q);
                axis1.m[3] = 0.0f;
            }
            if (axis2 != null) {
                if (j.getBody(1) != null) {
                    MathUtils.dMULTIPLY1_331(axis2, j.getBody(1).getRotation(), q);
                } else {
                    axis2.m[0] = x;
                    axis2.m[1] = y;
                    axis2.m[2] = z;
                }
                axis2.m[3] = 0.0f;
            }
        }
    }

    public static final void getAnchor(Joint j, Vector3 result, Vector3 anchor1) {
        Body body0 = j.getBody(0);
        if (body0 != null) {
            MathUtils.dMULTIPLY0_331((Real)result, body0.getRotation(), (Real)anchor1);
            result.m[0] = result.m[0] + body0.getPosition().getX();
            result.m[1] = result.m[1] + body0.getPosition().getY();
            result.m[2] = result.m[2] + body0.getPosition().getZ();
        }
    }

    public static final void getAnchor2(Joint j, Vector3 result, Vector3 anchor2) {
        Body body1 = j.getBody(1);
        if (body1 != null) {
            MathUtils.dMULTIPLY0_331((Real)result, body1.getRotation(), (Real)anchor2);
            result.m[0] = result.m[0] + body1.getPosition().getX();
            result.m[1] = result.m[1] + body1.getPosition().getY();
            result.m[2] = result.m[2] + body1.getPosition().getZ();
        } else {
            result.m[0] = anchor2.m[0];
            result.m[1] = anchor2.m[1];
            result.m[2] = anchor2.m[2];
        }
    }
}

