/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.space;

import java.util.Iterator;
import net.java.dev.joode.ClonedReferences;
import net.java.dev.joode.SimState;
import net.java.dev.joode.geom.Geom;
import net.java.dev.joode.space.AbstractSimpleSpace;
import net.java.dev.joode.space.NearCallback;
import net.java.dev.joode.space.Space;
import org.openmali.FastMath;

public class HashSpace
extends AbstractSimpleSpace {
    private static final long serialVersionUID = 3043068072710126413L;
    private static long[] PRIMES = new long[]{1L, 2L, 3L, 7L, 13L, 31L, 61L, 127L, 251L, 509L, 1021L, 2039L, 4093L, 8191L, 16381L, 32749L, 65521L, 131071L, 262139L, 524287L, 1048573L, 0x1FFFF7L, 0x3FFFFDL, 0x7FFFF1L, 0xFFFFFDL, 33554393L, 0x3FFFFFBL, 134217689L, 0xFFFFFC7L, 0x1FFFFFFDL, 0x3FFFFFDDL};
    private int global_minlevel = -3;
    private int global_maxlevel = 10;
    private static final FastMath.FRExpResultf frexpResult = new FastMath.FRExpResultf();

    public HashSpace(Space parentSpace) {
        super(parentSpace, 12);
        if (parentSpace != null) {
            parentSpace.add(this);
        }
    }

    private static int findLevel(float[] bounds) {
        if (bounds[0] <= Float.NEGATIVE_INFINITY || bounds[1] >= Float.POSITIVE_INFINITY || bounds[2] <= Float.NEGATIVE_INFINITY || bounds[3] >= Float.POSITIVE_INFINITY || bounds[4] <= Float.NEGATIVE_INFINITY || bounds[5] >= Float.POSITIVE_INFINITY) {
            return Integer.MAX_VALUE;
        }
        float q2 = bounds[3] - bounds[2];
        float q = bounds[1] - bounds[0];
        if (q2 > q) {
            q = q2;
        }
        if ((q2 = bounds[5] - bounds[4]) > q) {
            q = q2;
        }
        FastMath.frexp((float)q, (FastMath.FRExpResultf)frexpResult);
        int level = HashSpace.frexpResult.exponent;
        return level;
    }

    private static long getVirtualAddress(int level, int x, int y, int z) {
        return level * 1000 + x * 100 + y * 10 + z;
    }

    public void setLevels(int minlevel, int maxlevel) {
        this.global_minlevel = minlevel;
        this.global_maxlevel = maxlevel;
    }

    public final int getMinLevel() {
        return this.global_minlevel;
    }

    public final int getMaxLevel() {
        return this.global_maxlevel;
    }

    public void collideAll(Object userData, NearCallback callback) {
        if (this.getNumGeoms() < 2) {
            return;
        }
        this.cleanGeoms();
        int i = 0;
        int n = 0;
        dxAABB first_aabb = null;
        dxAABB big_boxes = null;
        int maxlevel = this.global_minlevel - 1;
        Iterator<Geom> it = this.getGeomIterator();
        while (it.hasNext()) {
            Geom geom = it.next();
            if (!geom.isEnabled()) continue;
            dxAABB aabb = new dxAABB();
            aabb.geom = geom;
            int level = HashSpace.findLevel(geom.getAABB().getValues());
            if (level < this.global_minlevel) {
                level = this.global_minlevel;
            }
            if (level <= this.global_maxlevel) {
                aabb.next = first_aabb;
                first_aabb = aabb;
                aabb.level = level;
                if (level > maxlevel) {
                    maxlevel = level;
                }
                float cellsize = FastMath.pow((float)2.0f, (float)level);
                i = 0;
                while (i < 6) {
                    aabb.dbounds[i] = (int)Math.floor(geom.getAABB().getValues()[i] / cellsize);
                    ++i;
                }
                aabb.index = n++;
                continue;
            }
            aabb.next = big_boxes;
            big_boxes = aabb;
        }
        int tested_rowsize = n + 7 >> 3;
        byte[] tested = new byte[n * tested_rowsize];
        i = 0;
        while (i < tested.length) {
            tested[i] = 0;
            ++i;
        }
        i = 0;
        while (i < PRIMES.length) {
            if (PRIMES[i] >= (long)(8 * n)) break;
            ++i;
        }
        if (i >= PRIMES.length) {
            i = PRIMES.length - 1;
        }
        int sz = (int)PRIMES[i];
        Node[] table = new Node[sz];
        i = 0;
        while (i < sz) {
            table[i] = null;
            ++i;
        }
        dxAABB aabb = first_aabb;
        while (aabb != null) {
            int[] dbounds = aabb.dbounds;
            int xi = dbounds[0];
            while (xi <= dbounds[1]) {
                int yi = dbounds[2];
                while (yi <= dbounds[3]) {
                    int zi = dbounds[4];
                    while (zi <= dbounds[5]) {
                        long hi = HashSpace.getVirtualAddress(aabb.level, xi, yi, zi) % (long)sz;
                        Node node = new Node();
                        node.x = xi;
                        node.y = yi;
                        node.z = zi++;
                        node.aabb = aabb;
                        node.next = table[(int)hi];
                        table[(int)hi] = node;
                    }
                    ++yi;
                }
                ++xi;
            }
            aabb = aabb.next;
        }
        int[] db = new int[6];
        dxAABB aabb2 = first_aabb;
        while (aabb2 != null) {
            i = 0;
            while (i < 6) {
                db[i] = aabb2.dbounds[i];
                ++i;
            }
            int level = aabb2.level;
            while (level <= maxlevel) {
                int xi = db[0];
                while (xi <= db[1]) {
                    int yi = db[2];
                    while (yi <= db[3]) {
                        int zi = db[4];
                        while (zi <= db[5]) {
                            long hi = HashSpace.getVirtualAddress(level, xi, yi, zi) % (long)sz;
                            Node node = table[(int)hi];
                            while (node != null) {
                                if (node.aabb != aabb2 && node.aabb.level == level && node.x == xi && node.y == yi && node.z == zi) {
                                    int mask;
                                    if (aabb2.index <= node.aabb.index) {
                                        i = aabb2.index * tested_rowsize + (node.aabb.index >> 3);
                                        mask = 1 << (node.aabb.index & 7);
                                    } else {
                                        i = node.aabb.index * tested_rowsize + (aabb2.index >> 3);
                                        mask = 1 << (aabb2.index & 7);
                                    }
                                    if ((tested[i] & mask) == 0) {
                                        HashSpace.collideAABBs(aabb2.geom, node.aabb.geom, userData, callback);
                                    }
                                    int n2 = i;
                                    tested[n2] = (byte)(tested[n2] | mask);
                                }
                                node = node.next;
                            }
                            ++zi;
                        }
                        ++yi;
                    }
                    ++xi;
                }
                i = 0;
                while (i < 6) {
                    int n3 = i++;
                    db[n3] = db[n3] >> 1;
                }
                ++level;
            }
            aabb2 = aabb2.next;
        }
        aabb2 = first_aabb;
        while (aabb2 != null) {
            dxAABB aabb22 = big_boxes;
            while (aabb22 != null) {
                HashSpace.collideAABBs(aabb2.geom, aabb22.geom, userData, callback);
                aabb22 = aabb22.next;
            }
            aabb2 = aabb2.next;
        }
        aabb2 = big_boxes;
        while (aabb2 != null) {
            dxAABB aabb23 = aabb2.next;
            while (aabb23 != null) {
                HashSpace.collideAABBs(aabb2.geom, aabb23.geom, userData, callback);
                aabb23 = aabb23.next;
            }
            aabb2 = aabb2.next;
        }
    }

    public void collide(Object data, Geom geom, boolean isSpaceFirst, NearCallback callback) {
        this.cleanGeoms();
        geom.recomputeAABB();
        Iterator<Geom> it = this.getGeomIterator();
        while (it.hasNext()) {
            Geom g = it.next();
            if (!g.isEnabled()) continue;
            if (isSpaceFirst) {
                HashSpace.collideAABBs(g, geom, data, callback);
                continue;
            }
            HashSpace.collideAABBs(geom, g, data, callback);
        }
    }

    public SimState cloneState(ClonedReferences util) {
        throw new UnsupportedOperationException("cloneState is not yet implemented.");
    }

    private class Node {
        Node next;
        int x;
        int y;
        int z;
        dxAABB aabb;

        private Node() {
        }
    }

    private class dxAABB {
        dxAABB next;
        int level;
        final int[] dbounds = new int[6];
        Geom geom;
        int index;

        private dxAABB() {
        }
    }
}

