/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.space;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.java.dev.joode.Body;
import net.java.dev.joode.ClonedReferences;
import net.java.dev.joode.SimState;
import net.java.dev.joode.geom.Geom;
import net.java.dev.joode.space.GeomListener;
import net.java.dev.joode.space.NearCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Space
extends Geom {
    private final ArrayList<GeomListener> listeners = new ArrayList();

    public Space(Space parent, int type) {
        super(parent, type, false);
    }

    protected Space() {
        super(0, false);
    }

    @Override
    public void computeAABB() {
        if (!this.isEmpty()) {
            this.getAABB().prepare();
            float[] a = this.getAABB().getValues();
            Iterator<Geom> iter = this.getGeomIterator();
            while (iter.hasNext()) {
                Geom g = iter.next();
                float[] ga = g.getAABB().getValues();
                g.recomputeAABB();
                int i = 0;
                while (i < 6) {
                    if (ga[i] < a[i]) {
                        a[i] = ga[i];
                    }
                    i += 2;
                }
                i = 1;
                while (i < 6) {
                    if (ga[i] > a[i]) {
                        a[i] = ga[i];
                    }
                    i += 2;
                }
            }
        } else {
            this.getAABB().setZero();
        }
    }

    public boolean query(Geom g) {
        return g.getParentSpace() == this;
    }

    protected abstract boolean isEmpty();

    public abstract Iterator<Geom> getGeomIterator();

    public abstract int getNumGeoms();

    public abstract void getGeoms(List<Geom> var1);

    public static boolean canCollide(Geom g1, Geom g2, boolean ignoreStatic) {
        return g1.isEnabled() && g2.isEnabled() && (!ignoreStatic || g1.getBody() != null || g2.getBody() != null);
    }

    public abstract void cleanGeoms();

    public abstract void collideAll(Object var1, NearCallback var2);

    public abstract void collide(Object var1, Geom var2, boolean var3, NearCallback var4);

    public abstract void add(Geom var1);

    public void addBodyGeoms(Body b) {
        int n = b.getNumGeoms();
        int i = 0;
        while (i < n) {
            Geom geom = b.getGeom(i);
            if (geom.getParentSpace() == null) {
                this.add(geom);
            }
            ++i;
        }
    }

    public abstract void remove(Geom var1);

    public void removeBodyGeoms(Body b) {
        int n = b.getNumGeoms();
        int i = 0;
        while (i < n) {
            Geom geom = b.getGeom(i);
            if (geom.getParentSpace() == this) {
                this.remove(geom);
            }
            ++i;
        }
    }

    void dirty(Geom g) {
        this.remove(g);
        this.add(g);
    }

    public static void onGeomMoved(Geom g) {
        Space parent = g.getParentSpace();
        if (g.getPosition() != null) {
            g.position2LastPosition();
        }
        while (parent != null && !g.getFlag(Geom.GEOM_DIRTY)) {
            g.setFlag(GEOM_DIRTY | GEOM_AABB_BAD, true);
            parent.dirty(g);
            g = parent;
            parent = parent.getParentSpace();
        }
        while (g != null) {
            g.setFlag(GEOM_DIRTY | GEOM_AABB_BAD, true);
            g = g.getParentSpace();
        }
    }

    public void addGeomListener(GeomListener l) {
        this.listeners.add(l);
    }

    public void removeGeomListener(GeomListener l) {
        this.listeners.remove(l);
    }

    protected void notifyGeomAdded(Geom geom) {
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.get(i).geomAdded(this, geom);
            ++i;
        }
    }

    protected void notifyGeomRemoved(Geom geom) {
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.get(i).geomRemoved(this, geom);
            ++i;
        }
    }

    public void clonePartialSpace(Space partialClone, ClonedReferences util) {
        this.clonePartialGeom(partialClone, util);
        int i = 0;
        while (i < this.listeners.size()) {
            GeomListener l = this.listeners.get(i);
            if (l instanceof SimState) {
                partialClone.addGeomListener((GeomListener)((Object)util.getClone((SimState)((Object)l))));
            }
            ++i;
        }
    }
}

