/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.space.octtree;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import net.java.dev.joode.ClonedReferences;
import net.java.dev.joode.SimState;
import net.java.dev.joode.geom.Geom;
import net.java.dev.joode.space.NearCallback;
import net.java.dev.joode.space.Space;
import net.java.dev.joode.util.AABB3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OctTreeNode
implements SimState {
    private static final long serialVersionUID = -9194368522700993137L;
    static final int MIN_CAPACITY = 5;
    static final int MAX_CAPACITY = 10;
    protected SplitType type;
    protected OctTreeNode right;
    protected OctTreeNode left;
    protected AABB3f aabb;
    protected Set<Geom> geoms;
    protected boolean splitted;
    protected int numGeoms;
    protected float splitPos;

    public OctTreeNode(SplitType t, AABB3f aabb) {
        this.type = t;
        this.aabb = aabb;
        this.geoms = new LinkedHashSet<Geom>();
        this.splitted = false;
    }

    public int getNumGeoms() {
        return this.numGeoms;
    }

    public void getGeoms(Set<Geom> geoms) {
        geoms.addAll(geoms);
        if (this.left != null) {
            this.left.getGeoms(geoms);
        }
        if (this.right != null) {
            this.right.getGeoms(geoms);
        }
    }

    private boolean getSideMin(AABB3f aabb) {
        switch (this.type) {
            case X: {
                return aabb.getMinX() < this.splitPos;
            }
            case Y: {
                return aabb.getMinY() < this.splitPos;
            }
        }
        return aabb.getMinZ() < this.splitPos;
    }

    private boolean getSideMax(AABB3f aabb) {
        switch (this.type) {
            case X: {
                return aabb.getMaxX() < this.splitPos;
            }
            case Y: {
                return aabb.getMaxY() < this.splitPos;
            }
        }
        return aabb.getMaxZ() < this.splitPos;
    }

    private void split() {
        AABB3f raabb = new AABB3f(this.aabb);
        AABB3f laabb = new AABB3f(this.aabb);
        switch (this.type) {
            case X: {
                this.splitPos = (this.aabb.getMinX() + this.aabb.getMaxY()) / 2.0f;
                raabb.setMinX(this.splitPos);
                laabb.setMaxX(this.splitPos);
                this.right = new OctTreeNode(SplitType.Y, raabb);
                this.left = new OctTreeNode(SplitType.Y, laabb);
                break;
            }
            case Y: {
                this.splitPos = (this.aabb.getMinX() + this.aabb.getMaxY()) / 2.0f;
                raabb.setMinY(this.splitPos);
                laabb.setMaxY(this.splitPos);
                this.right = new OctTreeNode(SplitType.Z, raabb);
                this.left = new OctTreeNode(SplitType.Z, laabb);
                break;
            }
            case Z: {
                this.splitPos = (this.aabb.getMinZ() + this.aabb.getMaxZ()) / 2.0f;
                raabb.setMinZ(this.splitPos);
                laabb.setMaxZ(this.splitPos);
                this.right = new OctTreeNode(SplitType.X, raabb);
                this.left = new OctTreeNode(SplitType.X, laabb);
            }
        }
        Iterator<Geom> i = this.geoms.iterator();
        while (i.hasNext()) {
            Geom g = i.next();
            boolean a = this.getSideMin(g.getAABB());
            boolean b = this.getSideMax(g.getAABB());
            if (b == a) continue;
            if (a) {
                this.left.add(g);
            }
            if (b) {
                this.right.add(g);
            }
            i.remove();
        }
        this.splitted = true;
    }

    public void add(Geom g) {
        ++this.numGeoms;
        if (!this.splitted) {
            this.geoms.add(g);
            if (this.numGeoms > 10) {
                this.split();
            }
        } else {
            boolean a = this.getSideMin(g.getAABB());
            boolean b = this.getSideMax(g.getAABB());
            if (b != a) {
                if (a) {
                    this.left.add(g);
                }
                if (b) {
                    this.right.add(g);
                }
            } else {
                this.geoms.add(g);
            }
        }
    }

    private void merge() {
        this.geoms.addAll(this.left.geoms);
        this.geoms.addAll(this.right.geoms);
        this.splitted = false;
    }

    public boolean remove(Geom g) {
        if (!this.splitted) {
            if (this.geoms.remove(g)) {
                --this.numGeoms;
                return true;
            }
            return false;
        }
        boolean b = false;
        if (this.geoms.remove(g)) {
            b = true;
        }
        if (!b && this.getSideMin(g.getAABB())) {
            b |= this.left.remove(g);
        }
        if (!b && !this.getSideMax(g.getAABB())) {
            b |= this.right.remove(g);
        }
        if (b) {
            --this.numGeoms;
        }
        if (this.numGeoms < 5) {
            this.merge();
        }
        return b;
    }

    public Iterator<Geom> iterator() {
        if (!this.splitted) {
            return this.geoms.iterator();
        }
        return new TreeIterator();
    }

    public void collide(Object data, NearCallback callback) {
        for (Geom g1 : this.geoms) {
            if (!g1.isEnabled()) continue;
            boolean b = false;
            for (Geom g2 : this.geoms) {
                if (b && Space.canCollide(g1, g2, callback.ignoreStatic())) {
                    Geom.collideAABBs(g1, g2, data, callback);
                    continue;
                }
                if (g1 != g2) continue;
                b = true;
            }
        }
        if (this.splitted) {
            this.left.collide(data, callback);
            this.right.collide(data, callback);
            for (Geom g1 : this.geoms) {
                if (!g1.isEnabled()) continue;
                this.left.collide2(data, g1, true, callback);
                this.right.collide2(data, g1, true, callback);
            }
        }
    }

    public void collide2(Object data, Geom geom, boolean spaceIsFirst, NearCallback callback) {
        if (!this.aabb.intersects(geom.getAABB())) {
            return;
        }
        for (Geom g : this.geoms) {
            if (!g.isEnabled()) continue;
            if (spaceIsFirst) {
                Geom.collideAABBs(g, geom, data, callback);
                continue;
            }
            Geom.collideAABBs(geom, g, data, callback);
        }
        if (this.splitted) {
            if (spaceIsFirst) {
                this.left.collide2(data, geom, spaceIsFirst, callback);
                this.right.collide2(data, geom, spaceIsFirst, callback);
            } else {
                this.left.collide2(data, geom, spaceIsFirst, callback);
                this.right.collide2(data, geom, spaceIsFirst, callback);
            }
        }
    }

    public AABB3f getAABB() {
        return this.aabb;
    }

    @Override
    public SimState cloneState(ClonedReferences util) {
        OctTreeNode clone = new OctTreeNode(this.type, this.aabb.clone());
        util.addClone(this, clone);
        clone.splitted = this.splitted;
        clone.splitPos = this.splitPos;
        clone.left = (OctTreeNode)util.getClone(this.left);
        clone.right = (OctTreeNode)util.getClone(this.right);
        clone.numGeoms = this.numGeoms;
        for (Geom geom : this.geoms) {
            clone.geoms.add((Geom)util.getClone(geom));
        }
        return clone;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SplitType {
        X,
        Y,
        Z;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TreeIterator
    implements Iterator<Geom> {
        Iterator<Geom> i;
        int iter;

        public TreeIterator() {
            this.i = OctTreeNode.this.geoms.iterator();
            this.iter = 0;
        }

        @Override
        public boolean hasNext() {
            if (this.i.hasNext()) {
                return true;
            }
            if (this.iter < 2) {
                return false;
            }
            ++this.iter;
            this.i = this.iter == 1 ? OctTreeNode.this.left.iterator() : OctTreeNode.this.right.iterator();
            if (this.i.hasNext()) {
                return true;
            }
            if (this.iter == 1) {
                ++this.iter;
                this.i = OctTreeNode.this.right.iterator();
            }
            return this.i.hasNext();
        }

        @Override
        public Geom next() {
            return this.i.next();
        }

        @Override
        public void remove() {
            this.i.remove();
        }
    }
}

