/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.stepper;

import net.java.dev.joode.Body;
import net.java.dev.joode.World;
import net.java.dev.joode.util.CompositeVectorRegular;
import net.java.dev.joode.util.RK4;

public class AccurateSimpleStepper {
    private static final AccurateSimpleStepper INSTANCE = new AccurateSimpleStepper();
    private static float accuracy = 0.001f;

    private AccurateSimpleStepper() {
    }

    public static final AccurateSimpleStepper getInstance() {
        return INSTANCE;
    }

    public static final void setAccuracy(float accuracy) {
        AccurateSimpleStepper.accuracy = accuracy;
    }

    public static final float getAccuracy() {
        return accuracy;
    }

    public void step(World world, float t_start, float t_end) {
        CompositeVectorRegular worldState = new CompositeVectorRegular();
        CompositeVectorRegular.CompositeDifferential worldDifferentiator = new CompositeVectorRegular.CompositeDifferential();
        Body b = world.getFirstBody();
        while (b != null) {
            worldState.addVector(b.getState());
            worldDifferentiator.addComponent(b.getDifferential());
            b = b.getNext();
        }
        RK4.intergrateAapative(worldState, worldDifferentiator, t_start, t_end, accuracy, worldState);
        b = world.getFirstBody();
        while (b != null) {
            b.recalc();
            b = b.getNext();
        }
    }
}

