/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.stepper;

import net.java.dev.joode.Body;
import net.java.dev.joode.World;
import net.java.dev.joode.joint.Joint;
import net.java.dev.joode.stepper.StepperFunction;
import net.java.dev.joode.stepper.lcp.BaraffLCPFixedStatic;
import net.java.dev.joode.util.IntPointer;
import net.java.dev.joode.util.MathUtils;
import net.java.dev.joode.util.Matrix3;
import net.java.dev.joode.util.Real;
import net.java.dev.joode.util.RealPointer;
import net.java.dev.joode.util.Vector3;

public class EulerStepper
implements StepperFunction {
    public static final Vector3 taccTmp = new Vector3();
    public static final Vector3 faccTmp = new Vector3();
    public static final Vector3 avel = new Vector3();
    public static final Vector3 lvel = new Vector3();
    public static final boolean DIRECT_CHOLESKY = false;
    public static final boolean JAMA_CHOLESKY = false;
    public static final boolean OLD_LCP = false;
    public static final boolean REPORT_ERROR = false;
    private static final EulerStepper INSTANCE;
    public static final Matrix3 tmp;
    public static final Joint.Info2 Jinfo;

    static {
        tmp = new Matrix3();
        Jinfo = new Joint.Info2();
        INSTANCE = new EulerStepper();
        EulerStepper.Jinfo.J1l = RealPointer.pool.aquire(null);
        EulerStepper.Jinfo.J1a = RealPointer.pool.aquire(null);
        EulerStepper.Jinfo.J2l = RealPointer.pool.aquire(null);
        EulerStepper.Jinfo.J2a = RealPointer.pool.aquire(null);
        EulerStepper.Jinfo.c = RealPointer.pool.aquire(null);
        EulerStepper.Jinfo.cfm = RealPointer.pool.aquire(null);
        EulerStepper.Jinfo.lo = RealPointer.pool.aquire(null);
        EulerStepper.Jinfo.hi = RealPointer.pool.aquire(null);
        EulerStepper.Jinfo.findex = new IntPointer(null);
    }

    public static final EulerStepper getInstance() {
        return INSTANCE;
    }

    private EulerStepper() {
    }

    public void step(World world, Body[] body, int nb, Joint[] joint, int nj, float t_start, float t_end) {
        int n6 = 6 * nb;
        float stepsize = t_end - t_start;
        int i = 0;
        while (i < nb) {
            body[i].setTag(i);
            ++i;
        }
        RealPointer I = RealPointer.pool.aquire(Real.pool.aquire(3 * nb * 4));
        RealPointer invI = RealPointer.pool.aquire(Real.pool.aquire(3 * nb * 4));
        i = 0;
        while (i < nb) {
            body[i].getMass().getMomentOfInertia().mulTranspose(body[i].getRotation(), tmp);
            MathUtils.dMULTIPLY0_333(I.add(i * 12, RealPointer.tmp), (Real)body[i].getRotation(), tmp);
            body[i].getMass().invI.mulTranspose(body[i].getRotation(), tmp);
            MathUtils.dMULTIPLY0_333(invI.add(i * 12, RealPointer.tmp), (Real)body[i].getRotation(), tmp);
            body[i].getAngularVel(avel);
            MathUtils.dMULTIPLY0_331((Real)tmp, I.add(i * 12, RealPointer.tmp), (Real)avel);
            Vector3 rotForce2 = Vector3.pool.aquire();
            MathUtils.dCROSS_MINUSEQUAL(rotForce2, avel, tmp);
            body[i].getTACC().add(rotForce2);
            Vector3.pool.release(rotForce2);
            ++i;
        }
        i = 0;
        while (i < nb) {
            body[i].getTotalForces(t_start, faccTmp, taccTmp);
            body[i].getTACC().set(taccTmp);
            body[i].getFACC().set(faccTmp);
            ++i;
        }
        int m = 0;
        Joint.Info1[] info = new Joint.Info1[nj];
        int[] ofs = new int[nj];
        i = 0;
        int j = 0;
        while (j < nj) {
            info[i] = new Joint.Info1();
            joint[j].getInfo1(info[i]);
            if (info[i].m > 0) {
                joint[i] = joint[j];
                ++i;
            }
            ++j;
        }
        nj = i;
        i = 0;
        while (i < nj) {
            if (info[i].nub == info[i].m) {
                ofs[i] = m;
                m += info[i].m;
            }
            ++i;
        }
        int nub = m;
        i = 0;
        while (i < nj) {
            if (info[i].nub > 0 && info[i].nub < info[i].m) {
                ofs[i] = m;
                m += info[i].m;
            }
            ++i;
        }
        i = 0;
        while (i < nj) {
            if (info[i].nub == 0) {
                ofs[i] = m;
                m += info[i].m;
            }
            ++i;
        }
        RealPointer invM = RealPointer.pool.aquire(Real.pool.aquire(n6 * n6));
        i = 0;
        while (i < nb) {
            RealPointer MM = RealPointer.pool.aquire(invM, i * 6 * n6 + i * 6);
            MM.setValue(0, body[i].getMass().getInverseMass());
            MM.setValue(n6 + 1, body[i].getMass().getInverseMass());
            MM.setValue(2 * n6 + 2, body[i].getMass().getInverseMass());
            MM = MM.add(3 * n6 + 3, MM);
            j = 0;
            while (j < 3) {
                int k = 0;
                while (k < 3) {
                    MM.setValue(j * n6 + k, invI.data.m[i * 12 + j * 4 + k]);
                    ++k;
                }
                ++j;
            }
            RealPointer.pool.release(MM);
            ++i;
        }
        RealPointer fe = RealPointer.pool.aquire(Real.pool.aquire(n6));
        RealPointer v = RealPointer.pool.aquire(Real.pool.aquire(n6));
        i = 0;
        while (i < nb) {
            body[i].getLinearVel(lvel);
            body[i].getAngularVel(avel);
            j = 0;
            while (j < 3) {
                fe.data.m[i * 6 + j] = body[i].getFACC().m[j];
                ++j;
            }
            j = 0;
            while (j < 3) {
                fe.data.m[i * 6 + 3 + j] = body[i].getTACC().m[j];
                ++j;
            }
            j = 0;
            while (j < 3) {
                v.data.m[i * 6 + j] = EulerStepper.lvel.m[j];
                ++j;
            }
            j = 0;
            while (j < 3) {
                v.data.m[i * 6 + 3 + j] = EulerStepper.avel.m[j];
                ++j;
            }
            ++i;
        }
        RealPointer vnew = RealPointer.pool.aquire(Real.pool.aquire(n6));
        if (m > 0) {
            RealPointer c = RealPointer.pool.aquire(Real.pool.aquire(m));
            RealPointer cfm = RealPointer.pool.aquire(Real.pool.aquire(m));
            RealPointer lo = RealPointer.pool.aquire(Real.pool.aquire(m));
            RealPointer hi = RealPointer.pool.aquire(Real.pool.aquire(m));
            IntPointer findex = new IntPointer(new int[m]);
            lo.getData().fill(Float.NEGATIVE_INFINITY);
            hi.getData().fill(Float.POSITIVE_INFINITY);
            i = 0;
            while (i < m) {
                findex.data[i] = -1;
                ++i;
            }
            RealPointer J = RealPointer.pool.aquire(Real.pool.aquire(m * n6));
            EulerStepper.Jinfo.rowskip = n6;
            EulerStepper.Jinfo.fps = 1.0f / stepsize;
            EulerStepper.Jinfo.erp = world.getGlobalERP();
            i = 0;
            while (i < nj) {
                EulerStepper.Jinfo.J1l = J.add(n6 * ofs[i] + 6 * joint[i].getBody(0).getTag(), EulerStepper.Jinfo.J1l);
                EulerStepper.Jinfo.J1a = EulerStepper.Jinfo.J1l.add(3, EulerStepper.Jinfo.J1a);
                if (joint[i].getBody(1) != null) {
                    EulerStepper.Jinfo.J2l = J.add(n6 * ofs[i] + 6 * joint[i].getBody(1).getTag(), EulerStepper.Jinfo.J2l);
                    EulerStepper.Jinfo.J2a = EulerStepper.Jinfo.J2l.add(3, EulerStepper.Jinfo.J2a);
                } else {
                    EulerStepper.Jinfo.J2l.data = null;
                    EulerStepper.Jinfo.J2a.data = null;
                }
                EulerStepper.Jinfo.c = c.add(ofs[i], EulerStepper.Jinfo.c);
                EulerStepper.Jinfo.cfm = cfm.add(ofs[i], EulerStepper.Jinfo.cfm);
                EulerStepper.Jinfo.lo = lo.add(ofs[i], EulerStepper.Jinfo.lo);
                EulerStepper.Jinfo.hi = hi.add(ofs[i], EulerStepper.Jinfo.hi);
                EulerStepper.Jinfo.findex = findex.add(ofs[i], EulerStepper.Jinfo.findex);
                joint[i].getInfo2(Jinfo);
                j = 0;
                while (j < info[i].m) {
                    if (findex.getValue(ofs[i] + j) >= 0) {
                        findex.setValue(ofs[i] + j, findex.getValue(ofs[i] + j) + ofs[i]);
                    }
                    ++j;
                }
                ++i;
            }
            RealPointer JinvM = RealPointer.pool.aquire(Real.pool.aquire(m * n6));
            MathUtils.dMultiply0(JinvM, J, invM, m, n6, n6);
            RealPointer A = RealPointer.pool.aquire(Real.pool.aquire(m * m));
            MathUtils.dMultiply2(A, JinvM, J, m, n6, m);
            i = 0;
            while (i < m) {
                A.setValue(i * m + i, A.getValue(i * m + i) + cfm.getValue(i) * EulerStepper.Jinfo.fps);
                ++i;
            }
            RealPointer tmp1 = RealPointer.pool.aquire(Real.pool.aquire(n6));
            MathUtils.dMultiply0(tmp1, invM, fe, n6, n6, 1);
            i = 0;
            while (i < n6) {
                tmp1.setValue(i, tmp1.getValue(i) + v.getValue(i) / stepsize);
                ++i;
            }
            RealPointer rhs = RealPointer.pool.aquire(Real.pool.aquire(m));
            MathUtils.dMultiply0(rhs, J, tmp1, m, n6, 1);
            i = 0;
            while (i < m) {
                rhs.setValue(i, c.getValue(i) / stepsize - rhs.getValue(i));
                ++i;
            }
            RealPointer lambda = RealPointer.pool.aquire(Real.pool.aquire(m));
            RealPointer residual = RealPointer.pool.aquire(Real.pool.aquire(m));
            BaraffLCPFixedStatic.INSTANCE.computeForces(m, A, lambda, rhs, residual, nub, lo, hi, findex);
            MathUtils.dMultiply1(tmp1, J, lambda, n6, m, 1);
            i = 0;
            while (i < n6) {
                tmp1.setValue(i, tmp1.getValue(i) + fe.getValue(i));
                ++i;
            }
            MathUtils.dMultiply0(vnew, invM, tmp1, n6, n6, 1);
            i = 0;
            while (i < n6) {
                vnew.setValue(i, v.getValue(i) + stepsize * vnew.getValue(i));
                ++i;
            }
            Real.pool.release(c.data);
            Real.pool.release(cfm.data);
            Real.pool.release(lo.data);
            Real.pool.release(hi.data);
            Real.pool.release(J.data);
            Real.pool.release(A.data);
            Real.pool.release(rhs.data);
            Real.pool.release(residual.data);
            Real.pool.release(JinvM.data);
            Real.pool.release(tmp1.data);
            RealPointer.pool.release(c);
            RealPointer.pool.release(cfm);
            RealPointer.pool.release(lo);
            RealPointer.pool.release(hi);
            RealPointer.pool.release(J);
            RealPointer.pool.release(A);
            RealPointer.pool.release(rhs);
            RealPointer.pool.release(residual);
            RealPointer.pool.release(JinvM);
            RealPointer.pool.release(tmp1);
        } else {
            MathUtils.dMultiply0(vnew, invM, fe, n6, n6, 1);
            i = 0;
            while (i < n6) {
                vnew.setValue(i, v.getValue(i) + stepsize * vnew.getValue(i));
                ++i;
            }
        }
        i = 0;
        while (i < nb) {
            body[i].getLinearVel(lvel);
            body[i].getAngularVel(avel);
            j = 0;
            while (j < 3) {
                EulerStepper.lvel.m[j] = vnew.getValue(i * 6 + j);
                EulerStepper.avel.m[j] = vnew.getValue(i * 6 + 3 + j);
                ++j;
            }
            body[i].setLinearVel(lvel);
            body[i].setAngularVel(avel);
            ++i;
        }
        i = 0;
        while (i < nb) {
            body[i].step(stepsize);
            ++i;
        }
        Real.pool.release(I.data);
        Real.pool.release(invI.data);
        Real.pool.release(invM.data);
        Real.pool.release(fe.data);
        Real.pool.release(v.data);
        Real.pool.release(vnew.data);
        RealPointer.pool.release(I);
        RealPointer.pool.release(invI);
        RealPointer.pool.release(invM);
        RealPointer.pool.release(fe);
        RealPointer.pool.release(v);
        RealPointer.pool.release(vnew);
    }
}

