/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.stepper;

import java.util.HashMap;
import java.util.Iterator;
import net.java.dev.joode.Body;
import net.java.dev.joode.ClonedReferences;
import net.java.dev.joode.SimState;
import net.java.dev.joode.World;
import net.java.dev.joode.force.WorldForce;
import net.java.dev.joode.geom.Geom;
import net.java.dev.joode.joint.Joint;
import net.java.dev.joode.space.Space;
import net.java.dev.joode.stepper.StepUtils;
import net.java.dev.joode.stepper.StepperFunction;
import net.java.dev.joode.stepper.lcp.BaraffLCP;
import net.java.dev.joode.util.CompositeVectorRegular;
import net.java.dev.joode.util.IntPointer;
import net.java.dev.joode.util.MathUtils;
import net.java.dev.joode.util.Matrix3;
import net.java.dev.joode.util.RK4;
import net.java.dev.joode.util.Real;
import net.java.dev.joode.util.RealPointer;
import net.java.dev.joode.util.SubVector;
import net.java.dev.joode.util.Vector;
import net.java.dev.joode.util.Vector3;

public class RungeKuttaOrder4Stepper {
    public static final Vector3 avel = new Vector3();
    public static final Vector3 lvel = new Vector3();
    public static final Vector3 taccTmp = new Vector3();
    public static final Vector3 faccTmp = new Vector3();
    public static final Vector3 taccOriginal = new Vector3();
    public static final Vector3 faccOriginal = new Vector3();
    public static final boolean REPORT_ERROR = false;
    private static final RungeKuttaOrder4Stepper INSTANCE;
    private static float accuracy;
    public static final Joint.Info2 Jinfo;
    public static final ConstraintForce constraintCalculator;

    static {
        accuracy = Float.NaN;
        Jinfo = new Joint.Info2();
        constraintCalculator = new ConstraintForce(null);
        INSTANCE = new RungeKuttaOrder4Stepper();
        RungeKuttaOrder4Stepper.Jinfo.J1l = RealPointer.pool.aquire(null);
        RungeKuttaOrder4Stepper.Jinfo.J1a = RealPointer.pool.aquire(null);
        RungeKuttaOrder4Stepper.Jinfo.J2l = RealPointer.pool.aquire(null);
        RungeKuttaOrder4Stepper.Jinfo.J2a = RealPointer.pool.aquire(null);
        RungeKuttaOrder4Stepper.Jinfo.c = RealPointer.pool.aquire(null);
        RungeKuttaOrder4Stepper.Jinfo.cfm = RealPointer.pool.aquire(null);
        RungeKuttaOrder4Stepper.Jinfo.lo = RealPointer.pool.aquire(null);
        RungeKuttaOrder4Stepper.Jinfo.hi = RealPointer.pool.aquire(null);
        RungeKuttaOrder4Stepper.Jinfo.findex = new IntPointer(null);
    }

    private RungeKuttaOrder4Stepper() {
    }

    public static final RungeKuttaOrder4Stepper getInstance() {
        return INSTANCE;
    }

    public static final void setAccuracy(float accuracy) {
        RungeKuttaOrder4Stepper.accuracy = accuracy;
    }

    public static final float getAccuracy() {
        return accuracy;
    }

    public void step(final World world, float t_start, float t_end) {
        world.addForce(constraintCalculator);
        constraintCalculator.setWorld(world);
        RungeKuttaOrder4Stepper.constraintCalculator.stepsize = t_end - t_start;
        CompositeVectorRegular worldState = new CompositeVectorRegular();
        CompositeVectorRegular.CompositeDifferential worldDifferential = new CompositeVectorRegular.CompositeDifferential(){
            SubVector stateWindow = new SubVector();

            public void evaluate(Vector state, float t, float t_start, float t_end, Vector passback) {
                this.stateWindow.base = state;
                Iterator<WorldForce> it = world.getForces();
                while (it.hasNext()) {
                    it.next().prepare(t);
                }
                int i = 0;
                while (i < this.getNumDifferentials()) {
                    this.stateWindow.start = i * this.size() / this.getNumDifferentials();
                    this.stateWindow.end = (i + 1) * this.size() / this.getNumDifferentials();
                    ((Body.BodyDifferential)this.getDifferential(i)).updateBody(this.stateWindow, t);
                    ++i;
                }
                super.evaluate(state, t, t_start, t_end, passback);
            }
        };
        Body b = world.getFirstBody();
        while (b != null) {
            worldState.addVector(b.getState());
            Body.BodyDifferential dt = new Body.BodyDifferential(b);
            dt.setBodyVariables = false;
            worldDifferential.addComponent(dt);
            b = b.getNext();
        }
        if (accuracy > 0.0f) {
            RK4.intergrateAapative(worldState, worldDifferential, t_start, t_end, accuracy, worldState);
        } else {
            RK4.intergrate(worldState, worldDifferential, t_start, t_end, worldState);
        }
        world.removeForce(constraintCalculator);
        b = world.getFirstBody();
        while (b != null) {
            b.recalc();
            b = b.getNext();
        }
        Body body = world.getFirstBody();
        while (body != null) {
            body.resetForces();
            int numGeoms = body.getNumGeoms();
            int g = 0;
            while (g < numGeoms) {
                Geom geom = body.getGeom(g);
                Space.onGeomMoved(geom);
                ++g;
            }
            body = body.getNext();
        }
    }

    private static void calculateConstraintForces(float erp, Body[] bodies, int nb, Joint[] joints, int nj, float jointStep, float t, RealPointer forcePassback) {
        int n6 = 6 * nb;
        assert (forcePassback.data.size() == n6);
        float fps = 1.0f / (jointStep * 2.0f);
        int i = 0;
        while (i < nb) {
            bodies[i].setTag(i);
            ++i;
        }
        int m = 0;
        Joint.Info1[] info = new Joint.Info1[nj];
        int[] ofs = new int[nj];
        int count = 0;
        int j = 0;
        while (j < nj) {
            info[count] = new Joint.Info1();
            joints[j].getInfo1(info[count]);
            if (info[count].m > 0) {
                joints[count] = joints[j];
                ++count;
            }
            ++j;
        }
        nj = count;
        int i2 = 0;
        while (i2 < nj) {
            if (info[i2].nub == info[i2].m) {
                ofs[i2] = m;
                m += info[i2].m;
            }
            ++i2;
        }
        int nub = m;
        int i3 = 0;
        while (i3 < nj) {
            if (info[i3].nub > 0 && info[i3].nub < info[i3].m) {
                ofs[i3] = m;
                m += info[i3].m;
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < nj) {
            if (info[i3].nub == 0) {
                ofs[i3] = m;
                m += info[i3].m;
            }
            ++i3;
        }
        if (m > 0) {
            Real f_t_acc_original = Real.pool.aquire(n6);
            int i4 = 0;
            while (i4 < nb) {
                int j2 = 0;
                while (j2 < 3) {
                    f_t_acc_original.m[i4 * 6 + j2] = bodies[i4].getFACC().m[j2];
                    f_t_acc_original.m[i4 * 6 + j2 + 3] = bodies[i4].getTACC().m[j2];
                    ++j2;
                }
                bodies[i4].getTotalForces(t, faccTmp, taccTmp);
                bodies[i4].getTACC().set(taccTmp);
                bodies[i4].getFACC().set(faccTmp);
                ++i4;
            }
            RealPointer I = RealPointer.pool.aquire(Real.pool.aquire(3 * nb * 4));
            RealPointer invI = RealPointer.pool.aquire(Real.pool.aquire(3 * nb * 4));
            int i5 = 0;
            while (i5 < nb) {
                Matrix3 tmp = Matrix3.pool.aquire();
                bodies[i5].getMass().getMomentOfInertia().mulTranspose(bodies[i5].getRotation(), tmp);
                MathUtils.dMULTIPLY0_333(I.add(i5 * 12, RealPointer.tmp), (Real)bodies[i5].getRotation(), tmp);
                bodies[i5].getMass().invI.mulTranspose(bodies[i5].getRotation(), tmp);
                MathUtils.dMULTIPLY0_333(invI.add(i5 * 12, RealPointer.tmp), (Real)bodies[i5].getRotation(), tmp);
                bodies[i5].getAngularVel(avel);
                MathUtils.dMULTIPLY0_331((Real)tmp, I.add(i5 * 12, RealPointer.tmp), (Real)avel);
                MathUtils.dCROSS_MINUSEQUAL(bodies[i5].getTACC(), avel, tmp);
                Matrix3.pool.release(tmp);
                ++i5;
            }
            RealPointer invM = RealPointer.pool.aquire(Real.pool.aquire(n6 * n6));
            int i6 = 0;
            while (i6 < nb) {
                RealPointer MM = RealPointer.pool.aquire(invM, i6 * 6 * n6 + i6 * 6);
                MM.setValue(0, bodies[i6].getMass().getInverseMass());
                MM.setValue(n6 + 1, bodies[i6].getMass().getInverseMass());
                MM.setValue(2 * n6 + 2, bodies[i6].getMass().getInverseMass());
                MM = MM.add(3 * n6 + 3, MM);
                int j3 = 0;
                while (j3 < 3) {
                    int k = 0;
                    while (k < 3) {
                        MM.setValue(j3 * n6 + k, invI.data.m[i6 * 12 + j3 * 4 + k]);
                        ++k;
                    }
                    ++j3;
                }
                RealPointer.pool.release(MM);
                ++i6;
            }
            RealPointer fe = RealPointer.pool.aquire(Real.pool.aquire(n6));
            RealPointer v = RealPointer.pool.aquire(Real.pool.aquire(n6));
            int i7 = 0;
            while (i7 < nb) {
                bodies[i7].getLinearVel(lvel);
                bodies[i7].getAngularVel(avel);
                int j4 = 0;
                while (j4 < 3) {
                    fe.data.m[i7 * 6 + j4] = bodies[i7].getFACC().m[j4];
                    ++j4;
                }
                j4 = 0;
                while (j4 < 3) {
                    fe.data.m[i7 * 6 + 3 + j4] = bodies[i7].getTACC().m[j4];
                    ++j4;
                }
                j4 = 0;
                while (j4 < 3) {
                    v.data.m[i7 * 6 + j4] = RungeKuttaOrder4Stepper.lvel.m[j4];
                    ++j4;
                }
                j4 = 0;
                while (j4 < 3) {
                    v.data.m[i7 * 6 + 3 + j4] = RungeKuttaOrder4Stepper.avel.m[j4];
                    ++j4;
                }
                ++i7;
            }
            RealPointer c = RealPointer.pool.aquire(Real.pool.aquire(m));
            RealPointer cfm = RealPointer.pool.aquire(Real.pool.aquire(m));
            RealPointer lo = RealPointer.pool.aquire(Real.pool.aquire(m));
            RealPointer hi = RealPointer.pool.aquire(Real.pool.aquire(m));
            IntPointer findex = new IntPointer(new int[m]);
            lo.getData().fill(Float.NEGATIVE_INFINITY);
            hi.getData().fill(Float.POSITIVE_INFINITY);
            int i8 = 0;
            while (i8 < m) {
                findex.data[i8] = -1;
                ++i8;
            }
            RealPointer J = RealPointer.pool.aquire(Real.pool.aquire(m * n6));
            RungeKuttaOrder4Stepper.Jinfo.rowskip = n6;
            RungeKuttaOrder4Stepper.Jinfo.fps = 1.0f / jointStep;
            RungeKuttaOrder4Stepper.Jinfo.erp = erp;
            int i9 = 0;
            while (i9 < nj) {
                RungeKuttaOrder4Stepper.Jinfo.J1l = J.add(n6 * ofs[i9] + 6 * joints[i9].getBody(0).getTag(), RungeKuttaOrder4Stepper.Jinfo.J1l);
                RungeKuttaOrder4Stepper.Jinfo.J1a = RungeKuttaOrder4Stepper.Jinfo.J1l.add(3, RungeKuttaOrder4Stepper.Jinfo.J1a);
                if (joints[i9].getBody(1) != null) {
                    RungeKuttaOrder4Stepper.Jinfo.J2l = J.add(n6 * ofs[i9] + 6 * joints[i9].getBody(1).getTag(), RungeKuttaOrder4Stepper.Jinfo.J2l);
                    RungeKuttaOrder4Stepper.Jinfo.J2a = RungeKuttaOrder4Stepper.Jinfo.J2l.add(3, RungeKuttaOrder4Stepper.Jinfo.J2a);
                } else {
                    RungeKuttaOrder4Stepper.Jinfo.J2l.data = null;
                    RungeKuttaOrder4Stepper.Jinfo.J2a.data = null;
                }
                RungeKuttaOrder4Stepper.Jinfo.c = c.add(ofs[i9], RungeKuttaOrder4Stepper.Jinfo.c);
                RungeKuttaOrder4Stepper.Jinfo.cfm = cfm.add(ofs[i9], RungeKuttaOrder4Stepper.Jinfo.cfm);
                RungeKuttaOrder4Stepper.Jinfo.lo = lo.add(ofs[i9], RungeKuttaOrder4Stepper.Jinfo.lo);
                RungeKuttaOrder4Stepper.Jinfo.hi = hi.add(ofs[i9], RungeKuttaOrder4Stepper.Jinfo.hi);
                RungeKuttaOrder4Stepper.Jinfo.t = t;
                RungeKuttaOrder4Stepper.Jinfo.findex = findex.add(ofs[i9], RungeKuttaOrder4Stepper.Jinfo.findex);
                joints[i9].getInfo2(Jinfo);
                int j5 = 0;
                while (j5 < info[i9].m) {
                    if (findex.getValue(ofs[i9] + j5) >= 0) {
                        findex.setValue(ofs[i9] + j5, findex.getValue(ofs[i9] + j5) + ofs[i9]);
                    }
                    ++j5;
                }
                ++i9;
            }
            RealPointer JinvM = RealPointer.pool.aquire(Real.pool.aquire(m * n6));
            MathUtils.dMultiply0(JinvM, J, invM, m, n6, n6);
            RealPointer A = RealPointer.pool.aquire(Real.pool.aquire(m * m));
            MathUtils.dMultiply2(A, JinvM, J, m, n6, m);
            int i10 = 0;
            while (i10 < m) {
                A.setValue(i10 * m + i10, A.getValue(i10 * m + i10) + cfm.getValue(i10) * fps);
                ++i10;
            }
            MathUtils.dMultiply0(forcePassback, invM, fe, n6, n6, 1);
            i10 = 0;
            while (i10 < n6) {
                forcePassback.setValue(i10, forcePassback.getValue(i10) + v.getValue(i10) * fps);
                ++i10;
            }
            RealPointer rhs = RealPointer.pool.aquire(Real.pool.aquire(m));
            MathUtils.dMultiply0(rhs, J, forcePassback, m, n6, 1);
            int i11 = 0;
            while (i11 < m) {
                rhs.setValue(i11, c.getValue(i11) * fps - rhs.getValue(i11));
                ++i11;
            }
            RealPointer lambda = RealPointer.pool.aquire(Real.pool.aquire(m));
            RealPointer residual = RealPointer.pool.aquire(Real.pool.aquire(m));
            BaraffLCP.INSTANCE.computeForces(m, A, lambda, rhs, residual, nub, lo, hi, findex);
            MathUtils.dMultiply1(forcePassback, J, lambda, n6, m, 1);
            Real.pool.release(c.data);
            Real.pool.release(cfm.data);
            Real.pool.release(lo.data);
            Real.pool.release(hi.data);
            Real.pool.release(J.data);
            Real.pool.release(A.data);
            Real.pool.release(rhs.data);
            Real.pool.release(residual.data);
            Real.pool.release(JinvM.data);
            RealPointer.pool.release(c);
            RealPointer.pool.release(cfm);
            RealPointer.pool.release(lo);
            RealPointer.pool.release(hi);
            RealPointer.pool.release(J);
            RealPointer.pool.release(A);
            RealPointer.pool.release(rhs);
            RealPointer.pool.release(residual);
            RealPointer.pool.release(JinvM);
            Real.pool.release(I.data);
            Real.pool.release(invI.data);
            Real.pool.release(invM.data);
            Real.pool.release(fe.data);
            Real.pool.release(v.data);
            RealPointer.pool.release(I);
            RealPointer.pool.release(invI);
            RealPointer.pool.release(invM);
            RealPointer.pool.release(fe);
            RealPointer.pool.release(v);
            int i12 = 0;
            while (i12 < nb) {
                int j6 = 0;
                while (j6 < 3) {
                    bodies[i12].getFACC().m[j6] = f_t_acc_original.m[i12 * 6 + j6];
                    bodies[i12].getTACC().m[j6] = f_t_acc_original.m[i12 * 6 + j6 + 3];
                    ++j6;
                }
                ++i12;
            }
            Real.pool.release(f_t_acc_original);
        }
    }

    private static class ConstraintForce
    extends WorldForce
    implements StepperFunction {
        private static final long serialVersionUID = 1L;
        HashMap<Body, Vector3> forces = new HashMap();
        HashMap<Body, Vector3> torques = new HashMap();
        float t;
        float stepsize;

        public ConstraintForce(World world) {
            super(world);
        }

        public void prepare(float t) {
            this.calculate(t);
        }

        private void calculate(float t) {
            this.t = t;
            for (Vector3 vector3 : this.forces.values()) {
                Vector3.pool.release(vector3);
            }
            for (Vector3 vector3 : this.torques.values()) {
                Vector3.pool.release(vector3);
            }
            this.torques.clear();
            this.forces.clear();
            World worldTmp = this.getWorld();
            this.getWorld().removeForce(this);
            this.setWorld(worldTmp);
            StepUtils.dxProcessIslands(this.getWorld(), t, t + this.stepsize, this);
            this.getWorld().addForce(this);
        }

        public void step(World world, Body[] bodies, int bcount, Joint[] joints, int jcount, float t_start, float t_end) {
            RealPointer force_vector = RealPointer.pool.aquire(Real.pool.aquire(bcount * 6));
            RungeKuttaOrder4Stepper.calculateConstraintForces(world.getGlobalERP(), bodies, bcount, joints, jcount, this.stepsize, this.t, force_vector);
            int i = 0;
            while (i < bcount) {
                Body b = bodies[i];
                Vector3 force = Vector3.pool.aquire();
                Vector3 torque = Vector3.pool.aquire();
                int j = 0;
                while (j < 3) {
                    force.m[j] = force_vector.data.m[i * 6 + j];
                    torque.m[j] = force_vector.data.m[i * 6 + j + 3];
                    ++j;
                }
                this.forces.put(b, force);
                this.torques.put(b, torque);
                ++i;
            }
            Real.pool.release(force_vector.data);
            RealPointer.pool.release(force_vector);
        }

        public void applyForce(Body body, float t, Vector3 faccPassback, Vector3 taccPassback) {
            Vector3 torque = this.torques.get(body);
            Vector3 force = this.forces.get(body);
            assert (this.t == t) : "time mismatch, calculate has not been called correctly";
            assert (torque != null) : "torque not calculated for body, calculate should have been called allready";
            assert (force != null) : "force not calculated for body, calculate should have been called allready";
            faccPassback.add(force);
            taccPassback.add(torque);
        }

        public SimState cloneState(ClonedReferences util) {
            return this;
        }
    }
}

