/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.stepper;

import net.java.dev.joode.Body;
import net.java.dev.joode.World;
import net.java.dev.joode.util.CompositeVectorRegular;
import net.java.dev.joode.util.RK4;

public class SimpleStepper {
    public static final SimpleStepper INSTANCE = new SimpleStepper();

    private SimpleStepper() {
    }

    public void step(World world, float t_start, float t_end) {
        CompositeVectorRegular worldState = new CompositeVectorRegular();
        CompositeVectorRegular.CompositeDifferential worldDifferentiator = new CompositeVectorRegular.CompositeDifferential();
        Body body = world.getFirstBody();
        while (body != null) {
            worldState.addVector(body.getState());
            worldDifferentiator.addComponent(body.getDifferential());
            body = body.getNext();
        }
        RK4.intergrate(worldState, worldDifferentiator, t_start, t_end, worldState);
        body = world.getFirstBody();
        while (body != null) {
            body.resetForces();
            body.recalc();
            body = body.getNext();
        }
    }
}

