/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.util;

import java.util.Arrays;
import net.java.dev.joode.util.Vector3;

public class AABB3f
implements Cloneable {
    public static final int AABB_MIN_X = 0;
    public static final int AABB_MAX_X = 1;
    public static final int AABB_MIN_Y = 2;
    public static final int AABB_MAX_Y = 3;
    public static final int AABB_MIN_Z = 4;
    public static final int AABB_MAX_Z = 5;
    private final float[] values = new float[6];

    public AABB3f() {
        this.empty();
    }

    public AABB3f(AABB3f aabb) {
        this.set(aabb);
    }

    public AABB3f(float minX, float maxX, float minY, float maxY, float minZ, float maxZ) {
        this.set(minX, maxX, minY, maxY, minZ, maxZ);
    }

    public final float[] getValues() {
        return this.values;
    }

    public final void getValues(float[] values) {
        System.arraycopy(this.values, 0, values, 0, this.values.length);
    }

    public final void setMinX(float minX) {
        this.values[0] = minX;
    }

    public final float getMinX() {
        return this.values[0];
    }

    public final void setMaxX(float maxX) {
        this.values[1] = maxX;
    }

    public final float getMaxX() {
        return this.values[1];
    }

    public final void setMinY(float minY) {
        this.values[2] = minY;
    }

    public final float getMinY() {
        return this.values[2];
    }

    public final void setMaxY(float maxY) {
        this.values[3] = maxY;
    }

    public final float getMaxY() {
        return this.values[3];
    }

    public final void setMinZ(float minZ) {
        this.values[4] = minZ;
    }

    public final float getMinZ() {
        return this.values[4];
    }

    public final void setMaxZ(float maxZ) {
        this.values[5] = maxZ;
    }

    public final float getMaxZ() {
        return this.values[5];
    }

    public final void prepare() {
        this.values[0] = Float.POSITIVE_INFINITY;
        this.values[2] = Float.POSITIVE_INFINITY;
        this.values[4] = Float.POSITIVE_INFINITY;
        this.values[1] = Float.NEGATIVE_INFINITY;
        this.values[3] = Float.NEGATIVE_INFINITY;
        this.values[5] = Float.NEGATIVE_INFINITY;
    }

    public final void setInfinity() {
        this.values[0] = Float.NEGATIVE_INFINITY;
        this.values[2] = Float.NEGATIVE_INFINITY;
        this.values[4] = Float.NEGATIVE_INFINITY;
        this.values[1] = Float.POSITIVE_INFINITY;
        this.values[3] = Float.POSITIVE_INFINITY;
        this.values[5] = Float.POSITIVE_INFINITY;
    }

    public final void empty() {
        this.values[0] = Float.MAX_VALUE;
        this.values[2] = Float.MAX_VALUE;
        this.values[4] = Float.MAX_VALUE;
        this.values[1] = Float.MAX_VALUE;
        this.values[3] = Float.MAX_VALUE;
        this.values[5] = Float.MAX_VALUE;
    }

    public final void setZero() {
        Arrays.fill(this.values, 0.0f);
    }

    public final boolean isEmpty() {
        return this.values[0] > this.values[1] || this.values[2] > this.values[3] || this.values[4] > this.values[5];
    }

    public final AABB3f intersection(AABB3f box2, AABB3f result) {
        result.set(Math.max(this.getMinX(), box2.getMinX()), Math.min(this.getMaxX(), box2.getMaxX()), Math.max(this.getMinY(), box2.getMinY()), Math.min(this.getMaxY(), box2.getMaxY()), Math.max(this.getMinZ(), box2.getMinZ()), Math.min(this.getMaxZ(), box2.getMaxZ()));
        return result;
    }

    public final boolean intersects(AABB3f box2) {
        return this.getMinX() <= box2.getMaxX() && this.getMaxX() >= box2.getMinX() && this.getMinY() <= box2.getMaxY() && this.getMaxY() >= box2.getMinY() && this.getMinZ() <= box2.getMaxZ() && this.getMaxZ() >= box2.getMinZ();
    }

    public final void merge(AABB3f box2) {
        if (box2.getMinX() < this.getMinX()) {
            this.setMinX(box2.getMinX());
        }
        if (box2.getMaxX() > this.getMaxX()) {
            this.setMaxX(box2.getMaxX());
        }
        if (box2.getMinY() < this.getMinY()) {
            this.setMinY(box2.getMinY());
        }
        if (box2.getMaxY() > this.getMaxY()) {
            this.setMaxY(box2.getMaxY());
        }
        if (box2.getMinZ() < this.getMinZ()) {
            this.setMinZ(box2.getMinZ());
        }
        if (box2.getMaxZ() > this.getMaxZ()) {
            this.setMaxZ(box2.getMaxZ());
        }
    }

    public final void set(float minX, float maxX, float minY, float maxY, float minZ, float maxZ) {
        this.setMinX(minX);
        this.setMaxX(maxX);
        this.setMinY(minY);
        this.setMaxY(maxY);
        this.setMinZ(minZ);
        this.setMaxZ(maxZ);
    }

    public final void set(AABB3f src) {
        System.arraycopy(src.values, 0, this.values, 0, this.values.length);
    }

    public final void set(float[] aabb) {
        if (aabb != this.values) {
            System.arraycopy(aabb, 0, this.values, 0, this.values.length);
        }
    }

    public final void compute(Vector3 p0, Vector3 p1, Vector3 p2) {
        this.setMinX(Math.min(p0.getX(), Math.min(p1.getX(), p2.getX())));
        this.setMaxX(Math.max(p0.getX(), Math.max(p1.getX(), p2.getX())));
        this.setMinY(Math.min(p0.getY(), Math.min(p1.getY(), p2.getY())));
        this.setMaxY(Math.max(p0.getY(), Math.max(p1.getY(), p2.getY())));
        this.setMinZ(Math.min(p0.getZ(), Math.min(p1.getZ(), p2.getZ())));
        this.setMaxZ(Math.max(p0.getZ(), Math.max(p1.getZ(), p2.getZ())));
    }

    public AABB3f clone() {
        return new AABB3f(this);
    }
}

