/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.util;

import net.java.dev.joode.util.Matrix;
import net.java.dev.joode.util.Pool;
import net.java.dev.joode.util.Quaternion;

public class Matrix3
extends Matrix {
    public static final Pool<Matrix3> pool = new Pool<Matrix3>(){

        @Override
        protected Matrix3 constuct() {
            return new Matrix3();
        }

        @Override
        protected void reset(Matrix3 object) {
            object.setZero();
        }
    };

    public Matrix3() {
        super(4, 4);
    }

    public Matrix3(Matrix3 template) {
        this();
        this.set(template);
    }

    public void setIdentity() {
        this.setZero();
        int i = 0;
        while (i < 3) {
            this.set(i, i, 1.0f);
            ++i;
        }
    }

    public static boolean epsilonEquals(Matrix3 a, Matrix3 b, float e) {
        int i = 0;
        while (i < a.m.length) {
            if (!Matrix3.epsilonEquals(a.m[i], b.m[i], e)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void setRotationZ(Matrix3 passback, float theta) {
        float cosTheta = (float)Math.cos(theta);
        float sinTheta = (float)Math.sin(theta);
        passback.setZero();
        passback.set(0, 0, cosTheta);
        passback.set(0, 1, sinTheta);
        passback.set(1, 0, -sinTheta);
        passback.set(1, 1, cosTheta);
        passback.set(2, 2, 1.0f);
    }

    public static void setRotationX(Matrix3 passback, float theta) {
        float cosTheta = (float)Math.cos(theta);
        float sinTheta = (float)Math.sin(theta);
        passback.setZero();
        passback.set(0, 0, 1.0f);
        passback.set(1, 1, cosTheta);
        passback.set(1, 2, sinTheta);
        passback.set(2, 1, -sinTheta);
        passback.set(2, 2, cosTheta);
    }

    public static void setRotationY(Matrix3 passback, float theta) {
        float cosTheta = (float)Math.cos(theta);
        float sinTheta = (float)Math.sin(theta);
        passback.setZero();
        passback.set(1, 1, 1.0f);
        passback.set(0, 0, cosTheta);
        passback.set(2, 2, cosTheta);
        passback.set(0, 2, sinTheta);
        passback.set(2, 0, -sinTheta);
    }

    public void set(Matrix3 mat) {
        System.arraycopy(mat.m, 0, this.m, 0, Math.min(this.m.length, mat.m.length));
    }

    public void set(Quaternion quat) {
        float qq1 = 2.0f * quat.m[1] * quat.m[1];
        float qq2 = 2.0f * quat.m[2] * quat.m[2];
        float qq3 = 2.0f * quat.m[3] * quat.m[3];
        this.m[0] = 1.0f - qq2 - qq3;
        this.m[1] = 2.0f * (quat.m[1] * quat.m[2] - quat.m[0] * quat.m[3]);
        this.m[2] = 2.0f * (quat.m[1] * quat.m[3] + quat.m[0] * quat.m[2]);
        this.m[4] = 2.0f * (quat.m[1] * quat.m[2] + quat.m[0] * quat.m[3]);
        this.m[5] = 1.0f - qq1 - qq3;
        this.m[6] = 2.0f * (quat.m[2] * quat.m[3] - quat.m[0] * quat.m[1]);
        this.m[8] = 2.0f * (quat.m[1] * quat.m[3] - quat.m[0] * quat.m[2]);
        this.m[9] = 2.0f * (quat.m[2] * quat.m[3] + quat.m[0] * quat.m[1]);
        this.m[10] = 1.0f - qq1 - qq2;
    }

    public static Matrix3 setRandomRotationMatrix(Matrix3 passback) {
        Quaternion tmpQ = Quaternion.pool.aquire();
        tmpQ.set((float)Math.random(), (float)Math.random(), (float)Math.random(), (float)Math.random());
        tmpQ.normalize();
        tmpQ.toMatrix(passback);
        Quaternion.pool.release(tmpQ);
        return passback;
    }

    public void transpose() {
        int i = 0;
        while (i < 3) {
            int j = i - 1;
            while (j >= 0) {
                float tmp = this.get(i, j);
                this.set(i, j, this.get(j, i));
                this.set(j, i, tmp);
                --j;
            }
            ++i;
        }
    }
}

