/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.util;

import java.util.HashMap;
import net.java.dev.joode.util.Pool1D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Pool2D<T> {
    private final HashMap<Integer, Pool1D<T>> pools = new HashMap();

    public final T aquire(final int i, final int j) {
        Pool1D pool = this.pools.get(i);
        if (pool == null) {
            pool = new Pool1D<T>(){

                @Override
                protected T construct(int index) {
                    return Pool2D.this.constuct(i, j);
                }

                @Override
                protected int getIndex(T object) {
                    return Pool2D.this.getSecondIndex(object);
                }

                @Override
                protected void reset(T object) {
                    Pool2D.this.reset(object);
                }
            };
            this.pools.put(i, pool);
        }
        return pool.aquire(j);
    }

    public final void release(T object) {
        Pool1D<T> pool = this.pools.get(this.getFirstIndex(object));
        assert (pool != null) : "object was not aquired";
        pool.release(object);
    }

    protected abstract T constuct(int var1, int var2);

    protected abstract int getFirstIndex(T var1);

    protected abstract int getSecondIndex(T var1);

    protected abstract void reset(T var1);

    public int size() {
        int size = 0;
        for (Pool1D<T> pool : this.pools.values()) {
            size += pool.size();
        }
        return size;
    }
}

