/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.util;

import net.java.dev.joode.util.Pool;
import net.java.dev.joode.util.Real;

public class RealPointer {
    public static final RealPointerPool pool = new RealPointerPool();
    public static RealPointer tmp = new RealPointer(null);
    public Real data;
    public int index;

    @Deprecated
    public RealPointer(Real data) {
        this.data = data;
    }

    @Deprecated
    public RealPointer(Real data, int index) {
        this.data = data;
        this.index = index;
    }

    @Deprecated
    public RealPointer(RealPointer base, int add) {
        this(base.data);
        this.index = base.index + add;
    }

    public Real getData() {
        return this.data;
    }

    public void setData(Real data) {
        this.data = data;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public float getValue() {
        return this.data.m[this.index];
    }

    public float getValue(int offset) {
        return this.data.m[this.index + offset];
    }

    public void setValue(float val) {
        this.data.m[this.index] = val;
    }

    public void setValue(int offset, float val) {
        this.data.m[this.index + offset] = val;
    }

    @Deprecated
    public RealPointer add(int n) {
        return new RealPointer(this, n);
    }

    public RealPointer add(int n, RealPointer result) {
        result.data = this.data;
        result.index = this.index + n;
        return result;
    }

    public void setZero(int n) {
        int i = this.index;
        while (i < this.index + n) {
            this.data.m[i] = 0.0f;
            ++i;
        }
    }

    public void copy(RealPointer b, int n) {
        int i = 0;
        while (i < n) {
            this.data.m[this.index + i] = b.data.m[b.index + i];
            ++i;
        }
    }

    public Object clone() {
        return new RealPointer(this.data, this.index);
    }

    public String toString() {
        return new StringBuffer("index = ").append(this.index).append(" of [").append(this.data).append("]").toString();
    }

    public RealPointer set(RealPointer a) {
        this.data = a.data;
        this.index = a.index;
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RealPointerPool
    extends Pool<RealPointer> {
        public RealPointer aquire(RealPointer base, int add) {
            RealPointer result = (RealPointer)this.aquire();
            result.data = base.data;
            result.index = base.index + add;
            return result;
        }

        public RealPointer aquire(Real real) {
            RealPointer result = (RealPointer)this.aquire();
            result.data = real;
            return result;
        }

        @Override
        protected RealPointer constuct() {
            return new RealPointer(null);
        }

        @Override
        protected void reset(RealPointer object) {
            object.data = null;
            object.index = 0;
        }
    }
}

