/*
 * Decompiled with CFR 0.152.
 */
package org.em3d.core;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.em3d.core.CuesObject;
import org.em3d.core.MemoryObject;
import org.em3d.core.Scene;
import org.em3d.phases.Break;
import org.em3d.phases.Collisions;
import org.em3d.phases.FreeRecallOrder;
import org.em3d.phases.FreeRecallPositions;
import org.em3d.phases.Move;
import org.em3d.phases.Phase;
import org.em3d.phases.PhaseTypes;
import org.em3d.phases.RecallWithHint;
import org.em3d.phases.RecognitionOfOrder;
import org.em3d.phases.RecognitionOfPositions;
import org.em3d.phases.ShowIntro;
import org.em3d.phases.ShowResults;
import org.em3d.phases.WorldInterface;
import org.em3d.results.Results;
import org.em3d.xml.Util;
import org.em3d.xml.XML;
import org.em3d.xml.XMLNode;

public class ScriptManager {
    private String name;
    private int type;
    List<Phase> timeline = new LinkedList<Phase>();
    Iterator<Phase> phaseIterator;
    Phase currentPhase;
    Scene scene;
    Results results;
    public static final int SCRIPT_CUES = 0;
    public static final int SCRIPT_MEMORY = 1;

    public ScriptManager(WorldInterface worldIface, String script) {
        XML source = new XML("scripts/" + script);
        this.name = source.get("script.name", "unknown");
        this.scene = new Scene(source.get("script.scene", "default.xml"));
        this.type = source.get("script.type", "memory").equals("memory") ? 1 : 0;
        this.results = new Results(this.type, worldIface.getLanguage());
        XML objectSource = new XML("scripts/objects/" + source.get("script.objects.source", "basic.xml"));
        for (XMLNode n : source.getAll("script.objects.object")) {
            System.out.println(n.get("sourceName", "undefined"));
            XMLNode object = objectSource.getAll("objects." + n.get("sourceName", "undefined")).get(0);
            if (this.type == 1) {
                MemoryObject mo = new MemoryObject(n.get("name", "noname"), "models/" + object.get("model", "default.obj"), Float.valueOf(n.get("scale", object.get("scale", "0.5"))).floatValue(), (float)((double)Float.valueOf(n.get("rotationx", object.get("rotationx", "0"))).floatValue() * Math.PI / 180.0), (float)((double)Float.valueOf(n.get("rotationy", object.get("rotationy", "0"))).floatValue() * Math.PI / 180.0), (float)((double)Float.valueOf(n.get("rotationz", object.get("rotationz", "0"))).floatValue() * Math.PI / 180.0), "textures/" + n.get("texture", object.get("texture", "white.jpg")), Util.getColorFromString(n.get("color", object.get("color", "WHITE"))));
                mo.setLocation(n.get("location", "default"));
                this.scene.addObject(mo);
                continue;
            }
            CuesObject go = new CuesObject(n.get("name", "noname"), Boolean.valueOf(n.get("moving", "true")), Float.valueOf(n.get("speed", "0")).floatValue(), "models/" + object.get("model", "default.obj"), Float.valueOf(n.get("scale", object.get("scale", "1"))).floatValue(), (float)((double)Float.valueOf(n.get("rotationx", object.get("rotationx", "0"))).floatValue() * Math.PI / 180.0), (float)((double)Float.valueOf(n.get("rotationy", object.get("rotationy", "0"))).floatValue() * Math.PI / 180.0), (float)((double)Float.valueOf(n.get("rotationz", object.get("rotationz", "0"))).floatValue() * Math.PI / 180.0), "textures/" + n.get("texture", object.get("texture", "white.jpg")), Util.getColorFromString(n.get("color", object.get("color", "WHITE"))));
            for (XMLNode l : n.getAll("location")) {
                go.addLocation(l.get("name", "default"));
                System.out.println(go.getName() + ": " + l.get("name", "default"));
            }
            this.scene.addObject(go);
        }
        this.scene.refreshNumberOfObjects();
        for (XMLNode n : source.getAll("script.timeline.phase")) {
            switch (PhaseTypes.valueOf(n.get("type", "UNDEFINED"))) {
                case INTRO: {
                    this.timeline.add(new ShowIntro(worldIface, this.scene, n.get("gui", "intro.xml"), 0, n.getText("text." + worldIface.getLanguage(), "No intro")));
                    break;
                }
                case MOVE: {
                    this.timeline.add(new Move(worldIface, this.scene, n.get("playerLocation", "default"), n.get("playerFacing", "default"), n.get("gui", "move.xml"), 0, Boolean.valueOf(n.get("table", "true"))));
                    break;
                }
                case BREAK: {
                    this.timeline.add(new Break(worldIface, this.scene, n.get("gui", "break.xml"), 0, Integer.valueOf(n.get("time", "5"))));
                    break;
                }
                case FREE_RECALL_ORDER: {
                    this.timeline.add(new FreeRecallOrder(worldIface, this.scene, n.get("playerLocation", "default"), n.get("playerFacing", "default"), n.get("gui", "free_recall_order.xml"), 2));
                    break;
                }
                case FREE_RECALL_POSITIONS: {
                    this.timeline.add(new FreeRecallPositions(worldIface, this.scene, n.get("playerLocation", "default"), n.get("playerFacing", "default"), n.get("gui", "free_recall_positions.xml"), 0));
                    break;
                }
                case RECALL_WITH_HINT: {
                    this.timeline.add(new RecallWithHint(worldIface, this.scene, n.get("playerLocation", "default"), n.get("playerFacing", "default"), n.get("gui", "recall_with_hint.xml"), 0));
                    break;
                }
                case RECOGNITION_OF_ORDER: {
                    this.timeline.add(new RecognitionOfOrder(worldIface, this.scene, n.get("playerLocation", "default"), n.get("playerFacing", "default"), n.get("gui", "recognition_of_order.xml"), 2, Integer.valueOf(n.get("configurations", "5"))));
                    break;
                }
                case RECOGNITION_OF_POSITIONS: {
                    this.timeline.add(new RecognitionOfPositions(worldIface, this.scene, n.get("playerLocation", "default"), n.get("playerFacing", "default"), n.get("gui", "recognition_of_positions.xml"), 2, Integer.valueOf(n.get("configurations", "5"))));
                    break;
                }
                case COLLISIONS: {
                    this.timeline.add(new Collisions(worldIface, this.scene, n.get("playerLocation", "default"), n.get("playerFacing", "default"), n.get("gui", "collisions.xml"), Boolean.parseBoolean(n.get("playerMovement", "true")) ? 1 : 2, Integer.valueOf(n.get("maxTime", "-1")), Integer.valueOf(n.get("maxCollisions", Integer.toString(Integer.MAX_VALUE))), Boolean.parseBoolean(n.get("cueInterposition", "true")), Boolean.parseBoolean(n.get("cueProjection", "true")), Boolean.parseBoolean(n.get("cueShading", "true")), Boolean.parseBoolean(n.get("cueShadows", "true")), Boolean.parseBoolean(n.get("cueFog", "false"))));
                    break;
                }
                case DISTANCE: {
                    break;
                }
                case RESULTS: {
                    this.timeline.add(new ShowResults(worldIface, this.scene, n.get("gui", "results.xml"), 0));
                }
            }
        }
        this.phaseIterator = this.timeline.listIterator();
        this.currentPhase = this.phaseIterator.next();
    }

    public Scene getScene() {
        return this.scene;
    }

    public Phase getCurrentPhase() {
        return this.currentPhase;
    }

    public void initializeFirstPhase() {
        this.currentPhase.initialize(this.results.newPhase(PhaseTypes.assignType(this.currentPhase)));
    }

    public void update(long gameTime) {
        this.currentPhase.update(gameTime);
        if (this.currentPhase.isFinished() && this.phaseIterator.hasNext()) {
            this.currentPhase = this.phaseIterator.next();
            this.currentPhase.initialize(this.results.newPhase(PhaseTypes.assignType(this.currentPhase)));
        }
    }
}

