/*
 * Decompiled with CFR 0.152.
 */
package org.em3d.phases;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.em3d.core.LocationTypes;
import org.em3d.core.Scene;
import org.em3d.phases.Phase;
import org.em3d.phases.WorldInterface;
import org.em3d.results.Results;

public class RecognitionOfPositions
extends Phase {
    int nofConf;
    List<String[]> configurations;
    String[] current;
    ListIterator<String[]> confIt;
    Map<String, String> currentObjectLocation;

    public RecognitionOfPositions(WorldInterface worldIface, Scene scene, String playerStartPosition, String playerFacingLocation, String gui, int freedom, int numberOfConfigurations) {
        super(worldIface, scene, playerStartPosition, playerFacingLocation, gui, freedom);
        this.nofConf = numberOfConfigurations;
        this.configurations = new LinkedList<String[]>();
        this.currentObjectLocation = new HashMap<String, String>();
    }

    public void initialize(Results results) {
        super.initialize(results);
        this.scene.resetObjectIterator();
        String[] locations = new String[this.scene.getObjectNames().length];
        int k = 0;
        while (this.scene.hasNextObject()) {
            locations[k] = this.scene.getNextObject().getFirstLocationName();
            ++k;
        }
        results.setCorrectLocations(locations);
        results.setCorrectOrder(this.scene.getObjectNames());
        String[] correct = this.scene.getLocationNames(LocationTypes.SOCKET);
        boolean addedCorrect = false;
        for (int i = 0; i < this.nofConf - 1; ++i) {
            if (Math.random() > 0.5) {
                this.configurations.add(this.shuffleArray(correct));
                continue;
            }
            if (addedCorrect) {
                this.configurations.add(this.shuffleArray(correct));
            } else {
                this.configurations.add(correct);
            }
            addedCorrect = true;
        }
        if (addedCorrect) {
            this.configurations.add(this.shuffleArray(correct));
        } else {
            this.configurations.add(correct);
        }
        this.confIt = this.configurations.listIterator();
        this.current = this.confIt.next();
        this.showConfiguration(this.current);
    }

    public void showConfiguration(String[] config) {
        int i = 0;
        this.scene.resetObjectIterator();
        while (this.scene.hasNextObject()) {
            String name = this.scene.getNextObject().getName();
            this.world.showObject(name, config[i]);
            this.currentObjectLocation.put(name, config[i]);
            ++i;
        }
    }

    public void userFinish() {
        String[] objects = this.scene.getObjectNames();
        for (int i = 0; i < objects.length; ++i) {
            objects[i] = this.currentObjectLocation.get(objects[i]);
        }
        this.results.setUserLocations(objects);
        this.finished = true;
    }

    public void userNextConfiguration() {
        if (this.confIt.hasNext()) {
            this.current = this.confIt.next();
        } else {
            this.confIt = this.configurations.listIterator();
            this.current = this.confIt.next();
        }
        this.showConfiguration(this.current);
    }

    public void userPreviousConfiguration() {
        if (this.confIt.hasPrevious()) {
            this.current = this.confIt.previous();
        } else {
            this.confIt = this.configurations.listIterator(this.configurations.size());
            this.current = this.confIt.previous();
        }
        this.showConfiguration(this.current);
    }
}

