/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.launcher;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.em3d.xml.XML;
import org.em3d.xml.XMLNode;
import org.xith3d.launcher.Xith3DTest;
import org.xith3d.main.Main;
import org.xith3d.render.config.DisplayMode;
import org.xith3d.render.config.FSAA;
import org.xith3d.render.config.OpenGLLayer;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.launching.DisplayOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Xith3DTestLauncher
extends DisplayOptions
implements TreeSelectionListener,
Xith3DTest.FinishListener {
    private static final long serialVersionUID = 703711773159507726L;
    private static final String[] TEST_PACKAGES_TITLES = new String[]{"em3d", "3dcues"};
    private static final String[] TEST_PACKAGES_PREFIXES = new String[]{"epizodic_memory", "cues"};
    Thread testThread;
    protected boolean currentMouseYInv;
    private JCheckBox mouseYInvCheck;
    private JComboBox languageSelector;
    private JTabbedPane testTab;
    private JTree[] testTrees;
    private JTextComponent descriptionPane;
    private String currentTest;
    private String language;
    private JCheckBox returnSelector;
    private JPanel advancedOptions;
    private boolean returnSelectorState;
    private Map<TreeNode, String> treeNodes2TestClassMap;
    private Map<String, DefaultMutableTreeNode> testClasses2treeNodesMap;
    private Map<DefaultMutableTreeNode, Integer> treeNodes2TreeIndexMap;
    private Map<String, String> testClassesDescriptions;
    private Map<String, String> testClassesAuthors;
    private XML GUIxml;
    private JPanel settingsPanel;
    private JCheckBox advanced;
    private JComponent comp;
    private JComponent buttonsPanel;
    private boolean languageSelectorLoaded = false;
    private boolean testRunning = false;
    private boolean success = false;

    @Override
    protected File getPropertiesFileFolder() {
        return super.getPropertiesFileFolder();
    }

    @Override
    protected String getPropertiesFilename() {
        return "testlauncher_selection.properties";
    }

    @Override
    protected String getPropertiesComment() {
        return "Last selected items in the Xith3DTestLauncher";
    }

    @Override
    protected void restoreSelections(Properties props) throws Throwable {
        super.restoreSelections(props);
        System.out.println("restore selections");
        this.GUIxml = new XML("scripts/GUI/launcher.xml");
        this.updateGUILanguage(props.getProperty("testlauncher.language", "en"));
        this.setCurrentMouseYInverted(Boolean.valueOf(props.getProperty("testlauncher.mouseYInverted", "true")));
        this.setCurrentTest(props.getProperty("testlauncher.selectedTest", null));
        this.setReturnSelectorState(Boolean.parseBoolean(props.getProperty("testlauncher.returnBit", "false")));
    }

    protected void updateGUILanguage(String lang) {
        System.out.println("update language: " + lang);
        this.language = lang;
        this.settingsPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
        this.settingsPanel.setBorder(BorderFactory.createTitledBorder(this.GUIxml.getText("launcher.settings.label." + lang, "???")));
        if (!this.languageSelectorLoaded) {
            System.out.println("add items: " + this.languageSelectorLoaded);
            this.languageSelectorLoaded = true;
            Iterator<XMLNode> lit = this.GUIxml.getAll("launcher.language").iterator();
            while (lit.hasNext()) {
                String tag = lit.next().get("tag", "???");
                this.languageSelector.addItem(tag);
                System.out.println("add item: ");
            }
        }
        this.setLanguageSelectorState(this.language);
        this.languageSelector.setActionCommand("SET_LANGUAGE");
        this.advanced.setText(this.GUIxml.getText("launcher.settings.advanced." + lang, "???"));
        Xith3DTestLauncher.TEST_PACKAGES_TITLES[0] = this.GUIxml.getText("launcher.selector.em3d." + lang, "???");
        Xith3DTestLauncher.TEST_PACKAGES_TITLES[1] = this.GUIxml.getText("launcher.selector.cues." + lang, "???");
        Container p = this.comp.getParent();
        p.remove(this.comp);
        this.comp = this.createCenterComponent();
        p.add(this.comp);
        this.displayDescription();
        this.returnSelector.setText(this.GUIxml.getText("launcher.other.return." + lang, "???"));
        ((JButton)this.buttonsPanel.getComponent(0)).setText(this.GUIxml.getText("launcher.other.start." + lang, "???"));
        ((JButton)this.buttonsPanel.getComponent(1)).setText(this.GUIxml.getText("launcher.other.close." + lang, "???"));
    }

    @Override
    protected Properties createProperties() {
        Properties props = super.createProperties();
        props.setProperty("testlauncher.mouseYInverted", String.valueOf(this.getCurrentMouseYInverted()));
        props.setProperty("testlauncher.selectedTest", String.valueOf(this.getCurrentTest()));
        props.setProperty("testlauncher.returnBit", String.valueOf(this.returnSelectorState));
        props.setProperty("testlauncher.language", String.valueOf(this.languageSelector.getSelectedItem()));
        System.out.println("Selected language: " + this.languageSelector.getSelectedItem());
        return props;
    }

    @Override
    public void onTestFinished() {
        this.testRunning = false;
        this.setVisible(true);
    }

    @Override
    protected boolean onStartButtonClicked() {
        this.success = false;
        this.testRunning = true;
        this.testThread = new Thread("Xith3DTestLauncher Thread"){

            public void run() {
                System.out.println(Xith3DTestLauncher.this.language);
                Xith3DTestLauncher.this.success = Xith3DTestLauncher.runTest(Xith3DTestLauncher.this.getCurrentTest(), Xith3DTestLauncher.this.language, Xith3DTestLauncher.this.getCurrentOGLLayer(), Xith3DTestLauncher.this.getCurrentDisplayMode(), Xith3DTestLauncher.this.getCurrentFullscreenMode(), Xith3DTestLauncher.this.getCurrentVSync(), Xith3DTestLauncher.this.getCurrentFSAA(), Xith3DTestLauncher.this.getCurrentMouseYInverted(), Xith3DTestLauncher.this.getReturnSelectorState() ? Xith3DTestLauncher.this : null);
            }
        };
        this.testThread.start();
        return this.success;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getActionCommand().equals("RETURN_SELECTOR")) {
            this.returnSelectorState = ((JCheckBox)e.getSource()).isSelected();
        } else if (e.getActionCommand().startsWith("MOUSE_Y_INV::")) {
            this.currentMouseYInv = ((JCheckBox)e.getSource()).isSelected();
        } else if (e.getActionCommand().equals("VIEW_ADVANCED")) {
            this.advancedOptions.setVisible(!this.advancedOptions.isVisible());
        } else if (e.getActionCommand().equals("SET_LANGUAGE")) {
            System.out.println("command: SET_LANGUAGE");
            this.updateGUILanguage(this.languageSelector.getSelectedItem().toString());
        }
    }

    public void setCurrentMouseYInverted(boolean inv) {
        this.mouseYInvCheck.setSelected(inv);
        this.currentMouseYInv = inv;
    }

    public boolean getCurrentMouseYInverted() {
        return this.currentMouseYInv;
    }

    public void setCurrentTest(String testName) {
        if (testName == null) {
            throw new IllegalArgumentException("testName MUST NOT be null");
        }
        DefaultMutableTreeNode node = this.testClasses2treeNodesMap.get(testName);
        if (node == null) {
            throw new IllegalArgumentException("A test class with this name does not exist");
        }
        TreePath path = new TreePath(node.getPath());
        Integer treeIndex = this.treeNodes2TreeIndexMap.get(node);
        JTree testTree = this.testTrees[treeIndex];
        testTree.setSelectionPath(path);
        testTree.scrollPathToVisible(path);
        this.testTab.setSelectedIndex(treeIndex);
        this.currentTest = testName;
    }

    public String getCurrentTest() {
        return this.currentTest;
    }

    public void setReturnSelectorState(boolean state) {
        this.returnSelectorState = state;
        this.returnSelector.setSelected(state);
    }

    public void setLanguageSelectorState(String state) {
        this.language = state;
        this.languageSelector.setSelectedItem(state);
    }

    public boolean getReturnSelectorState() {
        return this.returnSelectorState;
    }

    private void displayDescription() {
        String desc = this.testClassesDescriptions.get(this.currentTest);
        String authors = this.testClassesAuthors.get(this.currentTest);
        if (desc != null || authors != null) {
            StringBuffer html = new StringBuffer("<font face=\"Verdana\" size=\"12px\">\n");
            html.append(desc);
            html.append('\n');
            html.append("<br>\n\n");
            html.append("</font>");
            this.descriptionPane.setText(html.toString());
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        TreePath path = e.getNewLeadSelectionPath();
        if (path != null) {
            TreeNode node = (TreeNode)path.getPathComponent(path.getPathCount() - 1);
            this.currentTest = this.treeNodes2TestClassMap.get(node);
            this.displayDescription();
        } else {
            this.currentTest = null;
        }
        this.setStartButtonEnabled(this.currentTest != null);
    }

    private void buildTree(String pkgName, Integer pkgIndex, Map<String, Object> treeMap, DefaultMutableTreeNode rootNode) {
        ArrayList<DefaultMutableTreeNode> nodes = new ArrayList<DefaultMutableTreeNode>();
        for (String s : treeMap.keySet()) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(s);
            nodes.add(node);
            Object o = treeMap.get(s);
            if (o instanceof Map) {
                this.buildTree(pkgName, pkgIndex, (Map)o, node);
                continue;
            }
            this.treeNodes2TestClassMap.put(node, (String)o);
            this.testClasses2treeNodesMap.put((String)o, node);
            this.treeNodes2TreeIndexMap.put(node, pkgIndex);
        }
        Collections.sort(nodes, new NodeComparater());
        for (DefaultMutableTreeNode n : nodes) {
            rootNode.add(n);
        }
    }

    private Map<String, Map<String, Object>> buildHashTree(String root) {
        HashMap<String, Map<String, Object>> map0 = new HashMap<String, Map<String, Object>>();
        for (String pkgName : TEST_PACKAGES_PREFIXES) {
            map0.put(pkgName, new HashMap());
        }
        for (String pkgName : TEST_PACKAGES_PREFIXES) {
            File file = new File(root + pkgName);
            System.out.println(file.getName());
            File[] list = file.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(".xml");
                }
            });
            Map map = (Map)map0.get(pkgName);
            for (File f : list) {
                XML script = new XML(root + pkgName + "/" + f.getName());
                map.put(script.getText("script.description.name." + this.language, f.getName()), pkgName + "/" + f.getName());
                this.testClassesDescriptions.put(pkgName + "/" + f.getName(), script.getText("script.description." + this.language, "no description"));
                this.testClassesAuthors.put(pkgName + "/" + f.getName(), script.getText("script.description.authors", "unknown"));
            }
        }
        return map0;
    }

    private Map<String, Map<String, Object>> initTestSelectors() {
        this.testClassesDescriptions = new HashMap<String, String>();
        this.testClassesAuthors = new HashMap<String, String>();
        this.treeNodes2TestClassMap = new Hashtable<TreeNode, String>();
        this.testClasses2treeNodesMap = new Hashtable<String, DefaultMutableTreeNode>();
        this.treeNodes2TreeIndexMap = new Hashtable<DefaultMutableTreeNode, Integer>();
        return this.buildHashTree("scripts/");
    }

    private JScrollPane createTestSelector(String pkgName, Integer pkgIndex, Map<String, Object> treeMap) {
        String title = "title";
        if (this.GUIxml != null) {
            title = this.GUIxml.getText("launcher.selector.scripts." + this.language, "???");
        }
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(title);
        this.buildTree(pkgName, pkgIndex, treeMap, rootNode);
        final JTree testTree = new JTree(rootNode);
        testTree.setBorder(new EmptyBorder(3, 3, 3, 3));
        testTree.getSelectionModel().setSelectionMode(1);
        testTree.setRootVisible(true);
        testTree.addTreeSelectionListener(this);
        testTree.setExpandsSelectedPaths(true);
        JScrollPane scroller = new JScrollPane(testTree);
        scroller.setBorder(new BevelBorder(1));
        testTree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                TreePath path;
                if (e.getClickCount() == 2 && (path = testTree.getLeadSelectionPath()) != null) {
                    TreeNode node = (TreeNode)path.getPathComponent(path.getPathCount() - 1);
                    String currentTest = (String)Xith3DTestLauncher.this.treeNodes2TestClassMap.get(node);
                    if (currentTest != null) {
                        Xith3DTestLauncher.this.requestStart();
                    }
                }
            }
        });
        return scroller;
    }

    private JTabbedPane createTestSelectors() {
        JTabbedPane tab = new JTabbedPane(1, 0);
        Map<String, Map<String, Object>> treeMaps = this.initTestSelectors();
        this.testTrees = new JTree[TEST_PACKAGES_PREFIXES.length];
        for (int i = 0; i < TEST_PACKAGES_PREFIXES.length; ++i) {
            String pkgTitle = TEST_PACKAGES_TITLES[i];
            String pkgName = TEST_PACKAGES_PREFIXES[i];
            Map<String, Object> treeMap = treeMaps.get(pkgName);
            tab.addTab(pkgTitle, this.createTestSelector(pkgName, i, treeMap));
        }
        this.testTab = tab;
        return tab;
    }

    @Override
    protected JComponent createCenterComponent() {
        this.comp = this.createTestSelectors();
        this.comp.setMinimumSize(new Dimension(300, 350));
        this.comp.setPreferredSize(new Dimension(300, 350));
        this.comp.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        return this.comp;
    }

    @Override
    protected JComponent createSouthComponent() {
        JEditorPane descPane = new JEditorPane("text/html", "");
        descPane.setCursor(new Cursor(2));
        descPane.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.descriptionPane = descPane;
        descPane.setEditable(false);
        JScrollPane scroller = new JScrollPane(descPane);
        scroller.setBorder(new BevelBorder(1));
        scroller.setMinimumSize(new Dimension(1, 100));
        scroller.setPreferredSize(new Dimension(Integer.MAX_VALUE, 100));
        scroller.setMaximumSize(new Dimension(Integer.MAX_VALUE, 100));
        return scroller;
    }

    protected JComponent createMouseYInvertedSelector() {
        JPanel panel = new JPanel(new GridLayout(1, 1));
        panel.setMinimumSize(new Dimension(1, 20));
        panel.setPreferredSize(new Dimension(1, 20));
        panel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.mouseYInvCheck = new JCheckBox("Mouse-Y inverted", this.currentMouseYInv);
        this.mouseYInvCheck.setActionCommand("MOUSE_Y_INV::");
        this.mouseYInvCheck.addActionListener(this);
        panel.add(this.mouseYInvCheck);
        return panel;
    }

    @Override
    protected JComponent createNorthWestComponent() {
        System.out.println("create component, language: " + this.language);
        this.advancedOptions = (JPanel)super.createNorthWestComponent();
        this.advancedOptions.add(Box.createVerticalStrut(5));
        this.advancedOptions.add(this.createMouseYInvertedSelector());
        this.advancedOptions.setVisible(false);
        this.settingsPanel = new JPanel();
        this.settingsPanel.setLayout(new BoxLayout(this.settingsPanel, 1));
        this.settingsPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
        this.settingsPanel.setBorder(BorderFactory.createTitledBorder("Nastaveni"));
        this.languageSelector = new JComboBox();
        this.languageSelector.addActionListener(this);
        this.languageSelector.setBounds(0, 0, 20, 25);
        this.settingsPanel.add(this.languageSelector);
        this.advanced = new JCheckBox("Pokrocile nastaveni");
        this.advanced.setSelected(false);
        this.advanced.setActionCommand("VIEW_ADVANCED");
        this.advanced.addActionListener(this);
        this.settingsPanel.add(this.advanced);
        this.settingsPanel.add(this.advancedOptions);
        return this.settingsPanel;
    }

    @Override
    protected JComponent createNorthComponent() {
        final ImageIcon icon = new ImageIcon(this.getClass().getClassLoader().getResource("resources/org/xith3d/pictures/TestLauncher.png"));
        JComponent image = new JComponent(){
            private static final long serialVersionUID = 1L;

            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(icon.getImage(), 0, 0, this.getWidth(), this.getHeight(), this);
            }
        };
        image.setMinimumSize(new Dimension(0, 120));
        image.setPreferredSize(new Dimension(Integer.MAX_VALUE, 120));
        image.setMaximumSize(new Dimension(Integer.MAX_VALUE, 120));
        return image;
    }

    @Override
    protected JComponent createFooterComponent() {
        this.buttonsPanel = super.createFooterComponent();
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.add((Component)this.buttonsPanel, "Center");
        this.returnSelector = new JCheckBox("Return to Launcher after Test finished");
        this.returnSelectorState = true;
        this.returnSelector.setSelected(this.returnSelectorState);
        this.returnSelector.setActionCommand("RETURN_SELECTOR");
        this.returnSelector.addActionListener(this);
        wrapper.add((Component)this.returnSelector, "West");
        wrapper.setMinimumSize(this.buttonsPanel.getMinimumSize());
        wrapper.setPreferredSize(this.buttonsPanel.getPreferredSize());
        wrapper.setMaximumSize(this.buttonsPanel.getMaximumSize());
        return wrapper;
    }

    @Override
    protected Dimension buildGUI() {
        Dimension size = super.buildGUI();
        this.setStartButtonEnabled(false);
        return size;
    }

    protected Xith3DTestLauncher() {
        super("Epizodic Memory and Cues 3D Launcher", Xith3DTest.DEFAULT_OGL_LAYER, Xith3DTest.DEFAULT_DISPLAY_MODE, DisplayMode.FullscreenMode.WINDOWED, FSAA.OFF);
    }

    public static final boolean runTest(String testName, String lang, OpenGLLayer layer, DisplayMode displayMode, DisplayMode.FullscreenMode fullscreen, boolean vsync, FSAA fsaa, boolean mouseYInverted, Xith3DTest.FinishListener finishListener) {
        System.out.println("STARTING TEST: " + testName);
        try {
            Main test = new Main(testName, lang, new BasicApplicationArguments(layer, displayMode, fullscreen, vsync, fsaa, mouseYInverted), finishListener);
            test.begin(finishListener);
        }
        catch (Throwable ex) {
            Logger.getLogger(Xith3DTestLauncher.class.getName()).log(Level.SEVERE, null, ex);
        }
        return true;
    }

    public static final boolean runTest(String testName, String lang) {
        return Xith3DTestLauncher.runTest(testName, lang, OpenGLLayer.getDefault(), Xith3DTest.DEFAULT_DISPLAY_MODE, Xith3DTest.DEFAULT_FULLSCREEN, Xith3DTest.DEFAULT_VSYNC, FSAA.OFF, true, null);
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0) {
            boolean succ = Xith3DTestLauncher.runTest("org.xith3d.test." + args[0], "en");
            if (!succ) {
                System.err.println("ERROR starting the desired test.");
                System.exit(1);
            } else {
                System.exit(0);
            }
        } else {
            new Xith3DTestLauncher();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NodeComparater
    implements Comparator<DefaultMutableTreeNode> {
        private NodeComparater() {
        }

        @Override
        public int compare(DefaultMutableTreeNode n1, DefaultMutableTreeNode n2) {
            return ((String)n1.getUserObject()).compareTo((String)n2.getUserObject());
        }
    }
}

