/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.loaders.util;

import java.util.Iterator;
import java.util.List;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.loop.opscheduler.Animatable;
import org.xith3d.scenegraph.AmbientLight;
import org.xith3d.scenegraph.Group;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.schedops.movement.TransformationDirectives;
import org.xith3d.schedops.movement.TranslatableGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranslatingModel
extends TranslatableGroup
implements Animatable {
    int counter = 0;
    int time = 0;
    float speed = 0.0f;
    float precision = 0.25f;
    List<Tuple3f> locations;
    Iterator<Tuple3f> locationIterator;
    Tuple3f lastVisited;
    Tuple3f target;

    @Override
    public boolean animate(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        if (super.animate(gameTime, frameTime, timingMode)) {
            if (this.hasReachedTarget()) {
                if (this.locationIterator.hasNext()) {
                    this.target = this.locationIterator.next();
                } else {
                    this.locationIterator = this.locations.listIterator();
                    this.target = this.locationIterator.next();
                }
                this.changeDirectives(this.getDirectives(this.lastVisited, this.target, this.speed), gameTime, frameTime, timingMode);
                this.lastVisited = this.target;
                this.time = 0;
            }
            return true;
        }
        return false;
    }

    public boolean hasReachedTarget() {
        Transform3D objectTransform = this.getChild(0).getTransformGroup().getWorldTransform();
        Vector3f pos = objectTransform.getTranslation();
        return this.target.epsilonEquals(pos, this.precision);
    }

    public void changeDirectives(TransformationDirectives newDirecs, long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        Transform3D t = new Transform3D();
        t = this.getChild(0).getTransformGroup().getWorldTransform();
        t = new Transform3D(t.getTranslation());
        ((TransformGroup)this.getParent()).setTransform(t);
        super.setTransformationDirectives(newDirecs);
        super.animate(gameTime, frameTime, timingMode);
    }

    public TransformationDirectives getDirectives(Tuple3f location1, Tuple3f location2, float speed) {
        Vector3f direction = new Vector3f((Tuple3f)location2.clone().sub(location1.clone()));
        direction.normalize();
        return new TransformationDirectives(direction, speed);
    }

    public TranslatingModel(Group modelGroup, float scale, float speed, float precision, List<Tuple3f> listOfLocations) {
        this(modelGroup, scale);
        TransformationDirectives transDirecs;
        this.speed = speed;
        this.precision = precision;
        this.locations = listOfLocations;
        this.locationIterator = this.locations.listIterator();
        if (this.locations.size() < 2) {
            transDirecs = new TransformationDirectives(new Vector3f(0.0f, 0.0f, 0.0f), 0.0f);
            this.lastVisited = null;
        } else {
            Tuple3f from = this.locationIterator.next();
            Tuple3f to = this.locationIterator.next();
            transDirecs = this.getDirectives(from, to, speed);
            this.lastVisited = to;
            this.target = to;
        }
        super.setTransformationDirectives(transDirecs);
    }

    private TranslatingModel(Group modelGroup, float scale, TransformationDirectives transDirecs) {
        super(transDirecs);
        this.addChild(new AmbientLight(true, Colorf.GRAY50));
        this.addChild(modelGroup);
        this.setScale(scale);
    }

    private TranslatingModel(Group modelGroup, float scale) {
        this(modelGroup, scale, new TransformationDirectives(new Vector3f(0.0f, 0.0f, 0.0f), 0.0f));
    }
}

