/*
 * Decompiled with CFR 0.152.
 */
package org.em3d.gui;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.em3d.gui.GUICommands;
import org.em3d.gui.TimeBar;
import org.em3d.phases.Phase;
import org.em3d.phases.WorldInterface;
import org.em3d.results.Results;
import org.em3d.xml.Util;
import org.em3d.xml.XML;
import org.em3d.xml.XMLNode;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.KeyID;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Tuple2f;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.base.AbstractButton;
import org.xith3d.ui.hud.base.WidgetContainer;
import org.xith3d.ui.hud.listeners.ButtonListener;
import org.xith3d.ui.hud.utils.HUDFont;
import org.xith3d.ui.hud.widgets.Button;
import org.xith3d.ui.hud.widgets.Dialog;
import org.xith3d.ui.hud.widgets.Label;
import org.xith3d.ui.hud.widgets.Panel;
import org.xith3d.ui.hud.widgets.ScrollPanel;
import org.xith3d.ui.hud.widgets.TextField;
import org.xith3d.ui.text2d.TextAlignment;

public class GUI {
    Phase phase;
    WorldInterface world;
    List<GUIButton> buttons;
    List<GUILabel> labels;
    List<GUIBinding> bindings;
    boolean showModel = true;
    boolean renderBackground = true;
    boolean suspendFirstPerson = false;
    String standardCursor;
    String highlightCursor;
    String exitText;
    String timeText;
    String timePrefix;
    String timeSuffix;
    String saveText;
    String pauseText;
    String continueText;

    public GUI(WorldInterface world, Phase phase, String definition) {
        this.world = world;
        this.phase = phase;
        this.buttons = new LinkedList<GUIButton>();
        this.labels = new LinkedList<GUILabel>();
        this.bindings = new LinkedList<GUIBinding>();
        String language = world.getLanguage();
        XML source = new XML("scripts/GUI/" + definition);
        if (source.getAll("gui.items.label") != null) {
            for (XMLNode n : source.getAll("gui.items.label")) {
                this.labels.add(new GUILabel(TextAlignment.valueOf(n.get("alignment", "TOP_LEFT")), Integer.parseInt(n.get("offsetx", "0")), Integer.parseInt(n.get("offsety", "0")), Integer.parseInt(n.get("width", "100")), Integer.parseInt(n.get("height", "100")), n.getText(language, "no_text"), Util.getColorFromString(n.get("color", "WHITE")), Integer.parseInt(n.get("fontSize", "10"))));
            }
        }
        if (source.getAll("gui.items.button") != null) {
            for (XMLNode n : source.getAll("gui.items.button")) {
                this.buttons.add(new GUIButton(TextAlignment.valueOf(n.get("alignment", "TOP_LEFT")), Integer.parseInt(n.get("offsetx", "0")), Integer.parseInt(n.get("offsety", "0")), Integer.parseInt(n.get("width", "100")), Integer.parseInt(n.get("height", "100")), n.getText(language, "no_text"), GUICommands.valueOf(n.get("command", "NONE"))));
            }
        }
        if (source.getAll("gui.bindings.bind") != null) {
            for (XMLNode n : source.getAll("gui.bindings.bind")) {
                this.bindings.add(new GUIBinding(n.get("key", "K"), GUICommands.valueOf(n.get("command", "NONE"))));
            }
        }
        this.showModel = Boolean.parseBoolean(source.get("gui.showModel", "true"));
        this.renderBackground = Boolean.parseBoolean(source.get("gui.renderBackground", "true"));
        this.suspendFirstPerson = Boolean.parseBoolean(source.get("gui.suspendFirstPerson", "false"));
        this.standardCursor = source.get("gui.standardCursor", "hand.png");
        this.highlightCursor = source.get("gui.focusCursor", "hand.png");
        this.exitText = source.getText("gui.texts.exit." + language, "exit text");
        this.timeText = source.getText("gui.texts.time." + language, "time text");
        this.timePrefix = source.getText("gui.texts.time.prefix." + language, "");
        this.timeSuffix = source.getText("gui.texts.time.suffix." + language, "");
        this.saveText = source.getText("gui.texts.save." + language, "save text");
        this.pauseText = source.getText("gui.texts.pause." + language, "pause");
        this.continueText = source.getText("gui.texts.continue." + language, "continue");
    }

    public void createHUD() {
        HUD hud = this.world.getHUD();
        hud.getContentPane().clear();
        for (GUILabel l : this.labels) {
            Tuple2f t = this.getPosition(l.posX, l.posY, hud.getResX(), hud.getResY(), l.align);
            hud.getContentPane().addWidget(l.getLabel(), t.getX(), t.getY());
        }
        for (GUIButton b : this.buttons) {
            Tuple2f t = this.getPosition(b.posX, b.posY, hud.getResX(), hud.getResY(), b.align);
            hud.getContentPane().addWidget(b.getButton(), t.getX(), t.getY());
        }
        hud.setCrosshair(this.standardCursor);
    }

    public boolean showModel() {
        return this.showModel;
    }

    public boolean renderBackground() {
        return this.renderBackground;
    }

    public boolean suspendFirstPerson() {
        return this.suspendFirstPerson;
    }

    public void showTimeDialog(int time) {
        TimeDialog dialog = new TimeDialog(400.0f, 100.0f, time);
        this.world.getHUD().addWindowCentered(dialog);
    }

    public void showFocus(boolean show) {
        if (show) {
            this.world.getHUD().setCrosshair(this.highlightCursor);
        } else {
            this.world.getHUD().setCrosshair(this.standardCursor);
        }
    }

    public void showResults(Results res) {
        ResultsDialog dialog = new ResultsDialog(400.0f, 515.0f, res);
        this.world.getHUD().addWindowCentered(dialog);
        dialog.setText(res.returnResults());
    }

    public void showIntro(String text) {
        IntroDialog dialog = new IntroDialog(400.0f, 315.0f, text);
        this.world.getHUD().addWindowCentered(dialog);
        dialog.setText(text);
    }

    private Tuple2f getPosition(float posX, float posY, float resX, float resY, TextAlignment align) {
        float offsetX = 0.0f;
        float offsetY = 0.0f;
        if (align == TextAlignment.BOTTOM_CENTER) {
            offsetX = resX / 2.0f;
            offsetY = resY;
        }
        if (align == TextAlignment.BOTTOM_LEFT) {
            offsetX = 0.0f;
            offsetY = resY;
        }
        if (align == TextAlignment.BOTTOM_RIGHT) {
            offsetX = resX;
            offsetY = resY;
        }
        if (align == TextAlignment.CENTER_CENTER) {
            offsetX = resX / 2.0f;
            offsetY = resY / 2.0f;
        }
        if (align == TextAlignment.CENTER_LEFT) {
            offsetX = 0.0f;
            offsetY = resY / 2.0f;
        }
        if (align == TextAlignment.CENTER_RIGHT) {
            offsetX = resX;
            offsetY = resY / 2.0f;
        }
        if (align == TextAlignment.TOP_CENTER) {
            offsetX = resX / 2.0f;
            offsetY = 0.0f;
        }
        if (align == TextAlignment.TOP_LEFT) {
            offsetX = 0.0f;
            offsetY = 0.0f;
        }
        if (align == TextAlignment.TOP_RIGHT) {
            offsetX = resX;
            offsetY = 0.0f;
        }
        return new Tuple2f(offsetX + posX, offsetY + posY);
    }

    public void keyPressed(Key key) {
        if (this.world.debug()) {
            System.out.println((Object)key.getKeyID());
        }
        Iterator<GUIBinding> bit = this.bindings.iterator();
        while (bit.hasNext()) {
            bit.next().hit(key);
        }
    }

    public void doCommand(GUICommands command) {
        switch (command) {
            case END_PHASE: {
                this.phase.userFinish();
                break;
            }
            case NEXT_CONFIGURATION: {
                this.phase.userNextConfiguration();
                break;
            }
            case PREVIOUS_CONFIGURATION: {
                this.phase.userPreviousConfiguration();
                break;
            }
            case COLLISION: {
                this.phase.userCollision();
                break;
            }
            case EXIT_PROGRAM: {
                ExitDialog dialog = new ExitDialog(300.0f, 100.0f);
                this.world.getHUD().addWindowCentered(dialog);
                break;
            }
            case CUE_INTERPOSITION: {
                this.world.switchInterposition();
                break;
            }
            case CUE_PROJECTION: {
                this.world.switchProjection();
                break;
            }
            case CUE_SHADING: {
                this.world.switchShading();
                break;
            }
            case CUE_SHADOWS: {
                this.world.switchShadows();
                break;
            }
            case CUE_FOG: {
                this.world.switchFog();
            }
        }
    }

    private class IntroDialog
    extends Dialog
    implements Runnable,
    ButtonListener {
        TextField text;
        Button ok;

        public void run() {
        }

        public void onButtonClicked(AbstractButton button, Object userObject) {
            if (button.getUserObject().equals("OK")) {
                GUI.this.phase.userFinish();
                this.detach();
            }
        }

        protected void init() {
            super.init();
            this.text = new TextField(400.0f, 270.0f);
            this.text.setAlignment(TextAlignment.TOP_LEFT);
            this.text.setEditable(false);
            this.getContentPane().addWidget(this.text, 1.0f, 1.0f);
            this.ok = new Button(96.0f, 28.0f, "OK");
            this.ok.setUserObject("OK");
            this.ok.addButtonListener(this);
            this.getContentPane().addWidget(this.ok, 290.0f, 280.0f);
            new Thread(this).start();
        }

        public void setText(String textToSet) {
            this.text.setText(textToSet);
        }

        public IntroDialog(float width, float height, String text) {
            super((WidgetContainer)new Panel(width, height, Colorf.parseColor("#EEEEEE")), " ");
        }
    }

    private class ResultsDialog
    extends Dialog
    implements Runnable,
    ButtonListener {
        TextField text;
        TextField filetext;
        Button save;
        Button ok;
        ScrollPanel scroll;
        Results res;

        public void run() {
        }

        public void onButtonClicked(AbstractButton button, Object userObject) {
            if (button.getUserObject().equals("OK")) {
                GUI.this.world.userExit();
            }
            if (button.getUserObject().equals("SAVE")) {
                String filename = "results/" + this.filetext.getText() + ".csv";
                System.out.println("save results: " + filename);
                this.res.saveResults(filename);
            }
        }

        protected void init() {
            super.init();
            this.scroll = new ScrollPanel(400.0f, 470.0f);
            this.text = new TextField(380.0f, 5000.0f);
            this.text.setAlignment(TextAlignment.TOP_LEFT);
            this.text.setEditable(false);
            this.scroll.addWidget(this.text, 1.0f, 1.0f);
            this.getContentPane().addWidget(this.scroll, 1.0f, 1.0f);
            this.save = new Button(100.0f, 25.0f, GUI.this.saveText);
            this.save.setUserObject("SAVE");
            this.save.addButtonListener(this);
            this.getContentPane().addWidget(this.save, 10.0f, 480.0f);
            this.ok = new Button(96.0f, 28.0f, "OK");
            this.ok.setUserObject("OK");
            this.ok.addButtonListener(this);
            this.getContentPane().addWidget(this.ok, 290.0f, 480.0f);
            this.filetext = new TextField(150.0f, 25.0f);
            this.filetext.setText("results");
            this.filetext.setEditable(true);
            this.getContentPane().addWidget(this.filetext, 120.0f, 480.0f);
            new Thread(this).start();
        }

        public void setText(String textToSet) {
            this.text.setText(textToSet);
        }

        public ResultsDialog(float width, float height, Results res) {
            super((WidgetContainer)new Panel(width, height, Colorf.parseColor("#EEEEEE")), " ");
            this.res = res;
        }
    }

    private class TimeDialog
    extends Dialog
    implements Runnable {
        private TimeBar tb;
        private int time;

        public void run() {
            GUI.this.world.blockGUI(true);
            while (this.tb.isTimeLeft() && this.getHUD() != null) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.tb.updateTime();
            }
            this.detach();
            GUI.this.phase.countdownFinished();
            GUI.this.world.blockGUI(false);
        }

        protected void init() {
            super.init();
            Label text = new Label(this.getResX(), 50.0f, GUI.this.timeText, TextAlignment.CENTER_CENTER);
            this.getContentPane().addWidget(text, 0.0f, 5.0f);
            this.tb = new TimeBar(this.getResX() * 0.9f, 46.0f, this.time, GUI.this.timePrefix, GUI.this.timeSuffix);
            this.tb.setZIndex(1);
            this.tb.setValue(this.time);
            this.getContentPane().addWidget(this.tb, (this.getResX() - this.tb.getWidth()) / 2.0f, 50.0f);
            new Thread(this).start();
        }

        public TimeDialog(float width, float height, int time) {
            super((WidgetContainer)new Panel(width, height, Colorf.parseColor("#EEEEEE")), " ");
            this.time = 90;
            super.setCloseButtonVisible(false);
            this.time = time;
        }
    }

    private class ExitDialog
    extends Dialog
    implements Runnable,
    ButtonListener {
        private Button yes;
        private Button no;

        public void run() {
        }

        public void onButtonClicked(AbstractButton button, Object userObject) {
            if (button.getUserObject().equals("YES")) {
                GUI.this.world.userExit();
            }
            if (button.getUserObject().equals("NO")) {
                this.detach();
            }
        }

        protected void init() {
            super.init();
            Label text = new Label(this.getResX(), 50.0f, GUI.this.exitText, TextAlignment.CENTER_CENTER);
            this.getContentPane().addWidget(text, 0.0f, 5.0f);
            this.yes = new Button(96.0f, 28.0f, "yes");
            this.yes.setUserObject("YES");
            this.yes.addButtonListener(this);
            this.getContentPane().addWidget(this.yes, (this.getResX() - this.yes.getWidth()) / 4.0f, this.getResY() - 15.0f - this.yes.getHeight());
            this.no = new Button(96.0f, 28.0f, "no");
            this.no.setUserObject("NO");
            this.no.addButtonListener(this);
            this.getContentPane().addWidget(this.no, (this.getResX() - this.no.getWidth()) / 4.0f * 3.0f, this.getResY() - 15.0f - this.no.getHeight());
            new Thread(this).start();
        }

        public ExitDialog(float width, float height) {
            super((WidgetContainer)new Panel(width, height, Colorf.parseColor("#EEEEEE")), " ");
        }
    }

    private class GUILabel {
        public float posX;
        public float posY;
        public float width;
        public float height;
        public String label;
        public TextAlignment align;
        Colorf color;
        int size;

        public GUILabel(TextAlignment align, float posx, float posy, float width, float height, String label, Colorf color, int size) {
            this.align = align;
            this.posX = posx;
            this.posY = posy;
            this.width = width;
            this.height = height;
            this.label = label;
            this.color = color;
            this.size = size;
        }

        public Label getLabel() {
            return new Label(this.width, this.height, this.label, HUDFont.getFont("Verdana", HUDFont.PLAIN, this.size), this.color, this.align);
        }
    }

    private class GUIButton {
        public float posX;
        public float posY;
        public float width;
        public float height;
        public String label;
        public GUICommands command;
        public TextAlignment align;

        public GUIButton(TextAlignment align, float posx, float posy, float width, float height, String label, GUICommands command) {
            this.posX = posx;
            this.posY = posy;
            this.width = width;
            this.height = height;
            this.label = label;
            this.command = command;
            this.align = align;
        }

        public Button getButton() {
            Button hudButton = new Button(this.width, this.height, this.label);
            hudButton.setUserObject((Object)this.command);
            switch (this.command) {
                case PAUSE: {
                    hudButton.setText(GUI.this.pauseText);
                    hudButton.addButtonListener(new ButtonListener(){

                        public void onButtonClicked(AbstractButton button, Object userObject) {
                            boolean paused = GUI.this.world.pauseAnimation();
                            if (paused) {
                                ((Button)button).setText(GUI.this.continueText);
                            } else {
                                ((Button)button).setText(GUI.this.pauseText);
                            }
                        }
                    });
                    break;
                }
                default: {
                    hudButton.addButtonListener(new ButtonListener(){

                        public void onButtonClicked(AbstractButton button, Object userObject) {
                            GUI.this.doCommand((GUICommands)((Object)userObject));
                        }
                    });
                }
            }
            return hudButton;
        }
    }

    private class GUIBinding {
        public String keyID;
        public GUICommands command;

        public GUIBinding(String key, GUICommands command) {
            this.keyID = key;
            this.command = command;
        }

        public void hit(Key key) {
            key.getKeyID();
            if (KeyID.valueOf(this.keyID) == key.getKeyID()) {
                GUI.this.doCommand(this.command);
            }
        }
    }
}

