/*
 * Decompiled with CFR 0.152.
 */
package org.em3d.phases;

import org.em3d.core.AbstractObject;
import org.em3d.core.Scene;
import org.em3d.phases.Phase;
import org.em3d.phases.WorldInterface;
import org.em3d.results.Results;

public class Move
extends Phase {
    String holdingObject;
    boolean putOnTable;

    public Move(WorldInterface worldIface, Scene scene, String playerStartPosition, String playerFacingLocation, String gui, int freedom, boolean table) {
        super(worldIface, scene, playerStartPosition, playerFacingLocation, gui, freedom);
        this.putOnTable = table;
    }

    public void initialize(Results results) {
        super.initialize(results);
        this.scene.resetObjectIterator();
        AbstractObject o = this.scene.getNextObject();
        this.world.showObject(o.getName(), o.getFirstLocationName());
    }

    public void locationSelected(String locationName) {
        if (this.holdingObject != null && this.scene.isLocationTable(locationName)) {
            if (this.putOnTable) {
                this.world.showObject(this.holdingObject, locationName);
                this.world.setObjectPickable(this.holdingObject, false);
            }
            this.world.showObjectInHud("none");
            this.holdingObject = null;
            if (this.scene.hasNextObject()) {
                AbstractObject o = this.scene.getNextObject();
                this.world.showObject(o.getName(), o.getFirstLocationName());
            } else {
                this.finished = true;
            }
        }
    }

    public void objectSelected(String objectName) {
        if (this.holdingObject == null) {
            this.world.hideObject(objectName);
            this.world.showObjectInHud(objectName);
            this.holdingObject = objectName;
        }
    }

    public void mouseOverLocation(String locationName) {
        if (this.holdingObject != null && this.scene.isLocationTable(locationName)) {
            this.gui.showFocus(true);
        }
    }

    public void mouseOverObject(String objectName) {
        if (this.holdingObject == null) {
            this.gui.showFocus(true);
        }
    }

    public void userFinish() {
        this.finished = true;
    }
}

