/*
 * Decompiled with CFR 0.152.
 */
package org.em3d.results;

import java.io.PrintWriter;
import org.em3d.results.PhaseResults;

public class RecallWithHintResults
extends PhaseResults {
    String[] correctOrder;
    String[] userOrder;
    String[] correctLocations;
    String[] userLocations;

    public void setCorrectLocations(String[] locations) {
        this.correctLocations = locations;
    }

    public void setUserLocations(String[] locations) {
        this.userLocations = locations;
    }

    public void setCorrectOrder(String[] objects) {
        this.correctOrder = objects;
    }

    public void setUserOrder(String[] objects) {
        this.userOrder = objects;
    }

    public int find(String what, String[] where) {
        for (int i = 0; i < where.length; ++i) {
            if (!where[i].equals(what)) continue;
            return i;
        }
        return -1;
    }

    public String printResults() {
        int misordered = 0;
        int misplaced = 0;
        String res = "\n--- " + this.text.getText("results.hint.title." + this.lang, "???") + " ----";
        res = res + "\n";
        res = res + "\n " + this.text.getText("results.recall.objects." + this.lang, "???") + ": ";
        for (int i = 0; i < this.correctOrder.length; ++i) {
            int l = this.find(this.userOrder[i], this.correctOrder);
            res = res + "\n  " + (i + 1) + ". " + this.text.getText("results.hint.moved." + this.lang, "???") + "";
            res = res + "\n     " + this.text.getText("results.recall.was." + this.lang, "???") + ": " + this.userOrder[i];
            res = res + "\n     " + this.text.getText("results.hint.shouldbe." + this.lang, "???") + ": " + this.correctOrder[i];
            res = res + "\n     " + this.text.getText("results.recall.placed." + this.lang, "???") + ": " + this.userLocations[l];
            res = res + "\n     " + this.text.getText("results.hint.shouldplace." + this.lang, "???") + ": " + this.correctLocations[l];
            if (this.correctOrder[i].equals(this.userOrder[i])) {
                res = res + "\n     " + this.text.getText("results.hint.correct.order." + this.lang, "???") + ".";
            } else {
                res = res + "\n     " + this.text.getText("results.hint.wrong.order." + this.lang, "???") + ".";
                ++misordered;
            }
            if (this.correctLocations[l].equals(this.userLocations[l])) {
                res = res + "\n     " + this.text.getText("results.hint.correct.location." + this.lang, "???") + ".";
                continue;
            }
            res = res + "\n     " + this.text.getText("results.hint.wrong.location." + this.lang, "???") + ".";
            ++misplaced;
        }
        res = res + "\n";
        res = res + "\n " + this.text.getText("results.hint.correct.ordered." + this.lang, "???") + ": " + (this.correctOrder.length - misordered) + " " + this.text.getText("results.recall.overall.of." + this.lang, "???") + " " + this.correctOrder.length;
        res = res + "\n " + this.text.getText("results.hint.correct.placed." + this.lang, "???") + ": " + (this.correctLocations.length - misplaced) + " " + this.text.getText("results.recall.overall.of." + this.lang, "???") + " " + this.correctLocations.length;
        res = res + "\n " + this.text.getText("results.recall.overall.score." + this.lang, "???") + ": " + Math.round((float)(this.correctOrder.length + this.correctLocations.length - misplaced - misordered) / (float)(this.correctOrder.length + this.correctLocations.length) * 100.0f) + "%";
        return res;
    }

    public void saveResults(PrintWriter pw, String separator) {
        pw.println("--- Phase: Recall with Hint ----");
        pw.println("order" + separator + "correct object" + separator + "user object" + separator + "correctly ordered" + separator + "correct location" + separator + "user location" + separator + "correctly placed");
        for (int i = 0; i < this.correctOrder.length; ++i) {
            String cOrder = this.correctOrder[i].equals(this.userOrder[i]) ? "1" : "0";
            String cLocation = this.correctLocations[i].equals(this.userLocations[i]) ? "1" : "0";
            pw.println(i + 1 + separator + this.correctOrder[i] + separator + this.userOrder[i] + separator + cOrder + separator + this.correctLocations[i] + separator + this.userLocations[i] + separator + cLocation);
        }
    }
}

