/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.commandline;

import java.util.ArrayList;
import org.jagatoo.commandline.Argument;
import org.jagatoo.commandline.ArgumentsHandler;
import org.jagatoo.commandline.ArgumentsRegistry;
import org.jagatoo.commandline.CommandlineParsingException;
import org.jagatoo.util.strings.SimpleStringTokenizer;

public class CommandlineParser {
    private final ArgumentsRegistry argReg;
    private final ArgumentsHandler handler;

    private void onError(int chunk, String message) throws CommandlineParsingException {
        this.handler.onError(chunk, message);
    }

    private Argument onArgument(int chunk, String argName) throws CommandlineParsingException {
        Argument arg = this.argReg.getArgument(argName);
        if (arg == null) {
            throw new CommandlineParsingException(chunk, "There is no argument \"" + argName + "\".");
        }
        if (arg.needsValue()) {
            return arg;
        }
        this.onArgumentComplete(arg, null);
        return null;
    }

    private void onArgumentComplete(Argument arg, String rawValue) throws CommandlineParsingException {
        if (rawValue == null) {
            this.handler.handleArgument(arg, null);
        } else if (arg == null) {
            this.handler.handleArgument(null, rawValue);
        } else {
            this.handler.handleArgument(arg, arg.parseValue(rawValue));
        }
    }

    private Argument parseSingleCharArguments(int chunkNum, String chunk) throws CommandlineParsingException {
        Argument lastArg = null;
        int i = 1;
        while (i < chunk.length()) {
            char ch = chunk.charAt(i);
            lastArg = this.argReg.getArgument(ch);
            if (lastArg == null) {
                throw new CommandlineParsingException(chunkNum, "There is no argument '" + ch + "'.");
            }
            if (!lastArg.needsValue()) {
                this.onArgumentComplete(lastArg, null);
                lastArg = null;
            } else if (i < chunk.length() - 1) {
                this.onError(chunkNum, "No value provided for argument " + lastArg);
            }
            ++i;
        }
        return lastArg;
    }

    public void parseCommandline(String[] chunks) throws CommandlineParsingException {
        int minusCount = 0;
        int lastChar = 0;
        int firstNameChar = 0;
        Argument lastValueArg = null;
        int j = 0;
        while (j < chunks.length) {
            String chunk = chunks[j];
            if (lastValueArg != null) {
                this.onArgumentComplete(lastValueArg, chunk);
                lastValueArg = null;
            } else {
                minusCount = 0;
                lastChar = 0;
                firstNameChar = 0;
                int i = 0;
                while (i < chunk.length()) {
                    char ch = chunk.charAt(i);
                    if (ch == '-') {
                        if (lastChar == 0 || lastChar == 45) {
                            ++minusCount;
                            ++firstNameChar;
                        }
                    } else {
                        if (minusCount == 0) {
                            this.onArgumentComplete(null, chunk);
                            break;
                        }
                        if (minusCount == 1) {
                            lastValueArg = this.parseSingleCharArguments(j, chunk);
                            break;
                        }
                        if (minusCount == 2) {
                            lastValueArg = this.onArgument(j, chunk.substring(2));
                            break;
                        }
                        this.onError(j, "invalid chunk " + j);
                    }
                    lastChar = ch;
                    ++i;
                }
                if (firstNameChar == chunk.length()) {
                    this.onError(j, "invalid chunk " + j);
                }
            }
            ++j;
        }
        if (lastValueArg != null) {
            this.onError(chunks.length, "No value provided for argument " + lastValueArg);
        }
        this.handler.validate();
    }

    public void parseCommandline(String commandline) throws CommandlineParsingException {
        ArrayList<String> argsList = new ArrayList<String>();
        SimpleStringTokenizer tokenizer = new SimpleStringTokenizer(commandline);
        tokenizer.useQuotes(true);
        while (tokenizer.hasMoreTokens()) {
            argsList.add(tokenizer.nextToken());
        }
        this.parseCommandline(argsList.toArray(new String[argsList.size()]));
    }

    public CommandlineParser(ArgumentsRegistry argReg, ArgumentsHandler handler) {
        if (argReg == null) {
            throw new IllegalArgumentException("argReg must not be null.");
        }
        if (handler == null) {
            throw new IllegalArgumentException("handler must not be null.");
        }
        this.argReg = argReg;
        this.handler = handler;
    }
}

