/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.commands;

import java.util.ArrayList;
import org.jagatoo.commands.Command;
import org.jagatoo.commands.CommandException;
import org.jagatoo.commands.CommandLine;
import org.jagatoo.util.strings.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommandBase
implements Command {
    private final String key;
    private final String text;
    protected final Object[] paramsArray;

    @Override
    public final String getKey() {
        return this.key;
    }

    @Override
    public final String getText() {
        return this.text;
    }

    @Override
    public String getLocalizedText() {
        return this.getText();
    }

    @Override
    public final int getNumParameters() {
        return this.paramsArray.length;
    }

    @Override
    public Object[] createParametersArray(ArrayList<String> parameters) {
        if (parameters == null) {
            return null;
        }
        if (parameters.size() != this.getNumParameters()) {
            throw new IllegalArgumentException("number of parameters must be " + this.getNumParameters() + ". Got " + parameters.size() + ".");
        }
        int i = 0;
        while (i < this.getNumParameters()) {
            String paramString = parameters.get(i);
            this.paramsArray[i] = paramString == null ? null : (StringUtils.isNumeric(paramString) ? (paramString.indexOf(46) < 0 ? (Number)Integer.parseInt(paramString) : (Number)Float.valueOf(Float.parseFloat(paramString))) : (StringUtils.isBoolean(paramString) ? Boolean.valueOf(Boolean.parseBoolean(paramString)) : paramString));
            ++i;
        }
        return this.paramsArray;
    }

    @Override
    public final String execute(Object[] parameters) throws CommandException {
        return this.execute(null, parameters);
    }

    @Override
    public String execute(Boolean inputInfo, CommandLine commandLine) throws CommandException {
        return this.execute(inputInfo, this.createParametersArray(commandLine.getParameters()));
    }

    @Override
    public String execute(CommandLine commandLine) throws CommandException {
        return this.execute(this.createParametersArray(commandLine.getParameters()));
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Command)) {
            return false;
        }
        return this.getKey().equals(((Command)o).getKey());
    }

    public CommandBase(String key, String text, int numParams) {
        this.key = key;
        this.text = text;
        this.paramsArray = new Object[numParams];
    }

    public CommandBase(String key, int numParams) {
        this(key, null, numParams);
    }
}

