/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.geometry;

public abstract class GeomNioData {
    private final int maxElems;
    private final int maxSize;
    private final int elemSize;
    private final int stride;
    private final boolean reversed;
    private int freeIndex = 0;
    protected boolean dirty = true;

    public final int getMaxElements() {
        return this.maxElems;
    }

    public final int getMaxSize() {
        return this.maxSize;
    }

    public final int getElemSize() {
        return this.elemSize;
    }

    public final int getStride() {
        return this.stride;
    }

    public final boolean isReversed() {
        return this.reversed;
    }

    protected void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    int alloc(int size) {
        int a;
        if (this.reversed) {
            this.freeIndex = a = this.freeIndex - size;
        } else {
            a = this.freeIndex;
            this.freeIndex += size;
        }
        return a;
    }

    public void start() {
        this.freeIndex = this.reversed ? this.maxSize : 0;
    }

    public int getInitialIndex() {
        if (this.reversed) {
            return this.freeIndex;
        }
        return 0;
    }

    public int getCount() {
        return this.maxSize - this.freeIndex;
    }

    public GeomNioData(int maxElems, int maxSize, int elemSize, int stride, boolean reversed) {
        this.maxElems = maxElems;
        this.maxSize = maxSize;
        this.elemSize = elemSize;
        this.stride = stride;
        this.reversed = reversed;
    }
}

