/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.image;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import org.jagatoo.image.DirectBufferedImage;
import org.jagatoo.image.SharedBufferedImage;

public class BufferedImageFactory {
    public static BufferedImage createCustomRGB(int width, int height) {
        ColorSpace cs = ColorSpace.getInstance(1000);
        int[] nBits = new int[]{8, 8, 8};
        ComponentColorModel cm = new ComponentColorModel(cs, nBits, false, false, 1, 0);
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        int[] bandOffset = nArray;
        WritableRaster newRaster = Raster.createInterleavedRaster(0, width, height, width * 3, 3, bandOffset, null);
        BufferedImage newImage = new BufferedImage(cm, newRaster, false, null);
        return newImage;
    }

    public static BufferedImage createCustomRGBA(int width, int height) {
        ColorSpace cs = ColorSpace.getInstance(1000);
        int[] nBits = new int[]{8, 8, 8, 8};
        ComponentColorModel cm = new ComponentColorModel(cs, nBits, true, false, 1, 0);
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        int[] bandOffset = nArray;
        WritableRaster newRaster = Raster.createInterleavedRaster(0, width, height, width * 4, 4, bandOffset, null);
        BufferedImage newImage = new BufferedImage(cm, newRaster, false, null);
        return newImage;
    }

    public static SharedBufferedImage createSharedBufferedImage(int width, int height, int pixelSize, boolean hasAlpha, int[] pixelOffsets, byte[] data) {
        return SharedBufferedImage.create(width, height, pixelSize, hasAlpha, pixelOffsets, data);
    }

    public static final SharedBufferedImage createSharedBufferedImage(int width, int height, int pixelSize, int[] pixelOffsets, byte[] data) {
        return SharedBufferedImage.create(width, height, pixelSize, pixelOffsets, data);
    }

    public static DirectBufferedImage createDirectBufferedImage(int width, int height, boolean hasAlpha, int[] pixelOffsets, ByteBuffer bb) {
        if (hasAlpha) {
            return DirectBufferedImage.makeDirectImageRGBA(width, height, pixelOffsets, bb);
        }
        return DirectBufferedImage.makeDirectImageRGB(width, height, pixelOffsets, bb);
    }
}

