/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.image;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import org.jagatoo.image.DirectDataBufferByte;

public class DirectBufferedImage
extends BufferedImage {
    private final Type directType;
    private int numBytes;

    public final Type getDirectType() {
        return this.directType;
    }

    public final int getNumBytes() {
        return this.numBytes;
    }

    public final ByteBuffer getByteBuffer() {
        DirectDataBufferByte dataBuffer = (DirectDataBufferByte)this.getRaster().getDataBuffer();
        return dataBuffer.getByteBuffer();
    }

    private DirectBufferedImage(Type type, ColorModel model, WritableRaster raster, boolean rasterPremultiplied) {
        super(model, raster, rasterPremultiplied, null);
        this.directType = type;
        this.numBytes = raster.getDataBuffer().getSize();
    }

    private static final int[] createBandOffsets(int bytesPerPixel) {
        int[] bandOffsets = new int[bytesPerPixel];
        int i = 0;
        while (i < bandOffsets.length) {
            bandOffsets[i] = i;
            ++i;
        }
        return bandOffsets;
    }

    private static final int[] createNumBitsArray(int bytesPerPixel) {
        int[] numBits = new int[bytesPerPixel];
        int i = 0;
        while (i < numBits.length) {
            numBits[i] = 8;
            ++i;
        }
        return numBits;
    }

    public static DirectBufferedImage makeDirectImageRGBA(int width, int height, int[] bandOffsets, ByteBuffer bb) {
        int pixelSize = bb.limit() * 8 / (width * height);
        int bytesPerPixel = pixelSize / 8;
        if (bandOffsets == null) {
            int[] nArray = new int[4];
            nArray[0] = 3;
            nArray[1] = 2;
            nArray[2] = 1;
            bandOffsets = nArray;
        }
        DirectDataBufferByte buffer = new DirectDataBufferByte(bb);
        DirectWritableRaster newRaster = new DirectWritableRaster(width, height, bytesPerPixel, bandOffsets, buffer);
        ColorSpace cs = ColorSpace.getInstance(1000);
        int[] nBits = DirectBufferedImage.createNumBitsArray(bytesPerPixel);
        ComponentColorModel cm = new ComponentColorModel(cs, nBits, true, false, 3, 0);
        DirectBufferedImage newImage = new DirectBufferedImage(Type.DIRECT_RGBA, cm, newRaster, false);
        return newImage;
    }

    public static DirectBufferedImage makeDirectImageRGBA(int width, int height, int pixelSize) {
        int bytesPerPixel = pixelSize / 8;
        int[] nArray = new int[4];
        nArray[0] = 3;
        nArray[1] = 2;
        nArray[2] = 1;
        int[] bandOffsets = nArray;
        DirectDataBufferByte buffer = new DirectDataBufferByte(width * height * bytesPerPixel);
        DirectWritableRaster newRaster = new DirectWritableRaster(width, height, bytesPerPixel, bandOffsets, buffer);
        ColorSpace cs = ColorSpace.getInstance(1000);
        int[] nBits = DirectBufferedImage.createNumBitsArray(bytesPerPixel);
        ComponentColorModel cm = new ComponentColorModel(cs, nBits, true, false, 3, 0);
        DirectBufferedImage newImage = new DirectBufferedImage(Type.DIRECT_RGBA, cm, newRaster, false);
        return newImage;
    }

    public static DirectBufferedImage makeDirectImageRGBA(int width, int height) {
        return DirectBufferedImage.makeDirectImageRGBA(width, height, 32);
    }

    public static DirectBufferedImage makeDirectImageRGB(int width, int height, int[] bandOffsets, ByteBuffer bb) {
        int pixelSize = bb.limit() * 8 / (width * height);
        int bytesPerPixel = pixelSize / 8;
        if (bandOffsets == null) {
            bandOffsets = DirectBufferedImage.createBandOffsets(bytesPerPixel);
        }
        DirectDataBufferByte buffer = new DirectDataBufferByte(bb);
        DirectWritableRaster newRaster = new DirectWritableRaster(width, height, bytesPerPixel, bandOffsets, buffer);
        ColorSpace cs = ColorSpace.getInstance(1000);
        int[] nBits = DirectBufferedImage.createNumBitsArray(bytesPerPixel);
        ComponentColorModel cm = new ComponentColorModel(cs, nBits, false, false, 1, 0);
        DirectBufferedImage newImage = new DirectBufferedImage(Type.DIRECT_RGB, cm, newRaster, false);
        return newImage;
    }

    public static DirectBufferedImage makeDirectImageRGB(int width, int height, int pixelSize) {
        int bytesPerPixel = pixelSize / 8;
        int[] bandOffsets = DirectBufferedImage.createBandOffsets(bytesPerPixel);
        DirectDataBufferByte buffer = new DirectDataBufferByte(width * height * bytesPerPixel);
        DirectWritableRaster newRaster = new DirectWritableRaster(width, height, bytesPerPixel, bandOffsets, buffer);
        ColorSpace cs = ColorSpace.getInstance(1000);
        int[] nBits = DirectBufferedImage.createNumBitsArray(bytesPerPixel);
        ComponentColorModel cm = new ComponentColorModel(cs, nBits, false, false, 1, 0);
        DirectBufferedImage newImage = new DirectBufferedImage(Type.DIRECT_RGB, cm, newRaster, false);
        return newImage;
    }

    public static DirectBufferedImage makeDirectImageRGB(int width, int height) {
        return DirectBufferedImage.makeDirectImageRGB(width, height, 24);
    }

    public static DirectBufferedImage makeDirectImageRGB(BufferedImage source) {
        DirectBufferedImage dest = DirectBufferedImage.makeDirectImageRGB(source.getWidth(), source.getHeight());
        source.copyData(dest.getRaster());
        return dest;
    }

    public static DirectBufferedImage makeDirectImageTwoBytes(int width, int height, int pixelSize) {
        int bytesPerPixel = pixelSize / 8;
        int[] bandOffsets = DirectBufferedImage.createBandOffsets(bytesPerPixel);
        DirectDataBufferByte buffer = new DirectDataBufferByte(width * height * bytesPerPixel);
        DirectWritableRaster newRaster = new DirectWritableRaster(width, height, bytesPerPixel, bandOffsets, buffer);
        ColorSpace cs = ColorSpace.getInstance(1003);
        int[] nBits = DirectBufferedImage.createNumBitsArray(bytesPerPixel);
        ComponentColorModel cm = new ComponentColorModel(cs, nBits, false, false, 1, 0);
        DirectBufferedImage newImage = new DirectBufferedImage(Type.DIRECT_ONE_BYTE, cm, newRaster, false);
        return newImage;
    }

    public static DirectBufferedImage makeDirectImageTwoBytes(int width, int height) {
        return DirectBufferedImage.makeDirectImageRGBA(width, height, 16);
    }

    public static DirectBufferedImage makeDirectImageOneByte(int width, int height) {
        boolean bytesPerPixel = true;
        int[] bandOffsets = DirectBufferedImage.createBandOffsets(1);
        DirectDataBufferByte buffer = new DirectDataBufferByte(width * height * 1);
        DirectWritableRaster newRaster = new DirectWritableRaster(width, height, 1, bandOffsets, buffer);
        ColorSpace cs = ColorSpace.getInstance(1003);
        int[] nBits = DirectBufferedImage.createNumBitsArray(1);
        ComponentColorModel cm = new ComponentColorModel(cs, nBits, false, false, 1, 0);
        DirectBufferedImage newImage = new DirectBufferedImage(Type.DIRECT_ONE_BYTE, cm, newRaster, false);
        return newImage;
    }

    public static DirectBufferedImage makeDirectImageRGBA(BufferedImage source) {
        DirectBufferedImage dest = DirectBufferedImage.makeDirectImageRGBA(source.getWidth(), source.getHeight());
        source.copyData(dest.getRaster());
        return dest;
    }

    public static DirectBufferedImage make(Type type, int width, int height) {
        switch (type) {
            case DIRECT_RGBA: {
                return DirectBufferedImage.makeDirectImageRGBA(width, height);
            }
            case DIRECT_RGB: {
                return DirectBufferedImage.makeDirectImageRGB(width, height);
            }
            case DIRECT_TWO_BYTES: {
                return DirectBufferedImage.makeDirectImageTwoBytes(width, height);
            }
            case DIRECT_ONE_BYTE: {
                return DirectBufferedImage.makeDirectImageOneByte(width, height);
            }
        }
        throw new Error("Unknown direct image type " + (Object)((Object)type));
    }

    private static DirectBufferedImage convertViaDrawing(BufferedImage source, DirectBufferedImage dest) {
        Graphics2D g = (Graphics2D)dest.getGraphics();
        g.drawImage(source, 0, 0, dest.getWidth(), dest.getHeight(), null);
        return dest;
    }

    public static DirectBufferedImage make(BufferedImage bi, boolean allowAlpha) {
        boolean hasAlpha;
        boolean bl = hasAlpha = bi.getColorModel().hasAlpha() && !bi.getColorModel().isAlphaPremultiplied();
        if (hasAlpha && allowAlpha) {
            return DirectBufferedImage.convertViaDrawing(bi, DirectBufferedImage.makeDirectImageRGBA(bi.getWidth(), bi.getHeight()));
        }
        return DirectBufferedImage.convertViaDrawing(bi, DirectBufferedImage.makeDirectImageRGB(bi.getWidth(), bi.getHeight()));
    }

    public static DirectBufferedImage make(BufferedImage bi) {
        return DirectBufferedImage.make(bi, true);
    }

    public static DirectBufferedImage loadDirectImage(InputStream in, boolean allowAlpha) throws IOException {
        if (!(in instanceof BufferedInputStream)) {
            in = new BufferedInputStream(in);
        }
        BufferedImage bi = ImageIO.read(in);
        return DirectBufferedImage.make(bi, allowAlpha);
    }

    public static DirectBufferedImage loadDirectImage(InputStream in) throws IOException {
        return DirectBufferedImage.loadDirectImage(in, true);
    }

    public static DirectBufferedImage loadDirectImage(URL url, boolean allowAlpha) throws IOException {
        return DirectBufferedImage.loadDirectImage(url.openStream(), allowAlpha);
    }

    public static BufferedImage loadDirectImage(URL url) throws IOException {
        return DirectBufferedImage.loadDirectImage(url, true);
    }

    public static DirectBufferedImage loadDirectImage(File file, boolean allowAlpha) throws IOException {
        return DirectBufferedImage.loadDirectImage(new FileInputStream(file), allowAlpha);
    }

    public static DirectBufferedImage loadDirectImage(File file) throws IOException {
        return DirectBufferedImage.loadDirectImage(file, true);
    }

    public static DirectBufferedImage loadDirectImage(String name, boolean allowAlpha) throws IOException {
        return DirectBufferedImage.loadDirectImage(new File(name), allowAlpha);
    }

    public static DirectBufferedImage loadDirectImage(String name) throws IOException {
        return DirectBufferedImage.loadDirectImage(name, true);
    }

    private static class DirectWritableRaster
    extends WritableRaster {
        private static SampleModel createSampleModel(int width, int height, int bytesPerPixel, int[] bandOffsets) {
            PixelInterleavedSampleModel csm = new PixelInterleavedSampleModel(0, width, height, bytesPerPixel, width * bytesPerPixel, bandOffsets);
            return csm;
        }

        public DirectWritableRaster(int width, int height, int bytesPerPixel, int[] bandOffsets, DirectDataBufferByte dataBuffer) {
            super(DirectWritableRaster.createSampleModel(width, height, bytesPerPixel, bandOffsets), dataBuffer, new Point(0, 0));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        DIRECT_RGB,
        DIRECT_RGBA,
        DIRECT_TWO_BYTES,
        DIRECT_ONE_BYTE;

    }
}

