/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.input.devices;

import java.util.ArrayList;
import org.jagatoo.input.InputSystemException;
import org.jagatoo.input.InputSystemRuntimeException;
import org.jagatoo.input.devices.ControllerFactory;
import org.jagatoo.input.devices.InputDevice;
import org.jagatoo.input.devices.components.ControllerAxis;
import org.jagatoo.input.devices.components.ControllerButton;
import org.jagatoo.input.devices.components.DeviceComponent;
import org.jagatoo.input.events.ControllerAxisChangedEvent;
import org.jagatoo.input.events.ControllerButtonPressedEvent;
import org.jagatoo.input.events.ControllerButtonReleasedEvent;
import org.jagatoo.input.events.ControllerEvent;
import org.jagatoo.input.events.ControllerEventPool;
import org.jagatoo.input.events.EventQueue;
import org.jagatoo.input.listeners.ControllerListener;
import org.jagatoo.input.render.InputSourceWindow;

public abstract class Controller
extends InputDevice {
    private final ControllerFactory sourceFactory;
    private final ControllerAxis[] axes;
    private final ControllerButton[] buttons;
    private final ArrayList<ControllerListener> listeners = new ArrayList();
    private int numListeners = 0;
    private final long[] lastWhen_axisChanged;
    private final long[] lastWhen_buttonPressed;
    private final long[] lastWhen_buttonReleased;

    public final ControllerFactory getSourceFactory() {
        return this.sourceFactory;
    }

    public final int getAxesCount() {
        return this.axes.length;
    }

    public final ControllerAxis getAxis(int index) {
        return this.axes[index];
    }

    public final int getButtonsCount() {
        return this.buttons.length;
    }

    public final ControllerButton getButton(int index) {
        return this.buttons[index];
    }

    public int getState(DeviceComponent component) throws InputSystemRuntimeException {
        if (component instanceof ControllerButton) {
            ControllerButton button = (ControllerButton)component;
            if (button.getController() != this) {
                throw new InputSystemRuntimeException("The given ControllerButton is not part of this Controller.");
            }
            boolean state = this.isButtonPressed((ControllerButton)component);
            return state ? 1 : 0;
        }
        if (component instanceof ControllerAxis) {
            ControllerAxis axis = (ControllerAxis)component;
            if (axis.getController() != this) {
                throw new InputSystemRuntimeException("The given ControllerAxis is not part of this Controller.");
            }
            return axis.getIntValue();
        }
        throw new InputSystemRuntimeException("The Controller only supports ControllerButton and ControllerAxis instances for this method.");
    }

    public final boolean hasControllerListener() {
        return this.numListeners > 0;
    }

    public final boolean hasListener() {
        return this.hasInputStateListener() || this.hasControllerListener();
    }

    public void addControllerListener(ControllerListener l) {
        int i = 0;
        while (i < this.listeners.size()) {
            if (this.listeners.get(i) == l) {
                return;
            }
            ++i;
        }
        this.listeners.add(l);
        this.numListeners = this.listeners.size();
    }

    public void removeControllerListener(ControllerListener l) {
        this.listeners.remove(l);
        this.numListeners = this.listeners.size();
    }

    public final boolean isButtonPressed(ControllerButton button) {
        return false;
    }

    public final int getButtonState(ControllerButton button) {
        return this.isButtonPressed(button) ? 1 : 0;
    }

    protected final ControllerButtonPressedEvent prepareControllerButtonPressed(ControllerButton button, long when) {
        if (!this.isEnabled() || !this.hasListener()) {
            return null;
        }
        ControllerButtonPressedEvent e = ControllerEventPool.allocPressed(this, button, when, this.lastWhen_buttonPressed[button.getIndex()]);
        this.lastWhen_buttonPressed[button.getIndex()] = when;
        return e;
    }

    public final void fireOnControllerButtonPressed(ControllerButtonPressedEvent e, boolean consumeEvent) {
        if (!this.isEnabled() || !this.hasListener()) {
            if (consumeEvent) {
                ControllerEventPool.freePressed(e);
            }
            return;
        }
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.get(i).onControllerButtonStateChanged(e, e.getButton(), e.getButtonBooleanState());
            this.listeners.get(i).onControllerButtonPressed(e, e.getButton());
            ++i;
        }
        this.fireStateEventsAndDoActions(e, 1, 1);
        if (consumeEvent) {
            ControllerEventPool.freePressed(e);
        }
    }

    public final ControllerButtonReleasedEvent prepareControllerButtonReleased(ControllerButton button, long when) {
        if (!this.isEnabled() || !this.hasListener()) {
            return null;
        }
        ControllerButtonReleasedEvent e = ControllerEventPool.allocReleased(this, button, when, this.lastWhen_buttonReleased[button.getIndex()]);
        this.lastWhen_buttonReleased[button.getIndex()] = when;
        return e;
    }

    public final void fireOnControllerButtonReleased(ControllerButtonReleasedEvent e, boolean consumeEvent) {
        if (!this.isEnabled() || !this.hasListener()) {
            if (consumeEvent) {
                ControllerEventPool.freeReleased(e);
            }
            return;
        }
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.get(i).onControllerButtonStateChanged(e, e.getButton(), e.getButtonBooleanState());
            this.listeners.get(i).onControllerButtonReleased(e, e.getButton());
            ++i;
        }
        this.fireStateEventsAndDoActions(e, -1, 0);
        if (consumeEvent) {
            ControllerEventPool.freeReleased(e);
        }
    }

    public final ControllerAxisChangedEvent prepareControllerAxisChanged(ControllerAxis axis, float delta, long when) {
        if (!this.isEnabled() || !this.hasListener()) {
            return null;
        }
        ControllerAxisChangedEvent e = ControllerEventPool.allocAxis(this, axis, delta, when, this.lastWhen_axisChanged[axis.getIndex()]);
        this.lastWhen_axisChanged[axis.getIndex()] = when;
        return e;
    }

    public final void fireOnControllerAxisChanged(ControllerAxisChangedEvent e, boolean consumeEvent) {
        if (!this.isEnabled() || !this.hasListener()) {
            if (consumeEvent) {
                ControllerEventPool.freeAxis(e);
            }
            return;
        }
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.get(i).onControllerAxisChanged(e, e.getAxis(), e.getAxisDelta());
            ++i;
        }
        this.fireStateEventsAndDoActions(e, (int)(e.getAxis().getScale() * e.getAxisDelta()), e.getAxis().getIntValue());
        if (consumeEvent) {
            ControllerEventPool.freeAxis(e);
        }
    }

    public final void fireControllerEvent(ControllerEvent e, boolean consumeEvent) {
        switch (e.getSubType()) {
            case BUTTON_PRESSED: {
                this.fireOnControllerButtonPressed((ControllerButtonPressedEvent)e, consumeEvent);
                break;
            }
            case BUTTON_RELEASED: {
                this.fireOnControllerButtonReleased((ControllerButtonReleasedEvent)e, consumeEvent);
                break;
            }
            case AXIS_CHANGED: {
                this.fireOnControllerAxisChanged((ControllerAxisChangedEvent)e, consumeEvent);
            }
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " { name = \"" + this.getName() + "\", numAxes = " + this.getAxesCount() + ", numButtons = " + this.getButtonsCount() + " }";
    }

    protected abstract void destroyImpl() throws InputSystemException;

    public final void destroy() throws InputSystemException {
        this.destroyImpl();
    }

    protected abstract ControllerAxis[] createAxesArray(Object var1);

    protected abstract ControllerButton[] createButtonsArray(Object var1);

    protected Controller(ControllerFactory sourceFactory, InputSourceWindow sourceWindow, EventQueue eventQueue, String name, Object implObj) throws InputSystemException {
        super(sourceWindow, eventQueue, name);
        this.sourceFactory = sourceFactory;
        this.axes = this.createAxesArray(implObj);
        this.lastWhen_axisChanged = new long[this.axes.length];
        this.buttons = this.createButtonsArray(implObj);
        if (this.getAxesCount() == 0 && this.getButtonsCount() == 0) {
            throw new InputSystemException(InputSystemException.Info.ILLEGAL_CONTROLLER_CONFIGURATION);
        }
        this.lastWhen_buttonPressed = new long[this.buttons.length];
        this.lastWhen_buttonReleased = new long[this.buttons.length];
        int i = 0;
        while (i < this.axes.length) {
            this.lastWhen_axisChanged[i] = -1L;
            ++i;
        }
        i = 0;
        while (i < this.buttons.length) {
            this.lastWhen_buttonPressed[i] = -1L;
            this.lastWhen_buttonReleased[i] = -1L;
            ++i;
        }
    }
}

