/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.input.devices;

import java.util.ArrayList;
import java.util.Arrays;
import org.jagatoo.input.InputSystemException;
import org.jagatoo.input.InputSystemRuntimeException;
import org.jagatoo.input.devices.InputDevice;
import org.jagatoo.input.devices.KeyboardFactory;
import org.jagatoo.input.devices.components.DeviceComponent;
import org.jagatoo.input.devices.components.InputState;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.Keys;
import org.jagatoo.input.events.EventQueue;
import org.jagatoo.input.events.KeyPressedEvent;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.jagatoo.input.events.KeyTypedEvent;
import org.jagatoo.input.events.KeyboardEvent;
import org.jagatoo.input.events.KeyboardEventPool;
import org.jagatoo.input.listeners.KeyboardListener;
import org.jagatoo.input.localization.KeyboardLocalizer;
import org.jagatoo.input.render.InputSourceWindow;

public abstract class Keyboard
extends InputDevice {
    private final KeyboardFactory sourceFactory;
    private final boolean[] keyStates;
    private int modifierMask = 0;
    private final ArrayList<KeyboardListener> listeners = new ArrayList();

    public final KeyboardFactory getSourceFactory() {
        return this.sourceFactory;
    }

    public final boolean hasKeyboardListener() {
        return this.listeners.size() > 0;
    }

    public final boolean hasListener() {
        return this.hasInputStateListener() || this.hasKeyboardListener();
    }

    public void addKeyboardListener(KeyboardListener l) {
        int i = 0;
        while (i < this.listeners.size()) {
            if (this.listeners.get(i) == l) {
                return;
            }
            ++i;
        }
        this.listeners.add(l);
    }

    public void removeKeyboardListener(KeyboardListener l) {
        this.listeners.remove(l);
    }

    protected int applyModifier(Key key, boolean isKeyDown) {
        if (key == null) {
            return this.modifierMask;
        }
        switch (key.getKeyID()) {
            case LEFT_SHIFT: 
            case RIGHT_SHIFT: {
                if (isKeyDown) {
                    this.modifierMask |= 1;
                    break;
                }
                this.modifierMask &= 0xFFFFFFFE;
                break;
            }
            case LEFT_CONTROL: 
            case RIGHT_CONTROL: {
                if (isKeyDown) {
                    this.modifierMask |= 2;
                    break;
                }
                this.modifierMask &= 0xFFFFFFFD;
                break;
            }
            case ALT: {
                if (isKeyDown) {
                    this.modifierMask |= 4;
                    break;
                }
                this.modifierMask &= 0xFFFFFFFB;
                break;
            }
            case ALT_GRAPH: {
                if (isKeyDown) {
                    this.modifierMask |= 8;
                    break;
                }
                this.modifierMask &= 0xFFFFFFF7;
                break;
            }
            case LEFT_META: {
                if (isKeyDown) {
                    this.modifierMask |= 0x10;
                    break;
                }
                this.modifierMask &= 0xFFFFFFEF;
                break;
            }
            case RIGHT_META: {
                if (isKeyDown) {
                    this.modifierMask |= 0x20;
                    break;
                }
                this.modifierMask &= 0xFFFFFFDF;
            }
        }
        return this.modifierMask;
    }

    public final int getModifierMask() {
        return this.modifierMask;
    }

    protected final KeyPressedEvent prepareKeyPressedEvent(Key key, int modifierMask, long when, long lastWhen) {
        if (!this.isEnabled() || !this.hasListener() || key == null) {
            return null;
        }
        this.keyStates[key.getKeyCode() - 1] = true;
        KeyPressedEvent e = KeyboardEventPool.allocPressed(this, key, modifierMask, when, lastWhen);
        return e;
    }

    protected abstract boolean hasKeyStateChanged(Key var1, boolean var2);

    public final void fireOnKeyPressed(KeyPressedEvent e, boolean consumeEvent) {
        if (!this.isEnabled() || !this.hasListener()) {
            if (consumeEvent) {
                KeyboardEventPool.freePressed(e);
            }
            return;
        }
        if (this.hasKeyStateChanged(e.getKey(), this.keyStates[e.getKeyCode() - 1])) {
            int i = 0;
            while (i < this.listeners.size()) {
                this.listeners.get(i).onKeyStateChanged(e, e.getKey(), e.getKeyBooleanState());
                this.listeners.get(i).onKeyPressed(e, e.getKey());
                ++i;
            }
        }
        this.fireStateEventsAndDoActions(e, 1, 1);
        if (consumeEvent) {
            KeyboardEventPool.freePressed(e);
        }
    }

    protected final KeyReleasedEvent prepareKeyReleasedEvent(Key key, int modifierMask, long when, long lastWhen) {
        if (!this.isEnabled() || !this.hasListener() || key == null) {
            return null;
        }
        this.keyStates[key.getKeyCode() - 1] = false;
        KeyReleasedEvent e = KeyboardEventPool.allocReleased(this, key, modifierMask, when, lastWhen);
        return e;
    }

    public final void fireOnKeyReleased(KeyReleasedEvent e, boolean consumeEvent) {
        if (!this.isEnabled() || !this.hasListener()) {
            if (consumeEvent) {
                KeyboardEventPool.freeReleased(e);
            }
            return;
        }
        if (this.hasKeyStateChanged(e.getKey(), this.keyStates[e.getKeyCode() - 1])) {
            int i = 0;
            while (i < this.listeners.size()) {
                this.listeners.get(i).onKeyStateChanged(e, e.getKey(), e.getKeyBooleanState());
                this.listeners.get(i).onKeyReleased(e, e.getKey());
                ++i;
            }
        }
        this.fireStateEventsAndDoActions(e, -1, 0);
        if (consumeEvent) {
            KeyboardEventPool.freeReleased(e);
        }
    }

    protected final KeyTypedEvent prepareKeyTypedEvent(char keyChar, int modifierMask, long when, long lastWhen) {
        if (!this.isEnabled() || !this.hasListener() || keyChar == '\u0000') {
            return null;
        }
        KeyTypedEvent e = KeyboardEventPool.allocTyped(this, keyChar, modifierMask, when, lastWhen);
        return e;
    }

    public final void fireOnKeyTyped(KeyTypedEvent e, boolean consumeEvent) {
        if (!this.isEnabled() || !this.hasListener()) {
            if (consumeEvent) {
                KeyboardEventPool.freeTyped(e);
            }
            return;
        }
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.get(i).onKeyTyped(e, e.getKeyChar());
            ++i;
        }
        if (consumeEvent) {
            KeyboardEventPool.freeTyped(e);
        }
    }

    public final void fireKeyboardEvent(KeyboardEvent e, boolean consumeEvent) {
        switch (e.getSubType()) {
            case PRESSED: {
                this.fireOnKeyPressed((KeyPressedEvent)e, consumeEvent);
                break;
            }
            case RELEASED: {
                this.fireOnKeyReleased((KeyReleasedEvent)e, consumeEvent);
                break;
            }
            case TYPED: {
                this.fireOnKeyTyped((KeyTypedEvent)e, consumeEvent);
            }
        }
    }

    public final boolean isKeyPressed(Key key) {
        return this.keyStates[key.getKeyCode() - 1];
    }

    public final InputState getKeyState(Key key) {
        if (this.isKeyPressed(key)) {
            return InputState.POSITIVE;
        }
        return InputState.NEGATIVE;
    }

    public int getState(DeviceComponent component) throws InputSystemRuntimeException {
        if (!(component instanceof Key)) {
            throw new InputSystemRuntimeException("The Keyboard only supports Key instances for this method.");
        }
        boolean state = this.isKeyPressed((Key)component);
        return state ? 1 : 0;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " { name = \"" + this.getName() + "\", localization-mapping = \"" + KeyboardLocalizer.getCurrentMappingName() + "\" }";
    }

    protected abstract void destroyImpl() throws InputSystemException;

    public final void destroy() throws InputSystemException {
        this.destroyImpl();
    }

    protected Keyboard(KeyboardFactory sourceFactory, InputSourceWindow sourceWindow, EventQueue eventQueue, String name) throws InputSystemException {
        super(sourceWindow, eventQueue, name);
        this.sourceFactory = sourceFactory;
        this.keyStates = new boolean[Keys.getNumKeys()];
        Arrays.fill(this.keyStates, false);
    }
}

