/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.input.devices;

import java.util.ArrayList;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.InputSystemException;
import org.jagatoo.input.InputSystemRuntimeException;
import org.jagatoo.input.devices.InputDevice;
import org.jagatoo.input.devices.MouseFactory;
import org.jagatoo.input.devices.components.DeviceComponent;
import org.jagatoo.input.devices.components.InputState;
import org.jagatoo.input.devices.components.MouseAxis;
import org.jagatoo.input.devices.components.MouseButton;
import org.jagatoo.input.devices.components.MouseButtons;
import org.jagatoo.input.devices.components.MouseWheel;
import org.jagatoo.input.events.EventQueue;
import org.jagatoo.input.events.MouseButtonClickedEvent;
import org.jagatoo.input.events.MouseButtonPressedEvent;
import org.jagatoo.input.events.MouseButtonReleasedEvent;
import org.jagatoo.input.events.MouseEvent;
import org.jagatoo.input.events.MouseEventPool;
import org.jagatoo.input.events.MouseMovedEvent;
import org.jagatoo.input.events.MouseStoppedEvent;
import org.jagatoo.input.events.MouseWheelEvent;
import org.jagatoo.input.events._IS_Evts_PrivilegedAccess;
import org.jagatoo.input.listeners.MouseListener;
import org.jagatoo.input.listeners.MouseStopListener;
import org.jagatoo.input.managers.MouseStopManager;
import org.jagatoo.input.render.InputSourceWindow;

public abstract class Mouse
extends InputDevice {
    private final MouseFactory sourceFactory;
    private final MouseAxis xAxis;
    private final MouseAxis yAxis;
    private final MouseButton[] buttons;
    private final MouseWheel wheel;
    private boolean isAbsolute = true;
    private int buttonState = 0;
    private final ArrayList<MouseListener> listeners = new ArrayList();
    private int numListeners = 0;
    private final MouseButtonClickedEvent[] clickedEvents;
    private long lastWhen_buttonPressed = -1L;
    private long lastWhen_buttonReleased = -1L;
    private long lastWhen_moved = -1L;
    private long lastWhen_wheelMoved = -1L;
    private MouseStopManager stopManager = new MouseStopManager();

    public final MouseFactory getSourceFactory() {
        return this.sourceFactory;
    }

    protected final void notifyMouseStopManager(long nanoTime) {
        if (this.stopManager == null) {
            return;
        }
        this.stopManager.notifyMouseMoved(this, nanoTime);
    }

    public final MouseAxis getXAxis() {
        return this.xAxis;
    }

    public final MouseAxis getYAxis() {
        return this.yAxis;
    }

    protected void setPosition(int x, int y) throws InputSystemException {
        this.xAxis.setValue(x);
        this.yAxis.setValue(y);
    }

    public abstract void centerMouse() throws InputSystemException;

    protected void storePosition(int x, int y) {
        this.xAxis.setValue(x);
        this.yAxis.setValue(y);
    }

    public final int getCurrentX() {
        return this.xAxis.getIntValue();
    }

    public final int getCurrentY() {
        return this.yAxis.getIntValue();
    }

    public final int getButtonsCount() {
        return this.buttons.length;
    }

    public final MouseButton getButton(int index) {
        return this.buttons[index];
    }

    protected void setButtonsState(int buttonState) {
        this.buttonState = buttonState;
    }

    protected void addButtonsState(int buttonState) {
        this.buttonState |= buttonState;
    }

    protected void addButtonsState(MouseButton button) {
        this.buttonState |= button.getMaskValue();
    }

    protected void removeButtonsState(int buttonState) {
        this.buttonState &= ~buttonState;
    }

    protected void removeButtonsState(MouseButton button) {
        this.buttonState &= ~button.getMaskValue();
    }

    public final int getButtonsState() {
        return this.buttonState;
    }

    public final MouseWheel getWheel() {
        return this.wheel;
    }

    public final boolean isButtonPressed(MouseButton button) {
        return (this.buttonState & button.getMaskValue()) != 0;
    }

    public final InputState getButtonState(MouseButton button) {
        if (this.isButtonPressed(button)) {
            return InputState.POSITIVE;
        }
        return InputState.NEGATIVE;
    }

    public int getState(DeviceComponent component) throws InputSystemRuntimeException {
        if (component instanceof MouseButton) {
            boolean state = this.isButtonPressed((MouseButton)component);
            return state ? 1 : 0;
        }
        if (component instanceof MouseWheel) {
            if (component != MouseWheel.GLOBAL_WHEEL && component != this.getWheel()) {
                throw new InputSystemRuntimeException("The given MouseWheel is not part of this Mouse.");
            }
            return this.getWheel().getIntValue();
        }
        if (component instanceof MouseAxis) {
            if (component == this.getXAxis()) {
                return this.getCurrentX();
            }
            if (component == this.getYAxis()) {
                return this.getCurrentY();
            }
            throw new InputSystemRuntimeException("The given MouseAxis is not part of this Mouse.");
        }
        throw new InputSystemRuntimeException("The Mouse only supports MouseButton, MouseAxis and MouseWheel instances for this method.");
    }

    public void addMouseStopListener(MouseStopListener l) {
        this.stopManager.addMouseStopListener(l);
    }

    public void removeMouseStopListener(MouseStopListener l) {
        this.stopManager.removeMouseStopListener(l);
    }

    public final boolean hasMouseListener() {
        return this.stopManager.hasMouseListener();
    }

    public final boolean hasListener() {
        return this.hasInputStateListener() || this.hasMouseListener();
    }

    public void addMouseListener(MouseListener l) {
        boolean contains = false;
        int i = 0;
        while (i < this.listeners.size()) {
            if (this.listeners.get(i) == l) {
                contains = true;
                break;
            }
            ++i;
        }
        if (!contains) {
            this.listeners.add(l);
        }
        if (l instanceof MouseStopListener) {
            this.addMouseStopListener((MouseStopListener)((Object)l));
        }
        this.numListeners = this.listeners.size();
    }

    public void removeMouseListener(MouseListener l) {
        this.listeners.remove(l);
        if (l instanceof MouseStopListener) {
            this.removeMouseStopListener((MouseStopListener)((Object)l));
        }
        this.numListeners = this.listeners.size();
    }

    protected final MouseButtonPressedEvent prepareMouseButtonPressedEvent(MouseButton button, long when) {
        this.addButtonsState(button);
        if (!this.isEnabled() || !this.hasListener()) {
            return null;
        }
        MouseButtonPressedEvent e = MouseEventPool.allocPressed(this, button, when, this.lastWhen_buttonPressed);
        this.lastWhen_buttonPressed = when;
        return e;
    }

    public final void fireOnMouseButtonPressed(MouseButtonPressedEvent e, boolean consumeEvent) {
        if (!this.isEnabled() || !this.hasListener()) {
            if (consumeEvent) {
                MouseEventPool.freePressed(e);
            }
            return;
        }
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.get(i).onMouseButtonStateChanged(e, e.getButton(), e.getButtonBooleanState());
            this.listeners.get(i).onMouseButtonPressed(e, e.getButton());
            ++i;
        }
        this.fireStateEventsAndDoActions(e, 1, 1);
        if (consumeEvent) {
            MouseEventPool.freePressed(e);
        }
    }

    protected final MouseButtonReleasedEvent prepareMouseButtonReleasedEvent(MouseButton button, long when) {
        this.removeButtonsState(button);
        if (!this.isEnabled() || !this.hasListener()) {
            return null;
        }
        MouseButtonReleasedEvent e = MouseEventPool.allocReleased(this, button, when, this.lastWhen_buttonReleased);
        if (this.clickedEvents[button.getIndex()] == null) {
            this.clickedEvents[button.getIndex()] = MouseEventPool.allocClicked(this, button, when, this.lastWhen_buttonReleased);
        } else {
            _IS_Evts_PrivilegedAccess.incClickCount(this.clickedEvents[button.getIndex()], when);
        }
        this.lastWhen_buttonReleased = when;
        return e;
    }

    public final void fireOnMouseButtonReleased(MouseButtonReleasedEvent e, boolean consumeEvent) {
        if (!this.isEnabled() || !this.hasListener()) {
            if (consumeEvent) {
                MouseEventPool.freeReleased(e);
            }
            return;
        }
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.get(i).onMouseButtonStateChanged(e, e.getButton(), e.getButtonBooleanState());
            this.listeners.get(i).onMouseButtonReleased(e, e.getButton());
            ++i;
        }
        this.fireStateEventsAndDoActions(e, -1, 0);
        if (consumeEvent) {
            MouseEventPool.freeReleased(e);
        }
    }

    public final void fireOnMouseButtonClicked(MouseButtonClickedEvent e, boolean consumeEvent) {
        if (!this.isEnabled() || !this.hasListener()) {
            if (consumeEvent) {
                MouseEventPool.freeClicked(e);
            }
            return;
        }
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.get(i).onMouseButtonClicked(e, e.getButton(), e.getClickCount());
            ++i;
        }
        if (consumeEvent) {
            MouseEventPool.freeClicked(e);
        }
    }

    protected final void handleClickedEvents(long when, long threshold) {
        int i = 0;
        while (i < this.clickedEvents.length) {
            MouseButtonClickedEvent e = this.clickedEvents[i];
            if (e != null && e.getWhen() < when - threshold) {
                this.clickedEvents[i] = null;
                this.fireOnMouseButtonClicked(e, true);
            }
            ++i;
        }
    }

    protected final MouseMovedEvent prepareMouseMovedEvent(int x, int y, int dx, int dy, long when) {
        if (!this.isEnabled() || !this.hasListener()) {
            return null;
        }
        this.notifyMouseStopManager(when);
        if (this.numListeners == 0) {
            return null;
        }
        MouseMovedEvent e = MouseEventPool.allocMoved(this, x, y, dx, dy, when, this.lastWhen_moved);
        this.lastWhen_moved = when;
        return e;
    }

    public final void fireOnMouseMoved(MouseMovedEvent e, boolean consumeEvent) {
        if (!this.isEnabled()) {
            if (consumeEvent) {
                MouseEventPool.freeMoved(e);
            }
            return;
        }
        if (this.numListeners == 0) {
            if (consumeEvent) {
                MouseEventPool.freeMoved(e);
            }
            return;
        }
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.get(i).onMouseMoved(e, e.getX(), e.getY(), e.getDX(), e.getDY());
            ++i;
        }
        if (e.getDX() != 0) {
            this.fireStateEventsAndDoActions(e, e.getDX(), e.getX());
        }
        if (e.getDY() != 0) {
            this.fireStateEventsAndDoActions(e, e.getDY(), e.getY());
        }
        if (consumeEvent) {
            MouseEventPool.freeMoved(e);
        }
    }

    protected final MouseWheelEvent prepareMouseWheelMovedEvent(int wheelDelta, boolean isPageMove, long when) {
        MouseWheel wheel = this.getWheel();
        if (wheel == null) {
            return null;
        }
        wheel.addValue(wheelDelta);
        if (!this.isEnabled() || !this.hasListener()) {
            return null;
        }
        MouseWheelEvent e = MouseEventPool.allocWheel(this, wheel, wheelDelta, isPageMove, when, this.lastWhen_wheelMoved);
        this.lastWhen_wheelMoved = when;
        return e;
    }

    public final void fireOnMouseWheelMoved(MouseWheelEvent e, boolean consumeEvent) {
        MouseWheel wheel = this.getWheel();
        if (wheel == null) {
            if (consumeEvent) {
                MouseEventPool.freeWheel(e);
            }
            return;
        }
        if (!this.isEnabled() || this.numListeners == 0) {
            if (consumeEvent) {
                MouseEventPool.freeWheel(e);
            }
            return;
        }
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.get(i).onMouseWheelMoved(e, e.getWheelDelta());
            ++i;
        }
        this.fireStateEventsAndDoActions(e, e.getWheelDelta(), e.getMouse().getWheel().getIntValue());
        if (consumeEvent) {
            MouseEventPool.freeWheel(e);
        }
    }

    public final void fireMouseEvent(MouseEvent e, boolean consumeEvent) {
        switch (e.getSubType()) {
            case BUTTON_PRESSED: {
                this.fireOnMouseButtonPressed((MouseButtonPressedEvent)e, consumeEvent);
                break;
            }
            case BUTTON_RELEASED: {
                this.fireOnMouseButtonReleased((MouseButtonReleasedEvent)e, consumeEvent);
                break;
            }
            case BUTTON_CLICKED: {
                this.fireOnMouseButtonClicked((MouseButtonClickedEvent)e, consumeEvent);
                break;
            }
            case MOVED: {
                this.fireOnMouseMoved((MouseMovedEvent)e, consumeEvent);
                break;
            }
            case STOPPED: {
                if (this.stopManager != null) {
                    this.stopManager.fireOnMouseStopped(this, (MouseStoppedEvent)e, consumeEvent);
                    break;
                }
                if (!consumeEvent) break;
                MouseEventPool.freeStopped((MouseStoppedEvent)e);
                break;
            }
            case WHEEL_MOVED: {
                this.fireOnMouseWheelMoved((MouseWheelEvent)e, consumeEvent);
            }
        }
    }

    protected abstract void setAbsoluteImpl(boolean var1) throws InputSystemException;

    public final void setAbsolute(boolean absolute) throws InputSystemException {
        if (!this.isAbsolute && absolute) {
            this.isAbsolute = absolute;
            this.setAbsoluteImpl(absolute);
            this.getSourceWindow().refreshCursor(this);
        } else if (this.isAbsolute && !absolute) {
            this.isAbsolute = absolute;
            this.setAbsoluteImpl(absolute);
            this.getSourceWindow().refreshCursor(this);
        }
    }

    public final boolean isAbsolute() {
        return this.isAbsolute;
    }

    protected abstract void updateMouse(InputSystem var1, EventQueue var2, long var3) throws InputSystemException;

    public void update(InputSystem is, EventQueue eventQueue, long nanoTime) throws InputSystemException {
        this.updateMouse(is, eventQueue, nanoTime);
        this.stopManager.update(this, nanoTime);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " { name = \"" + this.getName() + "\", numButtons = " + this.getButtonsCount() + ", hasWheel = " + (this.getWheel() != null) + " }";
    }

    protected abstract void destroyImpl() throws InputSystemException;

    public final void destroy() throws InputSystemException {
        this.setAbsolute(true);
        this.destroyImpl();
    }

    protected Mouse(MouseFactory sourceFactory, InputSourceWindow sourceWindow, EventQueue eventQueue, String name, int numButtons, boolean hasWheel) throws InputSystemException {
        super(sourceWindow, eventQueue, name);
        this.sourceFactory = sourceFactory;
        this.xAxis = new MouseAxis(this, 'X', "Mouse-X-Axis");
        this.xAxis.setValue(sourceWindow.getWidth() / 2);
        this.yAxis = new MouseAxis(this, 'Y', "Mouse-Y-Axis");
        this.yAxis.setValue(sourceWindow.getHeight() / 2);
        this.buttons = new MouseButton[numButtons];
        this.clickedEvents = new MouseButtonClickedEvent[numButtons];
        int i = 0;
        while (i < this.buttons.length) {
            this.buttons[i] = MouseButtons.getByIndex(i);
            this.clickedEvents[i] = null;
            ++i;
        }
        this.wheel = hasWheel ? new MouseWheel(this) : null;
    }
}

