/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.input.devices.components;

import org.jagatoo.input.devices.Controller;
import org.jagatoo.input.devices.components.AnalogDeviceComponent;
import org.jagatoo.input.devices.components.DeviceComponent;

public abstract class ControllerAxis
extends AnalogDeviceComponent {
    private final Controller controller;
    private final int index;
    private float minValue = -1.0f;
    private float maxValue = 1.0f;
    private float invMinMaxSpan = 2.0f / (this.maxValue - this.minValue);
    private float normValue = 0.0f;
    private float deadZone;
    private final float povX;
    private final float povY;

    public final Controller getController() {
        return this.controller;
    }

    public final int getIndex() {
        return this.index;
    }

    private final void updateNormValue() {
        this.normValue = (this.getFloatValue() - this.getMinValue()) * this.invMinMaxSpan - 1.0f;
    }

    public void setMinValue(float minValue) {
        this.minValue = minValue;
        this.invMinMaxSpan = 2.0f / (this.maxValue - this.minValue);
        this.updateNormValue();
    }

    public final float getMinValue() {
        return this.minValue;
    }

    public void setMaxValue(float maxValue) {
        this.maxValue = maxValue;
        this.invMinMaxSpan = 2.0f / (this.maxValue - this.minValue);
        this.updateNormValue();
    }

    public final float getMaxValue() {
        return this.maxValue;
    }

    protected void setValue(int intValue, float floatValue) {
        super.setValue(intValue, floatValue);
        this.updateNormValue();
    }

    public final float getNormalizedValue() {
        return this.normValue;
    }

    protected abstract void setDeadZoneImpl(float var1);

    public final void setDeadZone(float zone) {
        this.deadZone = zone;
        this.setDeadZoneImpl(zone);
    }

    public final float getDeadZone() {
        return this.deadZone;
    }

    public final float getPovX() {
        return this.povX;
    }

    public final float getPovY() {
        return this.povY;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " { name = \"" + this.getName() + "\", index = " + this.getIndex() + ", value = " + this.getFloatValue() + " }";
    }

    public ControllerAxis(Controller controller, int index, String name, float deadZone, float povX, float povY) {
        super(DeviceComponent.Type.CONTROLLER_AXIS, name);
        this.controller = controller;
        this.index = index;
        this.deadZone = deadZone;
        this.povX = povX;
        this.povY = povY;
    }
}

