/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.input.devices.components;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.InputSystemException;
import org.jagatoo.input.actions.InvokableInputAction;
import org.jagatoo.input.devices.InputDevice;
import org.jagatoo.input.devices.components.AnalogDeviceComponent;
import org.jagatoo.input.devices.components.DigitalDeviceComponent;
import org.jagatoo.input.localization.KeyboardLocalizer;
import org.jagatoo.logging.Log;

public abstract class DeviceComponent {
    protected static int nextID = 1;
    private final int id = nextID++;
    private final String name;
    private final Type type;
    private InvokableInputAction[] actions = null;
    private InputDevice[] actionDevices = null;

    public final int getDeviceComponentID() {
        return this.id;
    }

    public final String getName() {
        return this.name;
    }

    public String getLocalizedName() {
        return KeyboardLocalizer.getMapping().getLocalizedKeyName(this);
    }

    public final Type getType() {
        return this.type;
    }

    public final boolean isDigital() {
        return this instanceof DigitalDeviceComponent;
    }

    public final boolean isAnalog() {
        return this instanceof AnalogDeviceComponent;
    }

    public void bindAction(InvokableInputAction action, InputDevice device) {
        if (this.actions == null) {
            this.actions = new InvokableInputAction[1];
            this.actionDevices = new InputDevice[1];
        } else {
            InvokableInputAction[] actions2 = new InvokableInputAction[this.actions.length + 1];
            InputDevice[] actionDevices2 = new InputDevice[this.actionDevices.length + 1];
            System.arraycopy(this.actions, 0, actions2, 0, this.actions.length);
            System.arraycopy(this.actionDevices, 0, actionDevices2, 0, this.actionDevices.length);
            this.actions = actions2;
            this.actionDevices = actionDevices2;
        }
        this.actions[this.actions.length - 1] = action;
        this.actionDevices[this.actionDevices.length - 1] = device;
    }

    public void bindAction(InvokableInputAction action) {
        this.bindAction(action, null);
    }

    private void unbindAction(int index) {
        if (index == 0 && this.actions.length == 1) {
            this.actions = null;
            this.actionDevices = null;
            return;
        }
        InvokableInputAction[] actions2 = new InvokableInputAction[this.actions.length - 1];
        InputDevice[] actionDevices2 = new InputDevice[this.actionDevices.length - 1];
        if (index > 0) {
            System.arraycopy(this.actions, 0, actions2, 0, index);
            System.arraycopy(this.actionDevices, 0, actionDevices2, 0, index);
        }
        if (index < this.actions.length - 1) {
            System.arraycopy(this.actions, index + 1, actions2, index, this.actions.length - index - 1);
            System.arraycopy(this.actionDevices, index + 1, actionDevices2, index, this.actionDevices.length - index - 1);
        }
        this.actions = actions2;
        this.actionDevices = actionDevices2;
    }

    private final int findActionIndex(InvokableInputAction action, InputDevice device) {
        if (this.actions == null) {
            return -1;
        }
        int i = 0;
        while (i < this.actions.length) {
            if (this.actions[i].equals(action) && (device == null || device == this.actionDevices[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void unbindAction(InvokableInputAction action, InputDevice device) {
        int index;
        while ((index = this.findActionIndex(action, device)) != -1) {
            this.unbindAction(index);
        }
    }

    public void unbindAction(InvokableInputAction action) {
        this.unbindAction(action, null);
    }

    public void notifyBoundActions(InputDevice device, int delta, int state, long nanoTime) {
        if (this.actions == null) {
            return;
        }
        int i = 0;
        while (i < this.actions.length) {
            if (this.actionDevices[i] == null || this.actionDevices[i] == device) {
                try {
                    this.actions[i].invokeAction(device, this, delta, state, nanoTime);
                }
                catch (InputSystemException ex) {
                    Log.print(InputSystem.LOG_CHANNEL, ex);
                    ex.printStackTrace();
                }
            }
            ++i;
        }
    }

    protected DeviceComponent(Type type, String name) {
        this.type = type;
        this.name = name;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        KEY,
        MOUSE_AXIS,
        MOUSE_BUTTON,
        MOUSE_WHEEL,
        CONTROLLER_BUTTON,
        CONTROLLER_AXIS;


        public final boolean isKeyboardComponent() {
            return this == KEY;
        }

        public final boolean isMouseComponent() {
            return this == MOUSE_AXIS || this == MOUSE_BUTTON || this == MOUSE_WHEEL;
        }

        public final boolean isControllerComponent() {
            return this == CONTROLLER_AXIS || this == CONTROLLER_BUTTON;
        }
    }
}

