/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.input.events;

import org.jagatoo.input.devices.Controller;
import org.jagatoo.input.devices.components.ControllerAxis;
import org.jagatoo.input.events.ControllerEvent;

public class ControllerAxisChangedEvent
extends ControllerEvent {
    protected ControllerAxis axis;
    protected float axisDelta;

    public final ControllerAxis getAxis() {
        return this.axis;
    }

    public final float getAxisValue() {
        return this.getAxis().getFloatValue();
    }

    public final float getAxisDelta() {
        return this.axisDelta;
    }

    public String toString() {
        return "ControllerAxisChangedEvent { value = " + this.getAxisValue() + ", " + "delta = " + this.getAxisDelta() + ", " + "when = " + this.getWhen() + ", " + "lastWhen = " + this.getLastWhen() + " }";
    }

    public void set(Controller controller, ControllerAxis axis, float axisDelta, long when, long lastWhen) {
        super.set(controller, ControllerEvent.SubType.AXIS_CHANGED, axis, when, lastWhen);
        this.axis = axis;
        this.axisDelta = axisDelta;
    }

    public void set(ControllerAxisChangedEvent e) {
        super.set(e);
        this.axis = e.axis;
        this.axisDelta = e.axisDelta;
    }

    public ControllerAxisChangedEvent() {
        super(ControllerEvent.SubType.AXIS_CHANGED);
    }

    public ControllerAxisChangedEvent(Controller controller, ControllerAxis axis, float axisDelta, long when, long lastWhen) {
        super(controller, ControllerEvent.SubType.AXIS_CHANGED, axis, when, lastWhen);
        this.axis = axis;
        this.axisDelta = axisDelta;
    }
}

