/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.input.events;

import java.util.ArrayList;
import org.jagatoo.input.devices.Controller;
import org.jagatoo.input.devices.components.ControllerAxis;
import org.jagatoo.input.devices.components.ControllerButton;
import org.jagatoo.input.events.ControllerAxisChangedEvent;
import org.jagatoo.input.events.ControllerButtonPressedEvent;
import org.jagatoo.input.events.ControllerButtonReleasedEvent;
import org.jagatoo.input.render.InputSourceWindow;

public final class ControllerEventPool {
    private static ArrayList<ControllerAxisChangedEvent> instances_axis = new ArrayList(64);
    private static ArrayList<ControllerButtonPressedEvent> instances_pressed = new ArrayList(64);
    private static ArrayList<ControllerButtonReleasedEvent> instances_released = new ArrayList(64);
    private static int n_axis = 0;
    private static int n_pressed = 0;
    private static int n_released = 0;
    private static final Object LOCK_axis = new Object();
    private static final Object LOCK_pressed = new Object();
    private static final Object LOCK_released = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ControllerAxisChangedEvent allocAxis() {
        Object object = LOCK_axis;
        synchronized (object) {
            if (n_axis > 0) {
                ControllerAxisChangedEvent e = instances_axis.remove(--n_axis);
                return e;
            }
            return new ControllerAxisChangedEvent();
        }
    }

    public static ControllerAxisChangedEvent allocAxis(Controller controller, ControllerAxis axis, float axisDelta, long when, long lastWhen) {
        ControllerAxisChangedEvent e = ControllerEventPool.allocAxis();
        e.set(controller, axis, axisDelta, when, lastWhen);
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void freeAxis(ControllerAxisChangedEvent e) {
        if (e == null) {
            return;
        }
        Object object = LOCK_axis;
        synchronized (object) {
            instances_axis.add(e);
            ++n_axis;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ControllerButtonPressedEvent allocPressed() {
        Object object = LOCK_pressed;
        synchronized (object) {
            if (n_pressed > 0) {
                ControllerButtonPressedEvent e = instances_pressed.remove(--n_pressed);
                return e;
            }
            return new ControllerButtonPressedEvent();
        }
    }

    public static ControllerButtonPressedEvent allocPressed(Controller controller, ControllerButton button, long when, long lastWhen) {
        ControllerButtonPressedEvent e = ControllerEventPool.allocPressed();
        e.set(controller, button, when, lastWhen);
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void freePressed(ControllerButtonPressedEvent e) {
        if (e == null) {
            return;
        }
        Object object = LOCK_pressed;
        synchronized (object) {
            instances_pressed.add(e);
            ++n_pressed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ControllerButtonReleasedEvent allocReleased() {
        Object object = LOCK_released;
        synchronized (object) {
            if (n_released > 0) {
                ControllerButtonReleasedEvent e = instances_released.remove(--n_released);
                return e;
            }
            return new ControllerButtonReleasedEvent();
        }
    }

    public static ControllerButtonReleasedEvent allocReleased(Controller controller, ControllerButton button, long when, long lastWhen) {
        ControllerButtonReleasedEvent e = ControllerEventPool.allocReleased();
        e.set(controller, button, when, lastWhen);
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void freeReleased(ControllerButtonReleasedEvent e) {
        if (e == null) {
            return;
        }
        Object object = LOCK_released;
        synchronized (object) {
            instances_released.add(e);
            ++n_released;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanup(InputSourceWindow sourceWindow) {
        int i;
        if (sourceWindow == null) {
            Object object = LOCK_axis;
            synchronized (object) {
                instances_axis.clear();
                n_axis = 0;
            }
            object = LOCK_pressed;
            synchronized (object) {
                instances_pressed.clear();
                n_pressed = 0;
            }
            object = LOCK_released;
            synchronized (object) {
                instances_released.clear();
                n_released = 0;
            }
        }
        Object object = LOCK_axis;
        synchronized (object) {
            i = instances_axis.size() - 1;
            while (i >= 0) {
                if (instances_axis.get(i).getController().getSourceWindow() == sourceWindow) {
                    instances_axis.remove(i);
                    --n_axis;
                }
                --i;
            }
        }
        object = LOCK_pressed;
        synchronized (object) {
            i = instances_pressed.size() - 1;
            while (i >= 0) {
                if (instances_pressed.get(i).getController().getSourceWindow() == sourceWindow) {
                    instances_pressed.remove(i);
                    --n_pressed;
                }
                --i;
            }
        }
        object = LOCK_released;
        synchronized (object) {
            i = instances_released.size() - 1;
            while (i >= 0) {
                if (instances_released.get(i).getController().getSourceWindow() == sourceWindow) {
                    instances_released.remove(i);
                    --n_released;
                }
                --i;
            }
        }
    }

    private ControllerEventPool() {
    }
}

