/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.input.events;

import org.jagatoo.input.devices.Keyboard;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.InputEvent;

public abstract class KeyboardEvent
extends InputEvent {
    private final SubType subType;
    private Keyboard keyboard;
    private Key key;
    private int modifierMask;

    public final SubType getSubType() {
        return this.subType;
    }

    public final Keyboard getKeyboard() {
        return this.keyboard;
    }

    public final Key getKey() {
        return this.key;
    }

    public final int getModifierMask() {
        return this.modifierMask;
    }

    public final int getKeyCode() {
        if (this.key == null) {
            return 0;
        }
        return this.key.getKeyCode();
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "( keyCode = " + this.getKeyCode() + ", keyChar = " + this.getKeyCode() + ", when = " + this.getWhen() + " )";
    }

    protected void set(Keyboard keyboard, Key key, int modifierMask, long when, long lastWhen) {
        super.set(key, when, lastWhen);
        this.keyboard = keyboard;
        this.key = key;
        this.modifierMask = modifierMask;
    }

    protected KeyboardEvent(SubType subType) {
        super(InputEvent.Type.KEYBOARD_EVENT, null, 0L, 0L);
        this.subType = subType;
    }

    protected KeyboardEvent(Keyboard keyboard, SubType subType, Key key, int modifierMask, long when, long lastWhen) {
        this(subType);
        this.set(keyboard, key, modifierMask, when, lastWhen);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SubType {
        PRESSED,
        RELEASED,
        TYPED;

    }
}

