/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.input.impl.jinput;

import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.InputSystemException;
import org.jagatoo.input.devices.Controller;
import org.jagatoo.input.devices.InputDeviceFactory;
import org.jagatoo.input.devices.Keyboard;
import org.jagatoo.input.devices.KeyboardFactory;
import org.jagatoo.input.devices.Mouse;
import org.jagatoo.input.events.EventQueue;
import org.jagatoo.input.impl.jinput.JInputController;
import org.jagatoo.input.impl.jinput.JInputKeyboard;
import org.jagatoo.input.impl.jinput.JInputMouse;
import org.jagatoo.input.render.InputSourceWindow;
import org.jagatoo.logging.Log;

public class JInputInputDeviceFactory
extends InputDeviceFactory {
    protected JInputMouse[] initMouses() throws InputSystemException {
        try {
            Mouse[] currentMoues = this.getCachedMouses();
            net.java.games.input.Controller[] controllers = ControllerEnvironment.getDefaultEnvironment().getControllers();
            JInputMouse[] tmpMouses = new JInputMouse[controllers.length];
            int numMouses = 0;
            boolean alreadyExisting = false;
            int i = 0;
            while (i < controllers.length) {
                if (controllers[i].getType() == Controller.Type.MOUSE) {
                    alreadyExisting = false;
                    if (currentMoues != null) {
                        int j = 0;
                        while (j < currentMoues.length) {
                            if (currentMoues[j] instanceof JInputMouse && currentMoues[j].getName().equals(controllers[i].getName())) {
                                tmpMouses[numMouses++] = (JInputMouse)currentMoues[j];
                                alreadyExisting = true;
                                break;
                            }
                            ++j;
                        }
                    }
                    if (!alreadyExisting) {
                        tmpMouses[numMouses++] = new JInputMouse(this.findSourceFactory(), this.getSourceWindow(), this.getEveneQueue(), (net.java.games.input.Mouse)controllers[i]);
                    }
                }
                ++i;
            }
            JInputMouse[] mouses = new JInputMouse[numMouses];
            System.arraycopy(tmpMouses, 0, mouses, 0, numMouses);
            return mouses;
        }
        catch (NoClassDefFoundError ncdfe) {
            String message = "Error retrieving Mouses. JInput doesn't seem to be installed.";
            Log.error(InputSystem.LOG_CHANNEL, message);
            throw new InputSystemException(message, (Throwable)ncdfe);
        }
    }

    protected JInputKeyboard[] initKeyboards() throws InputSystemException {
        try {
            Keyboard[] currentKeyboards = this.getCachedKeyboards();
            net.java.games.input.Controller[] controllers = ControllerEnvironment.getDefaultEnvironment().getControllers();
            JInputKeyboard[] tmpKeyboards = new JInputKeyboard[controllers.length];
            int numKeyboards = 0;
            boolean alreadyExisting = false;
            int i = 0;
            while (i < controllers.length) {
                if (controllers[i].getType() == Controller.Type.KEYBOARD && controllers[i].getComponents().length > 10) {
                    alreadyExisting = false;
                    if (currentKeyboards != null) {
                        int j = 0;
                        while (j < currentKeyboards.length) {
                            if (currentKeyboards[j] instanceof JInputKeyboard && currentKeyboards[j].getName().equals(controllers[i].getName())) {
                                tmpKeyboards[numKeyboards++] = (JInputKeyboard)currentKeyboards[j];
                                alreadyExisting = true;
                                break;
                            }
                            ++j;
                        }
                    }
                    if (!alreadyExisting) {
                        tmpKeyboards[numKeyboards++] = new JInputKeyboard((KeyboardFactory)this.findSourceFactory(), this.getSourceWindow(), this.getEveneQueue(), (net.java.games.input.Keyboard)controllers[i]);
                    }
                }
                ++i;
            }
            JInputKeyboard[] keyboards = new JInputKeyboard[numKeyboards];
            System.arraycopy(tmpKeyboards, 0, keyboards, 0, numKeyboards);
            return keyboards;
        }
        catch (NoClassDefFoundError ncdfe) {
            String message = "Error retrieving Keyboards. JInput doesn't seem to be installed.";
            Log.error(InputSystem.LOG_CHANNEL, message);
            throw new InputSystemException(message, (Throwable)ncdfe);
        }
    }

    private static final boolean isController(Controller.Type type) {
        if (type == Controller.Type.FINGERSTICK) {
            return true;
        }
        if (type == Controller.Type.GAMEPAD) {
            return true;
        }
        if (type == Controller.Type.HEADTRACKER) {
            return true;
        }
        if (type == Controller.Type.RUDDER) {
            return true;
        }
        if (type == Controller.Type.STICK) {
            return true;
        }
        if (type == Controller.Type.TRACKBALL) {
            return true;
        }
        if (type == Controller.Type.TRACKPAD) {
            return true;
        }
        return type == Controller.Type.WHEEL;
    }

    protected JInputController[] initControllers() throws InputSystemException {
        try {
            Controller[] currentControllers = this.getCachedControllers();
            net.java.games.input.Controller[] controllers = ControllerEnvironment.getDefaultEnvironment().getControllers();
            JInputController[] tmpControllers = new JInputController[controllers.length];
            int numControllers = 0;
            boolean alreadyExisting = false;
            int i = 0;
            while (i < controllers.length) {
                block10: {
                    if (JInputInputDeviceFactory.isController(controllers[i].getType())) {
                        alreadyExisting = false;
                        if (currentControllers != null) {
                            int j = 0;
                            while (j < currentControllers.length) {
                                if (currentControllers[j] instanceof JInputController && currentControllers[j].getName().equals(controllers[i].getName())) {
                                    tmpControllers[numControllers++] = (JInputController)currentControllers[j];
                                    alreadyExisting = true;
                                    break;
                                }
                                ++j;
                            }
                        }
                        if (!alreadyExisting) {
                            try {
                                tmpControllers[numControllers++] = new JInputController(this.findSourceFactory(), this.getSourceWindow(), this.getEveneQueue(), controllers[i]);
                            }
                            catch (InputSystemException ise) {
                                if (ise.getInfo() == InputSystemException.Info.ILLEGAL_CONTROLLER_CONFIGURATION) break block10;
                                throw ise;
                            }
                        }
                    }
                }
                ++i;
            }
            JInputController[] controllers2 = new JInputController[numControllers];
            System.arraycopy(tmpControllers, 0, controllers2, 0, numControllers);
            return controllers2;
        }
        catch (NoClassDefFoundError ncdfe) {
            String message = "Error retrieving Controllers. JInput doesn't seem to be installed.";
            Log.error(InputSystem.LOG_CHANNEL, message);
            throw new InputSystemException(message, (Throwable)ncdfe);
        }
    }

    protected void destroyImpl(InputSystem inputSystem) throws InputSystemException {
    }

    public JInputInputDeviceFactory(InputDeviceFactory masterFactory, InputSourceWindow sourceWindow, EventQueue eventQueue) {
        super(masterFactory, true, sourceWindow, eventQueue);
    }

    public JInputInputDeviceFactory(InputSourceWindow sourceWindow, EventQueue eventQueue) {
        this(null, sourceWindow, eventQueue);
    }
}

