/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.input.impl.jinput;

import java.util.HashMap;
import net.java.games.input.Component;
import net.java.games.input.Event;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.InputSystemException;
import org.jagatoo.input.devices.Keyboard;
import org.jagatoo.input.devices.KeyboardFactory;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.Keys;
import org.jagatoo.input.events.EventQueue;
import org.jagatoo.input.events.InputEvent;
import org.jagatoo.input.events.KeyPressedEvent;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.jagatoo.input.events.KeyTypedEvent;
import org.jagatoo.input.localization.KeyboardLocalizer;
import org.jagatoo.input.render.InputSourceWindow;

public class JInputKeyboard
extends Keyboard {
    private final net.java.games.input.Keyboard keyboard;
    private final HashMap<Component, Key> keyMap = new HashMap();
    private final Event event = new Event();

    private final char getKeyChar(Key key, char char0, char charShift, int modifierMask) {
        if (modifierMask == 0) {
            return char0;
        }
        if (modifierMask == 1 && charShift != '\u0000') {
            return charShift;
        }
        return KeyboardLocalizer.getMapping().getModifiedChar(key, char0, modifierMask);
    }

    private final char getKeyChar(Key key, int modifierMask) {
        switch (key.getKeyID()) {
            case _0: {
                return this.getKeyChar(key, '0', '\u0000', modifierMask);
            }
            case _1: {
                return this.getKeyChar(key, '1', '\u0000', modifierMask);
            }
            case _2: {
                return this.getKeyChar(key, '2', '\u0000', modifierMask);
            }
            case _3: {
                return this.getKeyChar(key, '3', '\u0000', modifierMask);
            }
            case _4: {
                return this.getKeyChar(key, '4', '\u0000', modifierMask);
            }
            case _5: {
                return this.getKeyChar(key, '5', '\u0000', modifierMask);
            }
            case _6: {
                return this.getKeyChar(key, '6', '\u0000', modifierMask);
            }
            case _7: {
                return this.getKeyChar(key, '7', '\u0000', modifierMask);
            }
            case _8: {
                return this.getKeyChar(key, '8', '\u0000', modifierMask);
            }
            case _9: {
                return this.getKeyChar(key, '9', '\u0000', modifierMask);
            }
            case A: {
                return this.getKeyChar(key, 'a', 'A', modifierMask);
            }
            case B: {
                return this.getKeyChar(key, 'b', 'B', modifierMask);
            }
            case C: {
                return this.getKeyChar(key, 'c', 'C', modifierMask);
            }
            case D: {
                return this.getKeyChar(key, 'd', 'D', modifierMask);
            }
            case E: {
                return this.getKeyChar(key, 'e', 'E', modifierMask);
            }
            case F: {
                return this.getKeyChar(key, 'f', 'F', modifierMask);
            }
            case G: {
                return this.getKeyChar(key, 'g', 'G', modifierMask);
            }
            case H: {
                return this.getKeyChar(key, 'h', 'H', modifierMask);
            }
            case I: {
                return this.getKeyChar(key, 'i', 'I', modifierMask);
            }
            case J: {
                return this.getKeyChar(key, 'j', 'J', modifierMask);
            }
            case K: {
                return this.getKeyChar(key, 'k', 'K', modifierMask);
            }
            case L: {
                return this.getKeyChar(key, 'l', 'L', modifierMask);
            }
            case M: {
                return this.getKeyChar(key, 'm', 'M', modifierMask);
            }
            case N: {
                return this.getKeyChar(key, 'n', 'N', modifierMask);
            }
            case O: {
                return this.getKeyChar(key, 'o', 'O', modifierMask);
            }
            case P: {
                return this.getKeyChar(key, 'p', 'P', modifierMask);
            }
            case Q: {
                return this.getKeyChar(key, 'q', 'Q', modifierMask);
            }
            case R: {
                return this.getKeyChar(key, 'r', 'R', modifierMask);
            }
            case S: {
                return this.getKeyChar(key, 's', 'S', modifierMask);
            }
            case T: {
                return this.getKeyChar(key, 't', 'T', modifierMask);
            }
            case U: {
                return this.getKeyChar(key, 'u', 'U', modifierMask);
            }
            case V: {
                return this.getKeyChar(key, 'v', 'V', modifierMask);
            }
            case W: {
                return this.getKeyChar(key, 'w', 'W', modifierMask);
            }
            case X: {
                return this.getKeyChar(key, 'x', 'X', modifierMask);
            }
            case Y: {
                return this.getKeyChar(key, 'y', 'Y', modifierMask);
            }
            case Z: {
                return this.getKeyChar(key, 'z', 'Z', modifierMask);
            }
            case TAB: {
                return '\t';
            }
            case SPACE: {
                return ' ';
            }
            case BACK_SPACE: {
                return '\b';
            }
            case ENTER: {
                return '\r';
            }
            case DELETE: {
                return '\u007f';
            }
            case NUMPAD_DIVIDE: {
                return '/';
            }
            case NUMPAD_MULTIPLY: {
                return '*';
            }
            case NUMPAD_SUBTRACT: {
                return '-';
            }
            case NUMPAD_ADD: {
                return '+';
            }
            case NUMPAD_ENTER: {
                return '\r';
            }
            case NUMPAD0: {
                return '0';
            }
            case NUMPAD1: {
                return '1';
            }
            case NUMPAD2: {
                return '2';
            }
            case NUMPAD3: {
                return '3';
            }
            case NUMPAD4: {
                return '4';
            }
            case NUMPAD5: {
                return '5';
            }
            case NUMPAD6: {
                return '6';
            }
            case NUMPAD7: {
                return '7';
            }
            case NUMPAD8: {
                return '8';
            }
            case NUMPAD9: {
                return '9';
            }
            case CIRCUMFLEX: 
            case NUMPAD_DECIMAL: 
            case LOCAL_KEY1: 
            case LOCAL_KEY2: 
            case LOCAL_KEY3: 
            case LOCAL_KEY4: 
            case LOCAL_KEY5: 
            case LOCAL_KEY6: 
            case LOCAL_KEY7: 
            case LOCAL_KEY8: 
            case LOCAL_KEY9: 
            case LOCAL_KEY10: 
            case LOCAL_KEY11: {
                return KeyboardLocalizer.getMapping().getModifiedChar(key, '\u0000', modifierMask);
            }
        }
        return '\u0000';
    }

    protected boolean hasKeyStateChanged(Key key, boolean keyState) {
        return true;
    }

    protected final void collectOrFireEvents(InputSystem is, EventQueue eventQueue, long nanoTime, boolean acceptsEvents) throws InputSystemException {
        boolean isQueued = eventQueue != null;
        try {
            this.keyboard.poll();
            while (this.keyboard.getEventQueue().getNextEvent(this.event)) {
                Key key;
                if (!acceptsEvents || (key = this.keyMap.get(this.event.getComponent())) == null) continue;
                switch (key.getKeyID()) {
                    case Y: {
                        key = KeyboardLocalizer.getMapping().getUpperYZKey();
                        break;
                    }
                    case Z: {
                        key = KeyboardLocalizer.getMapping().getLowerYZKey();
                    }
                }
                boolean keyState = (int)this.event.getValue() != 0;
                int modifierMask = this.applyModifier(key, keyState);
                if (keyState) {
                    KeyTypedEvent typedEv;
                    KeyPressedEvent pressedEv = this.prepareKeyPressedEvent(key, modifierMask, nanoTime, 0L);
                    is.notifyInputStatesManagers(this, key, 1, 1, nanoTime);
                    if (pressedEv == null) continue;
                    if (isQueued) {
                        eventQueue.enqueue(pressedEv);
                    } else {
                        this.fireOnKeyPressed(pressedEv, true);
                    }
                    char keyChar = this.getKeyChar(key, modifierMask);
                    if (keyChar == '\u0000' || (typedEv = this.prepareKeyTypedEvent(keyChar, modifierMask, nanoTime, 0L)) == null) continue;
                    if (isQueued) {
                        eventQueue.enqueue(typedEv);
                        continue;
                    }
                    this.fireOnKeyTyped(typedEv, true);
                    continue;
                }
                KeyReleasedEvent releasedEv = this.prepareKeyReleasedEvent(key, modifierMask, nanoTime, 0L);
                is.notifyInputStatesManagers(this, key, 0, -1, nanoTime);
                if (releasedEv == null) continue;
                if (isQueued) {
                    eventQueue.enqueue(releasedEv);
                    continue;
                }
                this.fireOnKeyReleased(releasedEv, true);
            }
        }
        catch (Throwable t) {
            if (t instanceof InputSystemException) {
                throw (InputSystemException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new InputSystemException(t);
        }
    }

    public void consumePendingEvents(InputSystem is, EventQueue eventQueue, long nanoTime) throws InputSystemException {
        this.collectOrFireEvents(is, eventQueue, nanoTime, false);
    }

    public void collectEvents(InputSystem is, EventQueue eventQueue, long nanoTime) throws InputSystemException {
        if (eventQueue == null) {
            throw new InputSystemException("EventQueue must not be null here!");
        }
        boolean acceptEvents = this.isEnabled() && this.getSourceWindow().receivesInputEvents();
        this.collectOrFireEvents(is, eventQueue, nanoTime, acceptEvents);
    }

    public void update(InputSystem is, EventQueue eventQueue, long nanoTime) throws InputSystemException {
        this.collectOrFireEvents(is, null, nanoTime, true);
        this.getEventQueue().dequeueAndFire(is, InputEvent.Type.KEYBOARD_EVENT);
    }

    public void onDeviceRegistered(InputSystem inputSystem) throws InputSystemException {
        this.consumePendingEvents(inputSystem, null, -1L);
    }

    public void destroyImpl() throws InputSystemException {
    }

    protected JInputKeyboard(KeyboardFactory factory, InputSourceWindow sourceWindow, EventQueue eventQueue, net.java.games.input.Keyboard keyboard) throws InputSystemException {
        super(factory, sourceWindow, eventQueue, keyboard.getName());
        this.keyboard = keyboard;
        Component[] componentArray = keyboard.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component comp = componentArray[n2];
            if (comp.getName().equals("Escape")) {
                this.keyMap.put(comp, Keys.ESCAPE);
            } else if (comp.getName().equals("F1")) {
                this.keyMap.put(comp, Keys.F1);
            } else if (comp.getName().equals("F2")) {
                this.keyMap.put(comp, Keys.F2);
            } else if (comp.getName().equals("F3")) {
                this.keyMap.put(comp, Keys.F3);
            } else if (comp.getName().equals("F4")) {
                this.keyMap.put(comp, Keys.F4);
            } else if (comp.getName().equals("F5")) {
                this.keyMap.put(comp, Keys.F5);
            } else if (comp.getName().equals("F6")) {
                this.keyMap.put(comp, Keys.F6);
            } else if (comp.getName().equals("F7")) {
                this.keyMap.put(comp, Keys.F7);
            } else if (comp.getName().equals("F8")) {
                this.keyMap.put(comp, Keys.F8);
            } else if (comp.getName().equals("F9")) {
                this.keyMap.put(comp, Keys.F9);
            } else if (comp.getName().equals("F10")) {
                this.keyMap.put(comp, Keys.F10);
            } else if (comp.getName().equals("F11")) {
                this.keyMap.put(comp, Keys.F11);
            } else if (comp.getName().equals("F12")) {
                this.keyMap.put(comp, Keys.F12);
            } else if (comp.getName().equals("SysRq")) {
                this.keyMap.put(comp, Keys.PRINTSCREEN);
            } else if (comp.getName().equals("Scroll Lock")) {
                this.keyMap.put(comp, Keys.SCROLL_LOCK);
            } else if (comp.getName().equals("Pause")) {
                this.keyMap.put(comp, Keys.PAUSE);
            } else if (comp.getName().equals("~")) {
                this.keyMap.put(comp, Keys.CIRCUMFLEX);
            } else if (comp.getName().equals("0")) {
                this.keyMap.put(comp, Keys._0);
            } else if (comp.getName().equals("1")) {
                this.keyMap.put(comp, Keys._1);
            } else if (comp.getName().equals("2")) {
                this.keyMap.put(comp, Keys._2);
            } else if (comp.getName().equals("3")) {
                this.keyMap.put(comp, Keys._3);
            } else if (comp.getName().equals("4")) {
                this.keyMap.put(comp, Keys._4);
            } else if (comp.getName().equals("5")) {
                this.keyMap.put(comp, Keys._5);
            } else if (comp.getName().equals("6")) {
                this.keyMap.put(comp, Keys._6);
            } else if (comp.getName().equals("7")) {
                this.keyMap.put(comp, Keys._7);
            } else if (comp.getName().equals("8")) {
                this.keyMap.put(comp, Keys._8);
            } else if (comp.getName().equals("9")) {
                this.keyMap.put(comp, Keys._9);
            } else if (comp.getName().equals("A")) {
                this.keyMap.put(comp, Keys.A);
            } else if (comp.getName().equals("B")) {
                this.keyMap.put(comp, Keys.B);
            } else if (comp.getName().equals("C")) {
                this.keyMap.put(comp, Keys.C);
            } else if (comp.getName().equals("D")) {
                this.keyMap.put(comp, Keys.D);
            } else if (comp.getName().equals("E")) {
                this.keyMap.put(comp, Keys.E);
            } else if (comp.getName().equals("F")) {
                this.keyMap.put(comp, Keys.F);
            } else if (comp.getName().equals("G")) {
                this.keyMap.put(comp, Keys.G);
            } else if (comp.getName().equals("H")) {
                this.keyMap.put(comp, Keys.H);
            } else if (comp.getName().equals("I")) {
                this.keyMap.put(comp, Keys.I);
            } else if (comp.getName().equals("J")) {
                this.keyMap.put(comp, Keys.J);
            } else if (comp.getName().equals("K")) {
                this.keyMap.put(comp, Keys.K);
            } else if (comp.getName().equals("L")) {
                this.keyMap.put(comp, Keys.L);
            } else if (comp.getName().equals("M")) {
                this.keyMap.put(comp, Keys.M);
            } else if (comp.getName().equals("N")) {
                this.keyMap.put(comp, Keys.N);
            } else if (comp.getName().equals("O")) {
                this.keyMap.put(comp, Keys.O);
            } else if (comp.getName().equals("P")) {
                this.keyMap.put(comp, Keys.P);
            } else if (comp.getName().equals("Q")) {
                this.keyMap.put(comp, Keys.Q);
            } else if (comp.getName().equals("R")) {
                this.keyMap.put(comp, Keys.R);
            } else if (comp.getName().equals("S")) {
                this.keyMap.put(comp, Keys.S);
            } else if (comp.getName().equals("T")) {
                this.keyMap.put(comp, Keys.T);
            } else if (comp.getName().equals("U")) {
                this.keyMap.put(comp, Keys.U);
            } else if (comp.getName().equals("V")) {
                this.keyMap.put(comp, Keys.V);
            } else if (comp.getName().equals("W")) {
                this.keyMap.put(comp, Keys.W);
            } else if (comp.getName().equals("X")) {
                this.keyMap.put(comp, Keys.X);
            } else if (comp.getName().equals("Y")) {
                this.keyMap.put(comp, Keys.Y);
            } else if (comp.getName().equals("Z")) {
                this.keyMap.put(comp, Keys.Z);
            } else if (comp.getName().equals("Tab")) {
                this.keyMap.put(comp, Keys.TAB);
            } else if (comp.getName().equals(" ")) {
                this.keyMap.put(comp, Keys.SPACE);
            } else if (comp.getName().equals("Back")) {
                this.keyMap.put(comp, Keys.BACK_SPACE);
            } else if (comp.getName().equals("Return")) {
                this.keyMap.put(comp, Keys.ENTER);
            } else if (comp.getName().equals("Left Shift")) {
                this.keyMap.put(comp, Keys.LEFT_SHIFT);
            } else if (comp.getName().equals("Right Shift")) {
                this.keyMap.put(comp, Keys.RIGHT_SHIFT);
            } else if (comp.getName().equals("Left Control")) {
                this.keyMap.put(comp, Keys.LEFT_CONTROL);
            } else if (comp.getName().equals("Right Control")) {
                this.keyMap.put(comp, Keys.RIGHT_CONTROL);
            } else if (comp.getName().equals("Left Alt")) {
                this.keyMap.put(comp, Keys.ALT);
            } else if (comp.getName().equals("Right Alt")) {
                this.keyMap.put(comp, Keys.ALT_GRAPH);
            } else if (comp.getName().equals("Caps Lock")) {
                this.keyMap.put(comp, Keys.CAPS_LOCK);
            } else if (comp.getName().equals("Insert")) {
                this.keyMap.put(comp, Keys.INSERT);
            } else if (comp.getName().equals("Delete")) {
                this.keyMap.put(comp, Keys.DELETE);
            } else if (comp.getName().equals("Home")) {
                this.keyMap.put(comp, Keys.HOME);
            } else if (comp.getName().equals("End")) {
                this.keyMap.put(comp, Keys.END);
            } else if (comp.getName().equals("Pg Up")) {
                this.keyMap.put(comp, Keys.PAGE_UP);
            } else if (comp.getName().equals("Pg Down")) {
                this.keyMap.put(comp, Keys.PAGE_DOWN);
            } else if (comp.getName().equals("Right")) {
                this.keyMap.put(comp, Keys.RIGHT);
            } else if (comp.getName().equals("Left")) {
                this.keyMap.put(comp, Keys.LEFT);
            } else if (comp.getName().equals("Up")) {
                this.keyMap.put(comp, Keys.UP);
            } else if (comp.getName().equals("Down")) {
                this.keyMap.put(comp, Keys.DOWN);
            } else if (comp.getName().equals("Num Lock")) {
                this.keyMap.put(comp, Keys.NUM_LOCK);
            } else if (comp.getName().equals("Num /")) {
                this.keyMap.put(comp, Keys.NUMPAD_DIVIDE);
            } else if (comp.getName().equals("Multiply")) {
                this.keyMap.put(comp, Keys.NUMPAD_MULTIPLY);
            } else if (comp.getName().equals("Num -")) {
                this.keyMap.put(comp, Keys.NUMPAD_SUBTRACT);
            } else if (comp.getName().equals("Num +")) {
                this.keyMap.put(comp, Keys.NUMPAD_ADD);
            } else if (comp.getName().equals("Num Enter")) {
                this.keyMap.put(comp, Keys.NUMPAD_ENTER);
            } else if (comp.getName().equals("Num .")) {
                this.keyMap.put(comp, Keys.NUMPAD_DECIMAL);
            } else if (comp.getName().equals("Num 0")) {
                this.keyMap.put(comp, Keys.NUMPAD0);
            } else if (comp.getName().equals("Num 1")) {
                this.keyMap.put(comp, Keys.NUMPAD1);
            } else if (comp.getName().equals("Num 2")) {
                this.keyMap.put(comp, Keys.NUMPAD2);
            } else if (comp.getName().equals("Num 3")) {
                this.keyMap.put(comp, Keys.NUMPAD3);
            } else if (comp.getName().equals("Num 4")) {
                this.keyMap.put(comp, Keys.NUMPAD4);
            } else if (comp.getName().equals("Num 5")) {
                this.keyMap.put(comp, Keys.NUMPAD5);
            } else if (comp.getName().equals("Num 6")) {
                this.keyMap.put(comp, Keys.NUMPAD6);
            } else if (comp.getName().equals("Num 7")) {
                this.keyMap.put(comp, Keys.NUMPAD7);
            } else if (comp.getName().equals("Num 8")) {
                this.keyMap.put(comp, Keys.NUMPAD8);
            } else if (comp.getName().equals("Num 9")) {
                this.keyMap.put(comp, Keys.NUMPAD9);
            } else if (comp.getName().equals("-")) {
                this.keyMap.put(comp, Keys.LOCAL_KEY1);
            } else if (comp.getName().equals("=")) {
                this.keyMap.put(comp, Keys.LOCAL_KEY2);
            } else if (comp.getName().equals("[")) {
                this.keyMap.put(comp, Keys.LOCAL_KEY3);
            } else if (comp.getName().equals("]")) {
                this.keyMap.put(comp, Keys.LOCAL_KEY4);
            } else if (comp.getName().equals(";")) {
                this.keyMap.put(comp, Keys.LOCAL_KEY5);
            } else if (comp.getName().equals("'")) {
                this.keyMap.put(comp, Keys.LOCAL_KEY6);
            } else if (comp.getName().equals("\\")) {
                this.keyMap.put(comp, Keys.LOCAL_KEY7);
            } else if (comp.getName().equals(",")) {
                this.keyMap.put(comp, Keys.LOCAL_KEY8);
            } else if (comp.getName().equals(".")) {
                this.keyMap.put(comp, Keys.LOCAL_KEY9);
            } else if (comp.getName().equals("/")) {
                this.keyMap.put(comp, Keys.LOCAL_KEY10);
            }
            ++n2;
        }
    }
}

